/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MdxUtil {
    private static final Pattern QUOT_PATTERN = Pattern.compile("\"", 16);

    MdxUtil() {
    }

    static String quoteForMdx(String val) {
        StringBuilder buf = new StringBuilder(val.length() + 20);
        buf.append("\"");
        buf.append(QUOT_PATTERN.matcher(val).replaceAll("\"\""));
        buf.append("\"");
        return buf.toString();
    }

    static String toString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter(sw);
        node.unparse(parseTreeWriter);
        return sw.toString();
    }

    static String mdxEncodeString(String st) {
        StringBuilder retString = new StringBuilder(st.length() + 20);
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            if (c == ']' && i + 1 < st.length() && st.charAt(i + 1) != '.') {
                retString.append(']');
            }
            retString.append(c);
        }
        return retString.toString();
    }

    static <E extends ParseTreeNode> List<E> deepCopyList(List<E> list) {
        if (list == Collections.EMPTY_LIST) {
            return list;
        }
        ArrayList<ParseTreeNode> listCopy = new ArrayList<ParseTreeNode>(list.size());
        for (ParseTreeNode e : list) {
            listCopy.add(e.deepCopy());
        }
        return listCopy;
    }
}

