/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.Arrays;
import java.util.List;
import org.olap4j.mdx.MdxUtil;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.Syntax;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallNode
implements ParseTreeNode {
    private final String name;
    private final Syntax syntax;
    private final List<ParseTreeNode> argList;
    private final ParseRegion region;
    private Type type;

    public CallNode(ParseRegion region, String name, Syntax syntax, List<ParseTreeNode> args) {
        this.region = region;
        assert (name != null);
        assert (syntax != null);
        assert (args != null);
        this.name = name;
        this.syntax = syntax;
        this.argList = args;
        switch (syntax) {
            case Braces: {
                assert (name.equals("{}"));
                break;
            }
            case Parentheses: {
                assert (name.equals("()"));
                break;
            }
            case Internal: {
                assert (name.startsWith("$"));
                break;
            }
            case Empty: {
                assert (name.equals(""));
                break;
            }
            default: {
                assert (!(name.startsWith("$") || name.equals("{}") || name.equals("()")));
                break;
            }
        }
    }

    public CallNode(ParseRegion region, String name, Syntax syntax, ParseTreeNode ... args) {
        this(region, name, syntax, Arrays.asList(args));
    }

    @Override
    public ParseRegion getRegion() {
        return this.region;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        this.syntax.unparse(this.name, this.argList, writer);
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        T o = visitor.visit(this);
        for (ParseTreeNode arg : this.argList) {
            arg.accept(visitor);
        }
        return o;
    }

    public String getOperatorName() {
        return this.name;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public List<ParseTreeNode> getArgList() {
        return this.argList;
    }

    @Override
    public CallNode deepCopy() {
        return new CallNode(this.region, this.name, this.syntax, MdxUtil.deepCopyList(this.argList));
    }
}

