/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.olap4j.CellSet;
import org.olap4j.CellSetMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapParameterMetaData;
import org.olap4j.OlapStatement;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.driver.xmla.XmlaHelper;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.driver.xmla.XmlaOlap4jStatement;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.type.BooleanType;
import org.olap4j.type.CubeType;
import org.olap4j.type.DecimalType;
import org.olap4j.type.DimensionType;
import org.olap4j.type.HierarchyType;
import org.olap4j.type.LevelType;
import org.olap4j.type.MemberType;
import org.olap4j.type.NullType;
import org.olap4j.type.NumericType;
import org.olap4j.type.SetType;
import org.olap4j.type.StringType;
import org.olap4j.type.SymbolType;
import org.olap4j.type.TupleType;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jPreparedStatement
extends XmlaOlap4jStatement
implements PreparedOlapStatement,
OlapParameterMetaData {
    final XmlaOlap4jCellSetMetaData cellSetMetaData;
    private final String mdx;

    XmlaOlap4jPreparedStatement(XmlaOlap4jConnection olap4jConnection, String mdx) throws OlapException {
        super(olap4jConnection);
        OlapStatement statement = olap4jConnection.createStatement();
        try {
            CellSet cellSet = statement.executeOlapQuery(mdx);
            XmlaOlap4jCellSetMetaData cellSetMetaData1 = (XmlaOlap4jCellSetMetaData)cellSet.getMetaData();
            this.cellSetMetaData = cellSetMetaData1.cloneFor(this);
            cellSet.close();
            statement.close();
        }
        catch (SQLException e) {
            throw this.getHelper().createException("Error while preparing statement '" + mdx + "'", e);
        }
        this.mdx = mdx;
    }

    private final XmlaHelper getHelper() {
        return this.olap4jConnection.helper;
    }

    @Override
    public CellSet executeOlapQuery(String mdx) throws OlapException {
        return super.executeOlapQuery(mdx);
    }

    @Override
    public CellSet executeQuery() throws OlapException {
        return this.executeOlapQuery(this.mdx);
    }

    @Override
    public OlapParameterMetaData getParameterMetaData() throws OlapException {
        return this;
    }

    @Override
    public Cube getCube() {
        return this.cellSetMetaData.cube;
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getParameter(parameterIndex).setValue(null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getParameter(parameterIndex).setValue(Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void unset(int parameterIndex) throws SQLException {
        this.getParameter(parameterIndex).unset();
    }

    @Override
    public boolean isSet(int parameterIndex) throws SQLException {
        return this.getParameter(parameterIndex).isSet();
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getParameter(parameterIndex).setValue(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        Parameter parameter = this.getParameter(parameterIndex);
        parameter.setValue(x);
    }

    @Override
    public boolean execute() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellSetMetaData getMetaData() {
        return this.cellSetMetaData;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getParameterName(int param) throws OlapException {
        Parameter paramDef = this.getParameter(param);
        return paramDef.getName();
    }

    private Parameter getParameter(int param) throws OlapException {
        List<Parameter> parameters = this.getParameters();
        if (param < 1 || param > parameters.size()) {
            throw this.getHelper().createException("parameter ordinal " + param + " out of range");
        }
        return parameters.get(param - 1);
    }

    private List<Parameter> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public Type getParameterOlapType(int param) throws OlapException {
        throw Olap4jUtil.needToImplement(this);
    }

    @Override
    public int getParameterCount() {
        return this.getParameters().size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        Type type = this.getParameterOlapType(param);
        return type instanceof NumericType;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        Type type = this.getParameterOlapType(param);
        if (type instanceof NumericType) {
            return 0;
        }
        if (type instanceof StringType) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        Type type = this.getParameterOlapType(param);
        if (type instanceof NumericType) {
            return 2;
        }
        if (type instanceof StringType) {
            return 12;
        }
        if (type instanceof NullType) {
            return 0;
        }
        return 1111;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        Type type = this.getParameterOlapType(param);
        return type.toString();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        Type type = this.getParameterOlapType(param);
        return this.foo(new TypeHelper<Class>(){

            @Override
            public Class booleanType(BooleanType type) {
                return Boolean.class;
            }

            @Override
            public Class<Cube> cubeType(CubeType cubeType) {
                return Cube.class;
            }

            @Override
            public Class<Number> decimalType(DecimalType decimalType) {
                return Number.class;
            }

            @Override
            public Class<Dimension> dimensionType(DimensionType dimensionType) {
                return Dimension.class;
            }

            @Override
            public Class<Hierarchy> hierarchyType(HierarchyType hierarchyType) {
                return Hierarchy.class;
            }

            @Override
            public Class<Level> levelType(LevelType levelType) {
                return Level.class;
            }

            @Override
            public Class<Member> memberType(MemberType memberType) {
                return Member.class;
            }

            @Override
            public Class<Void> nullType(NullType nullType) {
                return Void.class;
            }

            @Override
            public Class<Number> numericType(NumericType numericType) {
                return Number.class;
            }

            @Override
            public Class<Iterable> setType(SetType setType) {
                return Iterable.class;
            }

            @Override
            public Class<String> stringType(StringType stringType) {
                return String.class;
            }

            @Override
            public Class<Member[]> tupleType(TupleType tupleType) {
                return Member[].class;
            }

            @Override
            public Class symbolType(SymbolType symbolType) {
                throw new UnsupportedOperationException();
            }
        }, type).getName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        throw Olap4jUtil.needToImplement(this);
    }

    <T> T foo(TypeHelper<T> helper, Type type) {
        if (type instanceof BooleanType) {
            return helper.booleanType((BooleanType)type);
        }
        if (type instanceof CubeType) {
            return helper.cubeType((CubeType)type);
        }
        if (type instanceof DecimalType) {
            return helper.decimalType((DecimalType)type);
        }
        if (type instanceof DimensionType) {
            return helper.dimensionType((DimensionType)type);
        }
        if (type instanceof HierarchyType) {
            return helper.hierarchyType((HierarchyType)type);
        }
        if (type instanceof LevelType) {
            return helper.levelType((LevelType)type);
        }
        if (type instanceof MemberType) {
            return helper.memberType((MemberType)type);
        }
        if (type instanceof NullType) {
            return helper.nullType((NullType)type);
        }
        if (type instanceof NumericType) {
            return helper.numericType((NumericType)type);
        }
        if (type instanceof SetType) {
            return helper.setType((SetType)type);
        }
        if (type instanceof StringType) {
            return helper.stringType((StringType)type);
        }
        if (type instanceof TupleType) {
            return helper.tupleType((TupleType)type);
        }
        if (type instanceof SymbolType) {
            return helper.symbolType((SymbolType)type);
        }
        throw new UnsupportedOperationException();
    }

    private static interface Parameter {
        public String getName();

        public void setValue(Object var1);

        public void unset();

        public boolean isSet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TypeHelper<T> {
        public T booleanType(BooleanType var1);

        public T cubeType(CubeType var1);

        public T decimalType(DecimalType var1);

        public T dimensionType(DimensionType var1);

        public T hierarchyType(HierarchyType var1);

        public T levelType(LevelType var1);

        public T memberType(MemberType var1);

        public T nullType(NullType var1);

        public T numericType(NumericType var1);

        public T setType(SetType var1);

        public T stringType(StringType var1);

        public T tupleType(TupleType var1);

        public T symbolType(SymbolType var1);
    }
}

