/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.list;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.FormListener;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.convert.ConvertException;
import com.tonbeller.wcf.ui.ListItem;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.SoftException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class MappedListBox
implements FormListener {
    List entries = new ArrayList();
    Element listBox;
    private static Logger logger = Logger.getLogger(MappedListBox.class);

    public MappedListBox(Element listBox) {
        this.listBox = listBox;
    }

    public void revert(RequestContext context) {
        DomUtils.removeChildElements(this.listBox);
        for (Item item : this.entries) {
            Element elem = ListItem.addListItem(this.listBox);
            item.setElement(elem);
            ListItem.setId(elem, item.getId());
            ListItem.setLabel(elem, item.getLabel());
            if (!item.isSelected()) continue;
            ListItem.setSelected(elem, true);
        }
    }

    public boolean validate(RequestContext context) {
        try {
            context.getConverter().validate(context.getParameters(), context.getFileParameters(), this.listBox, null);
            for (Item item : this.entries) {
                item.setSelected(ListItem.isSelected(item.getElement()));
            }
        }
        catch (ConvertException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new SoftException(e);
        }
        return true;
    }

    public Item getSingleSelection() {
        for (Item item : this.entries) {
            if (!item.isSelected()) continue;
            return item;
        }
        return null;
    }

    public void sortByLabel() {
        Collections.sort(this.entries, new Comparator(){

            public int compare(Object o1, Object o2) {
                String l1 = ((Item)o1).getLabel();
                String l2 = ((Item)o2).getLabel();
                return Resources.instance().getCollator().compare(l1, l2);
            }
        });
    }

    public List getEntries() {
        return this.entries;
    }

    public void setEntries(List entries) {
        this.entries = entries;
    }

    public static class Item {
        String label;
        String id;
        Object value;
        boolean selected;
        Element element;

        public Item(String label, Object value) {
            this.label = label;
            this.value = value;
            this.id = DomUtils.randomId();
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.value;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public Element getElement() {
            return this.element;
        }

        public void setElement(Element element) {
            this.element = element;
        }
    }
}

