/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.metadata;

import java.util.HashMap;
import java.util.Map;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Member;

public interface Measure
extends Member {
    public Aggregator getAggregator();

    public Datatype getDatatype();

    public boolean isVisible();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Aggregator {
        SUM(1),
        COUNT(2),
        MIN(3),
        MAX(4),
        AVG(5),
        VAR(6),
        STD(7),
        CALCULATED(127),
        UNKNOWN(0);

        private final int xmlaOrdinal;
        private static final Map<Integer, Aggregator> xmlaMap;

        private Aggregator(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        public final int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        public static Aggregator forXmlaOrdinal(int xmlaOrdinal) {
            return xmlaMap.get(xmlaOrdinal);
        }

        static {
            xmlaMap = new HashMap<Integer, Aggregator>();
            for (Aggregator aggregator : Aggregator.values()) {
                xmlaMap.put(aggregator.xmlaOrdinal, aggregator);
            }
        }
    }
}

