/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.path.PathTrackingWriter;
import ofc4j.model.elements.BarChart;
import ofc4j.model.elements.FilledBarChart;
import ofc4j.model.elements.SketchBarChart;
import ofc4j.util.ConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarConverter
extends ConverterBase<BarChart.Bar> {
    @Override
    public void convert(BarChart.Bar b, PathTrackingWriter writer, MarshallingContext mc) {
        this.writeNode(writer, "top", b.getTop());
        this.writeNode(writer, "bottom", b.getBottom());
        this.writeNode(writer, "colour", b.getColour());
        this.writeNode(writer, "tip", b.getTooltip());
        if (b instanceof FilledBarChart.Bar) {
            this.writeNode(writer, "outline-colour", ((FilledBarChart.Bar)b).getOutlineColour());
        }
        if (b instanceof SketchBarChart.Bar) {
            this.writeNode(writer, "offset", ((SketchBarChart.Bar)b).getFunFactor());
        }
    }

    public boolean canConvert(Class clazz) {
        return BarChart.Bar.class.isAssignableFrom(clazz);
    }
}

