/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.model.elements;

import java.util.Arrays;
import java.util.List;
import ofc4j.model.elements.Element;
import ofc4j.model.metadata.Converter;
import ofc4j.util.HorizontalBarChartBarConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalBarChart
extends Element {
    private String colour;

    public HorizontalBarChart() {
        super("hbar");
    }

    public String getColour() {
        return this.colour;
    }

    public HorizontalBarChart setColour(String colour) {
        this.colour = colour;
        return this;
    }

    public HorizontalBarChart addBars(Bar ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }

    public HorizontalBarChart addBars(List<Bar> values) {
        this.getValues().addAll(values);
        return this;
    }

    public HorizontalBarChart addValues(Number ... rightValues) {
        Bar[] values = new Bar[rightValues.length];
        for (int i = 0; i < rightValues.length; ++i) {
            values[i] = new Bar(rightValues[i]);
        }
        return this.addBars(values);
    }

    public HorizontalBarChart addValues(List<Number> rightValues) {
        this.getValues().addAll(rightValues);
        return this;
    }

    public HorizontalBarChart addBar(Number left, Number right) {
        return this.addBars(new Bar(left, right));
    }

    @Converter(value=HorizontalBarChartBarConverter.class)
    public static class Bar {
        private final Number right;
        private Number left;

        public Bar(Number right) {
            this(null, right);
        }

        public Bar(Number left, Number right) {
            if (right == null) {
                throw new NullPointerException("Field is mandatory.");
            }
            this.right = right;
            this.setLeft(left);
        }

        public Number getRight() {
            return this.right;
        }

        public Number getLeft() {
            return this.left;
        }

        public Bar setLeft(Number left) {
            this.left = left;
            return this;
        }
    }
}

