/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.model;

import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModelDecorator;
import com.tonbeller.jpivot.olap.model.Result;
import org.apache.log4j.Logger;

public class CachingOlapModel
extends OlapModelDecorator
implements ModelChangeListener {
    private static Logger logger = Logger.getLogger(CachingOlapModel.class);
    Result result = null;

    public void modelChanged(ModelChangeEvent e) {
        this.result = null;
    }

    public void structureChanged(ModelChangeEvent e) {
        this.result = null;
    }

    public Result getResult() throws OlapException {
        logger.info((Object)("CachingOlapModel: " + (this.result == null ? "getting Result from OLAP Server" : "using cached result")));
        if (this.result == null) {
            long t1 = System.currentTimeMillis();
            this.result = super.getResult();
            long t2 = System.currentTimeMillis();
            logger.info((Object)("Execute Query took " + (t2 - t1) + " millisec"));
        }
        return this.result;
    }

    public Model decorate(Model modelToDecorate) {
        modelToDecorate.addModelChangeListener(this);
        return super.decorate(modelToDecorate);
    }
}

