/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilterContainer;
import net.sf.jasperreports.engine.export.ExporterFilterFactory;
import net.sf.jasperreports.engine.export.ExporterFilterFactoryUtil;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.util.JRProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExporterFilterFactory
implements ExporterFilterFactory {
    public static final String PROPERTY_EXPORTER_FILTER_FACTORY_PREFIX = "net.sf.jasperreports.export.filter.factory.";

    @Override
    public ExporterFilter getFilter(JRExporterContext exporterContext) throws JRException {
        List<ExporterFilterFactory> factories = this.getAllFilterFactories(exporterContext.getExportedReport());
        ArrayList<ExporterFilter> filters = new ArrayList<ExporterFilter>(factories.size());
        for (ExporterFilterFactory factory : factories) {
            ExporterFilter filter = factory.getFilter(exporterContext);
            if (filter == null) continue;
            filters.add(filter);
        }
        ExporterFilter filter = filters.isEmpty() ? null : (filters.size() == 1 ? (ExporterFilter)filters.get(0) : new ExporterFilterContainer(filters));
        return filter;
    }

    protected List<ExporterFilterFactory> getAllFilterFactories(JasperPrint report) throws JRException {
        List<JRProperties.PropertySuffix> factoryProps = JRProperties.getAllProperties(report, PROPERTY_EXPORTER_FILTER_FACTORY_PREFIX);
        ArrayList<ExporterFilterFactory> factories = new ArrayList<ExporterFilterFactory>(factoryProps.size());
        for (JRProperties.PropertySuffix prop : factoryProps) {
            ExporterFilterFactory factory = this.getFilterFactory(prop.getValue());
            factories.add(factory);
        }
        return factories;
    }

    protected ExporterFilterFactory getFilterFactory(String factoryClassName) throws JRException {
        return ExporterFilterFactoryUtil.getFilterFactory(factoryClassName);
    }
}

