/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ParameterContributorFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.repo.RepositoryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataAdapterParameterContributorFactory
implements ParameterContributorFactory {
    private static final DataAdapterParameterContributorFactory INSTANCE = new DataAdapterParameterContributorFactory();

    private DataAdapterParameterContributorFactory() {
    }

    public static DataAdapterParameterContributorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public List<ParameterContributor> getContributors(ParameterContributorContext context) throws JRException {
        ArrayList<ParameterContributor> contributors = new ArrayList<ParameterContributor>();
        String dataAdapterUri = JRProperties.getProperty(context.getDataset(), "net.sf.jasperreports.data.adapter");
        if (dataAdapterUri != null) {
            DataAdapter dataAdapter = (DataAdapter)RepositoryUtil.getResource(dataAdapterUri, DataAdapter.class);
            DataAdapterService dataAdapterService = DataAdapterServiceUtil.getDataAdapterService(dataAdapter);
            return Collections.singletonList(dataAdapterService);
        }
        return contributors;
    }

    protected JRAbstractScriptlet getScriptlet(String scriptletClassName) throws JRException {
        JRAbstractScriptlet scriptlet = null;
        try {
            Class<?> scriptletClass = JRClassLoader.loadClassForName(scriptletClassName);
            scriptlet = (JRAbstractScriptlet)scriptletClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Error loading scriptlet class : " + scriptletClassName, e);
        }
        catch (Exception e) {
            throw new JRException("Error creating scriptlet class instance : " + scriptletClassName, e);
        }
        return scriptlet;
    }
}

