/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JROriginProvider;
import net.sf.jasperreports.engine.fill.JRRecordedValues;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyleResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRFillElement
implements JRElement,
JRFillCloneable,
JRStyleSetter {
    protected JRElement parent;
    protected Map<JRStyle, JRTemplateElement> templates = new HashMap<JRStyle, JRTemplateElement>();
    protected JRBaseFiller filler;
    protected JRFillExpressionEvaluator expressionEvaluator;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRGroup printWhenGroupChanges;
    protected JRFillElementGroup elementGroup;
    protected JRFillBand band;
    protected JROriginProvider originProvider;
    protected int elementId;
    private boolean isPrintWhenExpressionNull = true;
    private boolean isPrintWhenTrue = true;
    private boolean isToPrint = true;
    private boolean isReprinted;
    private boolean isAlreadyPrinted;
    private Collection<JRElement> dependantElements = new ArrayList<JRElement>();
    private int relativeY;
    private int stretchHeight;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean isValueRepeating;
    protected byte currentEvaluation;
    protected Map<JREvaluationTime, DelayedEvaluations> delayedEvaluationsMap;
    protected JRFillElementContainer conditionalStylesContainer;
    protected JRStyle initStyle;
    protected JRStyle currentStyle;
    private boolean shrinkable;
    protected JRPropertiesMap staticProperties;
    protected JRPropertiesMap dynamicProperties;
    protected JRPropertiesMap mergedProperties;

    protected JRFillElement(JRBaseFiller filler, JRElement element, JRFillObjectFactory factory) {
        factory.put(element, this);
        this.parent = element;
        this.filler = filler;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        this.elementId = filler.getFillContext().generateFillElementId();
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = (JRFillElementGroup)factory.getVisitResult(element.getElementGroup());
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.mergedProperties = this.staticProperties = element.hasProperties() ? element.getPropertiesMap().cloneProperties() : null;
        factory.registerDelayedStyleSetter((JRStyleSetter)this, this.parent);
    }

    protected JRFillElement(JRFillElement element, JRFillCloneFactory factory) {
        factory.put(element, this);
        this.parent = element.parent;
        this.filler = element.filler;
        this.expressionEvaluator = element.expressionEvaluator;
        this.defaultStyleProvider = element.defaultStyleProvider;
        this.originProvider = element.originProvider;
        this.elementId = element.elementId;
        this.printWhenGroupChanges = element.printWhenGroupChanges;
        this.elementGroup = (JRFillElementGroup)factory.getClone((JRFillElementGroup)element.getElementGroup());
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.templates = element.templates;
        this.initStyle = element.initStyle;
        this.shrinkable = element.shrinkable;
        this.mergedProperties = this.staticProperties = element.staticProperties == null ? null : element.staticProperties.cloneProperties();
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    @Override
    public String getKey() {
        return this.parent.getKey();
    }

    @Override
    public PositionTypeEnum getPositionTypeValue() {
        return this.parent.getPositionTypeValue();
    }

    @Override
    public void setPositionType(PositionTypeEnum positionType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StretchTypeEnum getStretchTypeValue() {
        return this.parent.getStretchTypeValue();
    }

    @Override
    public void setStretchType(StretchTypeEnum stretchType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrintRepeatedValues() {
        return this.parent.isPrintRepeatedValues();
    }

    @Override
    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.OPAQUE);
    }

    @Override
    public ModeEnum getOwnModeValue() {
        return this.parent.getOwnModeValue();
    }

    @Override
    public void setMode(ModeEnum modeValue) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isRemoveLineWhenBlank() {
        return this.parent.isRemoveLineWhenBlank();
    }

    @Override
    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
    }

    @Override
    public boolean isPrintInFirstWholeBand() {
        return this.parent.isPrintInFirstWholeBand();
    }

    @Override
    public void setPrintInFirstWholeBand(boolean isPrint) {
    }

    @Override
    public boolean isPrintWhenDetailOverflows() {
        return this.parent.isPrintWhenDetailOverflows();
    }

    @Override
    public void setPrintWhenDetailOverflows(boolean isPrint) {
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.parent.getOwnForecolor();
    }

    @Override
    public void setForecolor(Color forecolor) {
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.parent.getOwnBackcolor();
    }

    @Override
    public void setBackcolor(Color backcolor) {
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.parent.getPrintWhenExpression();
    }

    @Override
    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.isPrintWhenExpressionNull;
    }

    protected void setPrintWhenExpressionNull(boolean isPrintWhenExpressionNull) {
        this.isPrintWhenExpressionNull = isPrintWhenExpressionNull;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected boolean isToPrint() {
        return this.isToPrint;
    }

    protected void setToPrint(boolean isToPrint) {
        this.isToPrint = isToPrint;
    }

    protected boolean isReprinted() {
        return this.isReprinted;
    }

    protected void setReprinted(boolean isReprinted) {
        this.isReprinted = isReprinted;
    }

    protected boolean isAlreadyPrinted() {
        return this.isAlreadyPrinted;
    }

    protected void setAlreadyPrinted(boolean isAlreadyPrinted) {
        this.isAlreadyPrinted = isAlreadyPrinted;
    }

    protected JRElement[] getGroupElements() {
        JRElement[] groupElements = null;
        if (this.elementGroup != null) {
            groupElements = this.elementGroup.getElements();
        }
        return groupElements;
    }

    protected Collection<JRElement> getDependantElements() {
        return this.dependantElements;
    }

    protected void addDependantElement(JRElement element) {
        this.dependantElements.add(element);
    }

    protected int getRelativeY() {
        return this.relativeY;
    }

    protected void setRelativeY(int relativeY) {
        this.relativeY = relativeY;
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight > this.getHeight() || this.shrinkable && this.isRemoveLineWhenBlank() ? stretchHeight : this.getHeight();
    }

    protected JRFillBand getBand() {
        return this.band;
    }

    protected void setBand(JRFillBand band) {
        this.band = band;
        if (this.originProvider == null) {
            this.setOriginProvider(band);
        }
    }

    protected void reset() {
        this.relativeY = this.y;
        this.stretchHeight = this.height;
        if (this.elementGroup != null) {
            this.elementGroup.reset();
        }
    }

    protected void setCurrentEvaluation(byte evaluation) {
        this.currentEvaluation = evaluation;
    }

    protected abstract void evaluate(byte var1) throws JRException;

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isExprNull = true;
        boolean isExprTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            isExprNull = false;
            Boolean printWhenExpressionValue = (Boolean)this.evaluateExpression(expression, evaluation);
            isExprTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenExpressionNull(isExprNull);
        this.setPrintWhenTrue(isExprTrue);
    }

    protected abstract void rewind() throws JRException;

    protected abstract JRPrintElement fill() throws JRException;

    protected JRTemplateElement getElementTemplate() {
        JRStyle style = this.getStyle();
        JRTemplateElement template = this.getTemplate(style);
        if (template == null) {
            template = this.createElementTemplate();
            this.transferProperties(template);
            template = this.filler.fillContext.deduplicate(template);
            this.registerTemplate(style, template);
        }
        return template;
    }

    protected abstract JRTemplateElement createElementTemplate();

    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        this.setReprinted(false);
        return false;
    }

    protected void stretchElement(int bandStretch) {
        switch (this.getStretchTypeValue()) {
            case RELATIVE_TO_BAND_HEIGHT: {
                this.setStretchHeight(this.getHeight() + bandStretch);
                break;
            }
            case RELATIVE_TO_TALLEST_OBJECT: {
                if (this.elementGroup == null) break;
                this.setStretchHeight(this.getHeight() + this.elementGroup.getStretchHeightDiff());
                break;
            }
        }
    }

    protected void moveDependantElements() {
        Collection<JRElement> elements = this.getDependantElements();
        if (elements != null && elements.size() > 0) {
            Object var2_2 = null;
            int diffY = 0;
            for (JRFillElement jRFillElement : elements) {
                diffY = jRFillElement.getY() - this.getY() - this.getHeight() - (jRFillElement.getRelativeY() - this.getRelativeY() - this.getStretchHeight());
                if (diffY < 0) {
                    diffY = 0;
                }
                jRFillElement.setRelativeY(jRFillElement.getRelativeY() + diffY);
            }
        }
    }

    protected abstract void resolveElement(JRPrintElement var1, byte var2) throws JRException;

    protected void performDelayedEvaluation(JRPrintElement element, byte evaluation) throws JRException {
        if (this.isDelayedStyleEvaluation()) {
            JRStyle evaluatedStyle;
            JRStyle elementStyle = this.initStyle;
            if (elementStyle == null) {
                elementStyle = this.filler.getDefaultStyle();
            }
            if (elementStyle != null && (evaluatedStyle = this.conditionalStylesContainer.evaluateConditionalStyle(elementStyle, evaluation)) != element.getStyle()) {
                this.currentStyle = evaluatedStyle;
                JRTemplateElement newTemplate = this.getElementTemplate();
                ((JRTemplatePrintElement)element).updateElementTemplate(newTemplate);
            }
        }
        this.resolveElement(element, evaluation);
        this.currentStyle = null;
    }

    public final Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.expressionEvaluator.evaluate(expression, evaluation);
    }

    protected boolean isValueRepeating() {
        return this.isValueRepeating;
    }

    protected void setValueRepeating(boolean isValueRepeating) {
        this.isValueRepeating = isValueRepeating;
    }

    protected JRFillVariable getVariable(String variableName) {
        return this.filler.getVariable(variableName);
    }

    protected JRFillField getField(String fieldName) {
        return this.filler.getField(fieldName);
    }

    protected EvaluationTimeEnum getEvaluationTimeValue() {
        return EvaluationTimeEnum.NOW;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation, JREvaluationTime evaluationTime) throws JRException {
        EvaluationTimeEnum evaluationTimeType = this.getEvaluationTimeValue();
        switch (evaluationTimeType) {
            case NOW: {
                break;
            }
            case AUTO: {
                this.delayedEvaluate((JRRecordedValuesPrintElement)element, evaluationTime, evaluation);
                break;
            }
            default: {
                this.performDelayedEvaluation(element, evaluation);
            }
        }
    }

    protected void initDelayedEvaluations() {
        if (this.getEvaluationTimeValue() == EvaluationTimeEnum.AUTO && this.delayedEvaluationsMap == null) {
            this.delayedEvaluationsMap = new HashMap<JREvaluationTime, DelayedEvaluations>();
            this.collectDelayedEvaluations();
        }
    }

    protected void collectDelayedEvaluations() {
        if (this.isDelayedStyleEvaluation()) {
            this.collectStyleDelayedEvaluations();
        }
    }

    protected void collectStyleDelayedEvaluations() {
        JRStyle elementStyle = this.initStyle;
        if (elementStyle == null) {
            elementStyle = this.filler.getDefaultStyle();
        }
        if (elementStyle != null) {
            for (JRStyle style = elementStyle; style != null; style = style.getStyle()) {
                this.collectDelayedEvaluations(style);
            }
        }
    }

    protected void collectDelayedEvaluations(JRStyle style) {
        JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
        if (conditionalStyles != null && conditionalStyles.length > 0) {
            for (int i = 0; i < conditionalStyles.length; ++i) {
                this.collectDelayedEvaluations(conditionalStyles[i].getConditionExpression());
            }
        }
    }

    protected void collectDelayedEvaluations(JRExpression expression) {
        JRExpressionChunk[] chunks;
        if (expression != null && (chunks = expression.getChunks()) != null) {
            block4: for (int i = 0; i < chunks.length; ++i) {
                JRExpressionChunk chunk = chunks[i];
                switch (chunk.getType()) {
                    case 3: {
                        DelayedEvaluations delayedEvaluations = this.getDelayedEvaluations(JREvaluationTime.EVALUATION_TIME_NOW);
                        delayedEvaluations.fields.add(chunk.getText());
                        continue block4;
                    }
                    case 4: {
                        JREvaluationTime time = this.autogetVariableEvaluationTime(chunk.getText());
                        DelayedEvaluations delayedEvaluations = this.getDelayedEvaluations(time);
                        delayedEvaluations.variables.add(chunk.getText());
                        continue block4;
                    }
                }
            }
        }
    }

    private DelayedEvaluations getDelayedEvaluations(JREvaluationTime time) {
        DelayedEvaluations delayedEvaluations = this.delayedEvaluationsMap.get(time);
        if (delayedEvaluations == null) {
            delayedEvaluations = new DelayedEvaluations();
            this.delayedEvaluationsMap.put(time, delayedEvaluations);
        }
        return delayedEvaluations;
    }

    private JREvaluationTime autogetVariableEvaluationTime(String variableName) {
        JREvaluationTime evaluationTime;
        JRFillVariable variable = this.getVariable(variableName);
        switch (variable.getResetTypeValue()) {
            case REPORT: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_REPORT;
                break;
            }
            case PAGE: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_PAGE;
                break;
            }
            case COLUMN: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_COLUMN;
                break;
            }
            case GROUP: {
                evaluationTime = JREvaluationTime.getGroupEvaluationTime(variable.getResetGroup().getName());
                break;
            }
            default: {
                evaluationTime = JREvaluationTime.EVALUATION_TIME_NOW;
            }
        }
        if (!evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW) && this.band.isNowEvaluationTime(evaluationTime)) {
            evaluationTime = JREvaluationTime.EVALUATION_TIME_NOW;
        }
        if (variable.getCalculationValue() == CalculationEnum.SYSTEM && evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW) && this.band.isVariableUsedInSubreportReturns(variableName)) {
            evaluationTime = JREvaluationTime.getBandEvaluationTime(this.band);
        }
        return evaluationTime;
    }

    protected void initDelayedEvaluationPrint(JRRecordedValuesPrintElement printElement) throws JRException {
        for (JREvaluationTime evaluationTime : this.delayedEvaluationsMap.keySet()) {
            if (evaluationTime.equals(JREvaluationTime.EVALUATION_TIME_NOW)) continue;
            this.filler.addBoundElement(this, printElement, evaluationTime);
        }
        printElement.initRecordedValues(this.delayedEvaluationsMap.keySet());
        if (this.delayedEvaluationsMap.containsKey(JREvaluationTime.EVALUATION_TIME_NOW)) {
            this.delayedEvaluate(printElement, JREvaluationTime.EVALUATION_TIME_NOW, this.currentEvaluation);
        }
    }

    protected void delayedEvaluate(JRRecordedValuesPrintElement printElement, JREvaluationTime evaluationTime, byte evaluation) throws JRException {
        JRRecordedValues recordedValues = printElement.getRecordedValues();
        if (!recordedValues.lastEvaluationTime()) {
            DelayedEvaluations delayedEvaluations = this.delayedEvaluationsMap.get(evaluationTime);
            for (String fieldName : delayedEvaluations.fields) {
                JRFillField field = this.getField(fieldName);
                recordedValues.recordFieldValue(fieldName, field.getValue(evaluation));
            }
            for (String variableName : delayedEvaluations.variables) {
                JRFillVariable variable = this.getVariable(variableName);
                recordedValues.recordVariableValue(variableName, variable.getValue(evaluation));
            }
        }
        recordedValues.doneEvaluation(evaluationTime);
        if (recordedValues.finishedEvaluations()) {
            this.overwriteWithRecordedValues(recordedValues, evaluation);
            this.performDelayedEvaluation(printElement, evaluation);
            this.restoreValues(recordedValues, evaluation);
            printElement.deleteRecordedValues();
        }
    }

    private void overwriteWithRecordedValues(JRRecordedValues recordedValues, byte evaluation) {
        Map<String, Object> variableValues;
        Map<String, Object> fieldValues = recordedValues.getRecordedFieldValues();
        if (fieldValues != null) {
            for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
                String fieldName = entry.getKey();
                Object fieldValue = entry.getValue();
                JRFillField field = this.getField(fieldName);
                field.overwriteValue(fieldValue, evaluation);
            }
        }
        if ((variableValues = recordedValues.getRecordedVariableValues()) != null) {
            for (Map.Entry<String, Object> entry : variableValues.entrySet()) {
                String variableName = entry.getKey();
                Object variableValue = entry.getValue();
                JRFillVariable variable = this.getVariable(variableName);
                variable.overwriteValue(variableValue, evaluation);
            }
        }
    }

    private void restoreValues(JRRecordedValues recordedValues, byte evaluation) {
        Map<String, Object> variableValues;
        Map<String, Object> fieldValues = recordedValues.getRecordedFieldValues();
        if (fieldValues != null) {
            for (String fieldName : fieldValues.keySet()) {
                JRFillField field = this.getField(fieldName);
                field.restoreValue(evaluation);
            }
        }
        if ((variableValues = recordedValues.getRecordedVariableValues()) != null) {
            for (String variableName : variableValues.keySet()) {
                JRFillVariable variable = this.getVariable(variableName);
                variable.restoreValue(evaluation);
            }
        }
    }

    protected void setConditionalStylesContainer(JRFillElementContainer conditionalStylesContainer) {
        this.conditionalStylesContainer = conditionalStylesContainer;
    }

    @Override
    public JRStyle getStyle() {
        if (this.currentStyle != null) {
            return this.currentStyle;
        }
        JRStyle crtStyle = this.initStyle;
        boolean isUsingDefaultStyle = false;
        if (crtStyle == null) {
            crtStyle = this.filler.getDefaultStyle();
            isUsingDefaultStyle = true;
        }
        JRStyle evalStyle = crtStyle;
        if (this.conditionalStylesContainer != null) {
            evalStyle = this.conditionalStylesContainer.getEvaluatedConditionalStyle(crtStyle);
        }
        if (isUsingDefaultStyle && evalStyle == crtStyle) {
            evalStyle = null;
        }
        return evalStyle;
    }

    protected JRTemplateElement getTemplate(JRStyle style) {
        return this.templates.get(style);
    }

    protected void registerTemplate(JRStyle style, JRTemplateElement template) {
        this.templates.put(style, template);
    }

    protected final void setShrinkable(boolean shrinkable) {
        this.shrinkable = shrinkable;
    }

    protected void stretchHeightFinal() {
    }

    protected boolean isEvaluateNow() {
        boolean evaluateNow;
        switch (this.getEvaluationTimeValue()) {
            case NOW: {
                evaluateNow = true;
                break;
            }
            case AUTO: {
                evaluateNow = this.isAutoEvaluateNow();
                break;
            }
            default: {
                evaluateNow = false;
            }
        }
        return evaluateNow;
    }

    protected boolean isAutoEvaluateNow() {
        return this.delayedEvaluationsMap == null || this.delayedEvaluationsMap.isEmpty() || this.delayedEvaluationsMap.size() == 1 && this.delayedEvaluationsMap.containsKey(JREvaluationTime.EVALUATION_TIME_NOW);
    }

    protected boolean isEvaluateAuto() {
        return this.getEvaluationTimeValue() == EvaluationTimeEnum.AUTO && !this.isAutoEvaluateNow();
    }

    @Override
    public String getStyleNameReference() {
        return null;
    }

    @Override
    public void setStyle(JRStyle style) {
        this.initStyle = style;
        this.conditionalStylesContainer.collectConditionalStyle(style);
    }

    @Override
    public void setStyleNameReference(String name) {
        throw new UnsupportedOperationException("Style name references not allowed at fill time");
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone(JRElementGroup parentGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasProperties() {
        return this.mergedProperties != null && this.mergedProperties.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.mergedProperties;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return this.filler.getJasperReport();
    }

    @Override
    public JRPropertyExpression[] getPropertyExpressions() {
        return this.parent.getPropertyExpressions();
    }

    protected void transferProperties(JRTemplateElement template) {
        JRProperties.transferProperties(this.parent, (JRPropertiesHolder)template, "net.sf.jasperreports.print.transfer.");
    }

    protected void transferProperties(JRPrintElement element) {
        JRProperties.transferProperties(this.dynamicProperties, (JRPropertiesHolder)element, "net.sf.jasperreports.print.transfer.");
    }

    protected JRPropertiesMap getEvaluatedProperties() {
        return this.mergedProperties;
    }

    protected void evaluateProperties(byte evaluation) throws JRException {
        JRPropertyExpression[] propExprs = this.getPropertyExpressions();
        if (propExprs == null || propExprs.length == 0) {
            this.dynamicProperties = null;
            this.mergedProperties = this.staticProperties;
        } else {
            this.dynamicProperties = new JRPropertiesMap();
            for (int i = 0; i < propExprs.length; ++i) {
                JRPropertyExpression prop = propExprs[i];
                String value = (String)this.evaluateExpression(prop.getValueExpression(), evaluation);
                if (value == null) continue;
                this.dynamicProperties.setProperty(prop.getName(), value);
            }
            this.mergedProperties = this.dynamicProperties.cloneProperties();
            this.mergedProperties.setBaseProperties(this.staticProperties);
        }
    }

    protected void setOriginProvider(JROriginProvider originProvider) {
        this.originProvider = originProvider;
    }

    protected JROrigin getElementOrigin() {
        JROrigin elementOrigin = null;
        if (this.originProvider != null) {
            elementOrigin = this.originProvider.getOrigin();
        }
        return elementOrigin;
    }

    protected boolean isDelayedStyleEvaluation() {
        return JRProperties.getBooleanProperty(this, "net.sf.jasperreports.style.evaluation.time.enabled", false);
    }

    private static class DelayedEvaluations
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        final Set<String> fields = new HashSet<String>();
        final Set<String> variables = new HashSet<String>();

        DelayedEvaluations() {
        }
    }
}

