/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JRXlsAbstractExporter
extends JRAbstractExporter {
    protected static final String XLS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xls.";
    public static final String PROPERTY_CELL_FORMULA = "net.sf.jasperreports.export.xls.formula";
    public static final String PROPERTY_CELL_PATTERN = "net.sf.jasperreports.export.xls.pattern";
    public static final String PROPERTY_WRAP_TEXT = "net.sf.jasperreports.export.xls.wrap.text";
    public static final String PROPERTY_FIT_WIDTH = "net.sf.jasperreports.export.xls.fit.width";
    public static final String PROPERTY_FIT_HEIGHT = "net.sf.jasperreports.export.xls.fit.height";
    public static final String PROPERTY_CELL_LOCKED = "net.sf.jasperreports.export.xls.cell.locked";
    public static final String PROPERTY_CELL_HIDDEN = "net.sf.jasperreports.export.xls.cell.hidden";
    public static final String PROPERTY_SHEET_HEADER_LEFT = "net.sf.jasperreports.export.xls.sheet.header.left";
    public static final String PROPERTY_SHEET_HEADER_CENTER = "net.sf.jasperreports.export.xls.sheet.header.center";
    public static final String PROPERTY_SHEET_HEADER_RIGHT = "net.sf.jasperreports.export.xls.sheet.header.right";
    public static final String PROPERTY_SHEET_FOOTER_LEFT = "net.sf.jasperreports.export.xls.sheet.footer.left";
    public static final String PROPERTY_SHEET_FOOTER_CENTER = "net.sf.jasperreports.export.xls.sheet.footer.center";
    public static final String PROPERTY_SHEET_FOOTER_RIGHT = "net.sf.jasperreports.export.xls.sheet.footer.right";
    public static final String PROPERTY_SHEET_DIRECTION = "net.sf.jasperreports.export.xls.sheet.direction";
    public static final String PROPERTY_FREEZE_ROW = "net.sf.jasperreports.export.xls.freeze.row";
    public static final String PROPERTY_FREEZE_COLUMN = "net.sf.jasperreports.export.xls.freeze.column";
    public static final String PROPERTY_FREEZE_ROW_EDGE = "net.sf.jasperreports.export.xls.freeze.row.edge";
    public static final String PROPERTY_FREEZE_COLUMN_EDGE = "net.sf.jasperreports.export.xls.freeze.column.edge";
    public static final String PROPERTY_AUTO_FIT_ROW = "net.sf.jasperreports.export.xls.auto.fit.row";
    public static final String PROPERTY_AUTO_FIT_COLUMN = "net.sf.jasperreports.export.xls.auto.fit.column";
    public static final String PROPERTY_AUTO_FILTER = "net.sf.jasperreports.export.xls.auto.filter";
    public static final String PROPERTY_CUSTOM_COLUMN_WIDTH = "net.sf.jasperreports.export.xls.custom.column.width";
    public static final int MAX_ROW_INDEX = 65535;
    public static final int MAX_COLUMN_INDEX = 255;
    protected List<Object> loadedFonts = new ArrayList<Object>();
    protected boolean isOnePagePerSheet;
    protected boolean isRemoveEmptySpaceBetweenRows;
    protected boolean isRemoveEmptySpaceBetweenColumns;
    protected boolean isWhitePageBackground;
    protected boolean isDetectCellType;
    protected boolean isFontSizeFixEnabled;
    protected boolean isImageBorderFixEnabled;
    protected boolean isIgnoreGraphics;
    protected boolean createCustomPalette;
    protected boolean isCollapseRowSpan;
    protected boolean isIgnoreCellBorder;
    protected boolean isIgnoreCellBackground;
    protected boolean wrapText;
    protected boolean cellLocked;
    protected boolean cellHidden;
    protected int maxRowsPerSheet;
    protected String[] sheetNames;
    protected String sheetHeaderLeft;
    protected String sheetHeaderCenter;
    protected String sheetHeaderRight;
    protected String sheetFooterLeft;
    protected String sheetFooterCenter;
    protected String sheetFooterRight;
    protected RunDirectionEnum sheetDirection;
    protected Map<String, String> formatPatternsMap;
    protected JRExportProgressMonitor progressMonitor;
    protected int reportIndex;
    protected int pageIndex;
    protected Map<String, String> fontMap;
    protected JRFont defaultFont;
    protected int sheetIndex;
    protected int sheetNamesIndex;
    protected Map<String, Integer> sheetNamesMap;
    protected boolean isIgnorePageMargins;
    protected int gridRowFreezeIndex;
    protected int gridColumnFreezeIndex;
    protected String autoFilter;
    protected int maxRowFreezeIndex;
    protected int maxColumnFreezeIndex;
    protected boolean isFreezeRowEdge;
    protected boolean isFreezeColumnEdge;

    protected JRFont getDefaultFont() {
        return this.defaultFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block19: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(XLS_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.setParameters();
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    this.exportReportToStream(os);
                    break block19;
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setParameters() {
        this.isOnePagePerSheet = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, "net.sf.jasperreports.export.xls.one.page.per.sheet", false);
        this.isRemoveEmptySpaceBetweenRows = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.xls.remove.empty.space.between.rows", false);
        this.isRemoveEmptySpaceBetweenColumns = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, "net.sf.jasperreports.export.xls.remove.empty.space.between.columns", false);
        this.isWhitePageBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", false);
        this.setBackground();
        this.isDetectCellType = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, "net.sf.jasperreports.export.xls.detect.cell.type", false);
        this.isFontSizeFixEnabled = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, "net.sf.jasperreports.export.xls.font.size.fix.enabled", false);
        this.isImageBorderFixEnabled = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IMAGE_BORDER_FIX_ENABLED, "net.sf.jasperreports.export.xls.image.border.fix.enabled", false);
        this.isIgnoreGraphics = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, "net.sf.jasperreports.export.xls.ignore.graphics", false);
        this.createCustomPalette = this.getBooleanParameter(JRXlsAbstractExporterParameter.CREATE_CUSTOM_PALETTE, "net.sf.jasperreports.export.xls.create.custom.palette", false);
        this.isCollapseRowSpan = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, "net.sf.jasperreports.export.xls.collapse.row.span", false);
        this.isIgnoreCellBorder = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, "net.sf.jasperreports.export.xls.ignore.cell.border", false);
        this.isIgnoreCellBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BACKGROUND, "net.sf.jasperreports.export.xls.ignore.cell.background", false);
        this.wrapText = JRProperties.getBooleanProperty(this.jasperPrint, PROPERTY_WRAP_TEXT, true);
        this.cellLocked = JRProperties.getBooleanProperty(this.jasperPrint, PROPERTY_CELL_LOCKED, true);
        this.cellHidden = JRProperties.getBooleanProperty(this.jasperPrint, PROPERTY_CELL_HIDDEN, false);
        this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
        this.setHyperlinkProducerFactory();
        this.maxRowsPerSheet = this.getIntegerParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, "net.sf.jasperreports.export.xls.max.rows.per.sheet", 0);
        this.isIgnorePageMargins = this.getBooleanParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, "net.sf.jasperreports.export.ignore.page.margins", false);
        this.sheetHeaderLeft = JRProperties.getProperty(this.jasperPrint, PROPERTY_SHEET_HEADER_LEFT);
        this.sheetHeaderCenter = JRProperties.getProperty(this.jasperPrint, PROPERTY_SHEET_HEADER_CENTER);
        this.sheetHeaderRight = JRProperties.getProperty(this.jasperPrint, PROPERTY_SHEET_HEADER_RIGHT);
        this.sheetFooterLeft = JRProperties.getProperty(this.jasperPrint, PROPERTY_SHEET_FOOTER_LEFT);
        this.sheetFooterCenter = JRProperties.getProperty(this.jasperPrint, PROPERTY_SHEET_FOOTER_CENTER);
        this.sheetFooterRight = JRProperties.getProperty(this.jasperPrint, PROPERTY_SHEET_FOOTER_RIGHT);
        String sheetDirectionProp = JRProperties.getProperty(this.jasperPrint, PROPERTY_SHEET_DIRECTION);
        this.sheetDirection = sheetDirectionProp == null ? RunDirectionEnum.LTR : RunDirectionEnum.getByName(sheetDirectionProp);
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
    }

    protected void setExporterHints() {
        this.setSheetNames();
        this.gridRowFreezeIndex = Math.min(Math.max(0, JRProperties.getIntegerProperty(this.jasperPrint, PROPERTY_FREEZE_ROW, 0) - 1), 65535);
        this.gridColumnFreezeIndex = Math.min(Math.max(0, this.getColumnIndex(JRProperties.getProperty(this.jasperPrint, PROPERTY_FREEZE_COLUMN))), 255);
        this.autoFilter = JRProperties.getProperty(this.jasperPrint, PROPERTY_AUTO_FILTER);
    }

    protected abstract void setBackground();

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap<String, Integer>();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            List<JRPrintPage> pages;
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            this.setExporterHints();
            if (this.getParameter(JRXlsAbstractExporterParameter.SHEET_NAMES) == null || this.getParameterResolver() instanceof JRAbstractExporter.ParameterOverriddenResolver && this.sheetNames != null && this.sheetNames.length > 0) {
                this.sheetNamesIndex = 0;
            }
            if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    this.pageIndex = this.startPageIndex;
                    while (this.pageIndex <= this.endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.createSheet(this.getSheetName(null));
                        ++this.sheetIndex;
                        ++this.sheetNamesIndex;
                        if (this.gridRowFreezeIndex > 0 || this.gridColumnFreezeIndex > 0) {
                            this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
                        }
                        if (this.autoFilter != null) {
                            this.setAutoFilter(this.autoFilter);
                        }
                        this.exportPage(page, null, 0);
                        ++this.pageIndex;
                    }
                } else {
                    this.createSheet(this.getSheetName(this.jasperPrint.getName()));
                    ++this.sheetIndex;
                    ++this.sheetNamesIndex;
                    if (this.gridRowFreezeIndex > 0 || this.gridColumnFreezeIndex > 0) {
                        this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
                    }
                    if (this.autoFilter != null) {
                        this.setAutoFilter(this.autoFilter);
                    }
                    CutsInfo xCuts = JRGridLayout.calculateXCuts(this.getNature(), pages, this.startPageIndex, this.endPageIndex, this.jasperPrint.getPageWidth(), this.globalOffsetX);
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    int startRow = 0;
                    this.pageIndex = this.startPageIndex;
                    while (this.pageIndex <= this.endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        startRow = this.exportPage(page, xCuts, startRow);
                        ++this.pageIndex;
                    }
                    if (this.isRemoveEmptySpaceBetweenColumns) {
                        this.removeEmptyColumns(xCuts);
                    }
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(os);
    }

    protected int exportPage(JRPrintPage page, CutsInfo xCuts, int startRow) throws JRException {
        boolean createXCuts;
        JRGridLayout layout = new JRGridLayout(this.getNature(), page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, xCuts);
        JRExporterGridCell[][] grid = layout.getGrid();
        boolean bl = createXCuts = xCuts == null;
        if (createXCuts) {
            xCuts = layout.getXCuts();
            this.setColumnWidths(xCuts);
        }
        if (startRow == 0) {
            this.setColumnWidths(xCuts);
        }
        CutsInfo yCuts = layout.getYCuts();
        int skippedRows = 0;
        int rowIndex = startRow;
        for (int y = 0; y < grid.length; ++y) {
            rowIndex = y - skippedRows + startRow;
            if (this.maxRowsPerSheet > 0 && rowIndex >= this.maxRowsPerSheet || yCuts.isBreak(y)) {
                if (this.isRemoveEmptySpaceBetweenColumns) {
                    this.removeEmptyColumns(xCuts);
                }
                this.createSheet(this.getSheetName(null));
                this.setColumnWidths(xCuts);
                startRow = 0;
                rowIndex = 0;
                skippedRows = y;
                ++this.sheetIndex;
                ++this.sheetNamesIndex;
                if (this.gridRowFreezeIndex > 0 || this.gridColumnFreezeIndex > 0) {
                    this.setFreezePane(this.gridRowFreezeIndex, this.gridColumnFreezeIndex);
                }
                if (this.autoFilter != null) {
                    this.setAutoFilter(this.autoFilter);
                }
            }
            if (yCuts.isCutNotEmpty(y) || (!this.isRemoveEmptySpaceBetweenRows || yCuts.isCutSpanned(y)) && !this.isCollapseRowSpan) {
                JRExporterGridCell[] gridRow = grid[y];
                int emptyCellColSpan = 0;
                int emptyCellWidth = 0;
                this.setRowHeight(rowIndex, this.isCollapseRowSpan ? layout.getMaxRowHeight(y) : JRGridLayout.getRowHeight(gridRow));
                int emptyCols = 0;
                for (int colIndex = 0; colIndex < gridRow.length; ++colIndex) {
                    emptyCols += this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(colIndex) && !xCuts.isCutSpanned(colIndex) ? 1 : 0;
                    JRExporterGridCell gridCell = gridRow[colIndex];
                    this.setCell(gridCell, colIndex, rowIndex);
                    if (gridCell.getType() == 2) {
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        this.addOccupiedCell((OccupiedGridCell)gridCell, colIndex, rowIndex);
                        continue;
                    }
                    if (gridCell.getWrapper() != null) {
                        String autoFilterRange;
                        String sheetName;
                        int columnFreezeIndex;
                        JRPrintElement element;
                        String rowFreeze;
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        int rowFreezeIndex = (rowFreeze = JRProperties.getProperty(element = gridCell.getWrapper().getElement(), PROPERTY_FREEZE_ROW_EDGE)) == null ? 0 : (EdgeEnum.BOTTOM.getName().equals(rowFreeze) ? rowIndex + gridCell.getRowSpan() : rowIndex);
                        String columnFreeze = JRProperties.getProperty(element, PROPERTY_FREEZE_COLUMN_EDGE);
                        int n = columnFreeze == null ? 0 : (columnFreezeIndex = EdgeEnum.RIGHT.getName().equals(columnFreeze) ? colIndex + gridCell.getColSpan() : colIndex);
                        if (rowFreezeIndex > 0 || columnFreezeIndex > 0) {
                            this.setFreezePane(rowFreezeIndex, columnFreezeIndex, rowFreezeIndex > 0, columnFreezeIndex > 0);
                        }
                        if ((sheetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.sheet.name")) != null) {
                            this.setSheetName(sheetName);
                        }
                        if ((autoFilterRange = JRProperties.getProperty(element, PROPERTY_AUTO_FILTER)) != null) {
                            this.setAutoFilter(autoFilterRange);
                        }
                        if (element instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintRectangle) {
                            this.exportRectangle((JRPrintRectangle)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintEllipse) {
                            this.exportRectangle((JRPrintEllipse)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                            continue;
                        }
                        if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)element, gridCell, colIndex, y);
                            continue;
                        }
                        if (!(element instanceof JRGenericPrintElement)) continue;
                        this.exportGenericElement((JRGenericPrintElement)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                        continue;
                    }
                    ++emptyCellColSpan;
                    emptyCellWidth += gridCell.getWidth();
                    this.addBlankCell(gridCell, colIndex, rowIndex);
                }
                ++rowIndex;
                continue;
            }
            ++skippedRows;
        }
        if (createXCuts && this.isRemoveEmptySpaceBetweenColumns) {
            this.removeEmptyColumns(xCuts);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
        return rowIndex;
    }

    protected void setColumnWidths(CutsInfo xCuts) {
        for (int col = 0; col < xCuts.size() - 1; ++col) {
            if (this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(col) && !xCuts.isCutSpanned(col) && xCuts.isAutoFit(col)) continue;
            int width = xCuts.getCustomWidth(col) != null ? xCuts.getCustomWidth(col) : xCuts.getCutOffset(col + 1) - xCuts.getCutOffset(col);
            this.setColumnWidth(col, width);
        }
    }

    protected void removeEmptyColumns(CutsInfo xCuts) {
        for (int col = xCuts.size() - 1; col >= 0; --col) {
            if (xCuts.isCutNotEmpty(col) || xCuts.isCutSpanned(col)) continue;
            this.removeColumn(col);
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getFullStyledText(JRStyledTextAttributeSelector.NONE);
    }

    protected static TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalAlignEnum horizontalAlignment;
        VerticalAlignEnum verticalAlignment;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.LEFT;
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.RIGHT;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignmentValue();
                verticalAlignment = textElement.getVerticalAlignmentValue();
            }
        }
        return new TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected int getImageBorderCorrection(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            if (lineWidth >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return this.isImageBorderFixEnabled ? 1 : 0;
    }

    private String getSheetName(String sheetName) {
        if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
            sheetName = this.sheetNames[this.sheetNamesIndex];
        }
        if (sheetName == null) {
            return "Page " + (this.sheetIndex + 1);
        }
        int crtIndex = 1;
        String txtIndex = "";
        if (this.sheetNamesMap.containsKey(sheetName)) {
            crtIndex = this.sheetNamesMap.get(sheetName) + 1;
            txtIndex = String.valueOf(crtIndex);
        }
        this.sheetNamesMap.put(sheetName, crtIndex);
        String name = sheetName;
        if (txtIndex.length() > 0) {
            name = name + " " + txtIndex;
        }
        if (name.length() > 31) {
            name = (sheetName + " ").substring(0, 31 - txtIndex.length()) + txtIndex;
        }
        return name;
    }

    protected final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    protected final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected boolean isWrapText(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_WRAP_TEXT)) {
            return JRProperties.getBooleanProperty(element, PROPERTY_WRAP_TEXT, this.wrapText);
        }
        return this.wrapText;
    }

    protected boolean isCellLocked(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_CELL_LOCKED)) {
            return JRProperties.getBooleanProperty(element, PROPERTY_CELL_LOCKED, this.cellLocked);
        }
        return this.cellLocked;
    }

    protected String getFormula(JRPrintText text) {
        String formula = text.getPropertiesMap().getProperty(PROPERTY_CELL_FORMULA);
        if (formula != null && (formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1);
        }
        return formula;
    }

    protected void setSheetNames() {
        String[] sheetNamesArray = this.getStringArrayParameter(JRXlsAbstractExporterParameter.SHEET_NAMES, "net.sf.jasperreports.export.xls.sheet.names.");
        if (sheetNamesArray != null) {
            ArrayList<String> sheetNamesList = new ArrayList<String>();
            for (int i = 0; i < sheetNamesArray.length; ++i) {
                if (sheetNamesArray[i] == null) {
                    sheetNamesList.add(null);
                    continue;
                }
                String[] currentSheetNamesArray = sheetNamesArray[i].split("/");
                for (int j = 0; j < currentSheetNamesArray.length; ++j) {
                    sheetNamesList.add(currentSheetNamesArray[j]);
                }
            }
            this.sheetNames = sheetNamesList.toArray(new String[sheetNamesList.size()]);
        }
    }

    protected boolean isCellHidden(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_CELL_HIDDEN)) {
            return JRProperties.getBooleanProperty(element, PROPERTY_CELL_HIDDEN, this.cellHidden);
        }
        return this.cellHidden;
    }

    protected String getConvertedPattern(JRPrintText text, String pattern) {
        String convertedPattern = text.getPropertiesMap().getProperty(PROPERTY_CELL_PATTERN);
        if (convertedPattern == null) {
            if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
                return this.formatPatternsMap.get(pattern);
            }
            return pattern;
        }
        return convertedPattern;
    }

    protected int getColumnIndex(String columnName) {
        String upperColumnName;
        int index = -1;
        if (columnName != null && (upperColumnName = columnName.toUpperCase()).matches("[A-Z]*")) {
            for (int i = 0; i < upperColumnName.length(); ++i) {
                index += (upperColumnName.charAt(i) - 64) * (int)Math.pow(26.0, upperColumnName.length() - i - 1);
            }
        }
        return index;
    }

    protected void setFreezePane(int rowIndex, int colIndex) {
        this.setFreezePane(rowIndex, colIndex, false, false);
    }

    protected abstract ExporterNature getNature();

    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    protected abstract void createSheet(String var1);

    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected abstract void setColumnWidth(int var1, int var2);

    protected abstract void removeColumn(int var1);

    protected abstract void setRowHeight(int var1, int var2) throws JRException;

    protected abstract void setCell(JRExporterGridCell var1, int var2, int var3);

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void addOccupiedCell(OccupiedGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    protected abstract void exportRectangle(JRPrintGraphicElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportGenericElement(JRGenericPrintElement var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    protected abstract void setFreezePane(int var1, int var2, boolean var3, boolean var4);

    protected abstract void setSheetName(String var1);

    protected abstract void setAutoFilter(String var1);

    protected static class TextAlignHolder {
        public final HorizontalAlignEnum horizontalAlignment;
        public final VerticalAlignEnum verticalAlignment;
        public final RotationEnum rotation;

        public TextAlignHolder(HorizontalAlignEnum horizontalAlignment, VerticalAlignEnum verticalAlignment, RotationEnum rotation) {
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
        }
    }
}

