/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRVirtualPrintPage
implements JRPrintPage,
JRVirtualizable,
Serializable {
    protected static final Log log = LogFactory.getLog(JRVirtualPrintPage.class);
    private static final long serialVersionUID = 10200L;
    private static final Random random = new Random(System.currentTimeMillis());
    private static short counter = 1;
    protected List<JRPrintElement> elements = new ArrayList<JRPrintElement>();
    private String uid;
    private transient JRVirtualizer virtualizer;
    private transient IdentityDataProvider[] identityProviders;
    protected JRVirtualizationContext virtualizationContext;

    public JRVirtualPrintPage(JasperPrint printObject, JRVirtualizer virtualizer, JRVirtualizationContext virtualizationContext) {
        this.virtualizationContext = virtualizationContext;
        this.uid = JRVirtualPrintPage.makeUID(printObject);
        this.virtualizer = virtualizer;
        this.identityProviders = null;
        if (virtualizer != null) {
            virtualizer.registerObject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUID(JasperPrint printObject) {
        Random random = JRVirtualPrintPage.random;
        synchronized (random) {
            short s = counter;
            counter = (short)(s + 1);
            return Integer.toString(System.identityHashCode(printObject)) + "_" + printObject.getPages().size() + "_" + Integer.toString(s) + "_" + Integer.toString(JRVirtualPrintPage.random.nextInt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUID(JRVirtualPrintPage page) {
        Random random = JRVirtualPrintPage.random;
        synchronized (random) {
            short s = counter;
            counter = (short)(s + 1);
            return Integer.toString(System.identityHashCode(page)) + "_" + Integer.toString(s) + "_" + Integer.toString(JRVirtualPrintPage.random.nextInt());
        }
    }

    @Override
    public final String getUID() {
        return this.uid;
    }

    @Override
    public void setVirtualData(Object o) {
        this.elements = (List)o;
    }

    @Override
    public Object getVirtualData() {
        return this.elements;
    }

    @Override
    public void removeVirtualData() {
        this.elements = null;
    }

    @Override
    public void setIdentityData(Object o) {
        if (this.identityProviders != null) {
            for (int i = 0; i < this.identityProviders.length; ++i) {
                this.identityProviders[i].setIdentityData(this, (ObjectIDPair[])o);
            }
        }
    }

    @Override
    public Object getIdentityData() {
        ObjectIDPair[] data;
        if (this.identityProviders != null) {
            if (this.identityProviders.length == 1) {
                data = this.identityProviders[0].getIdentityData(this);
            } else if (this.identityProviders.length > 1) {
                HashSet<ObjectIDPair> list = new HashSet<ObjectIDPair>();
                for (int i = 0; i < this.identityProviders.length; ++i) {
                    ObjectIDPair[] pairs = this.identityProviders[i].getIdentityData(this);
                    if (pairs == null) continue;
                    for (int j = 0; j < pairs.length; ++j) {
                        list.add(pairs[j]);
                    }
                }
                data = list.toArray(new ObjectIDPair[list.size()]);
            } else {
                data = null;
            }
        } else {
            data = null;
        }
        return data;
    }

    public boolean isVirtualized() {
        return this.elements == null;
    }

    public void setVirtualizer(JRVirtualizer virtualizer) {
        this.virtualizer = virtualizer;
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public void addIdentityDataProvider(IdentityDataProvider p) {
        if (this.identityProviders == null) {
            this.identityProviders = new IdentityDataProvider[]{p};
        } else {
            IdentityDataProvider[] newList = new IdentityDataProvider[this.identityProviders.length + 1];
            System.arraycopy(this.identityProviders, 0, newList, 0, this.identityProviders.length);
            newList[this.identityProviders.length] = p;
            this.identityProviders = newList;
        }
    }

    public void removeIdentityDataProvider(IdentityDataProvider p) {
        if (this.identityProviders != null) {
            for (int idx = 0; idx < this.identityProviders.length; ++idx) {
                if (this.identityProviders[idx] != p) continue;
                IdentityDataProvider[] newList = new IdentityDataProvider[this.identityProviders.length - 1];
                System.arraycopy(this.identityProviders, 0, newList, 0, idx);
                int remaining = this.identityProviders.length - idx - 1;
                if (remaining > 0) {
                    System.arraycopy(this.identityProviders, idx + 1, newList, idx, remaining);
                }
                this.identityProviders = newList;
                break;
            }
        }
    }

    @Override
    public List<JRPrintElement> getElements() {
        this.ensureVirtualData();
        return this.elements;
    }

    protected void ensureVirtualData() {
        if (this.virtualizer != null) {
            this.virtualizer.requestData(this);
        }
    }

    @Override
    public void setElements(List<JRPrintElement> elements) {
        this.cleanVirtualData();
        this.elements = elements;
        this.cacheInContext(this.elements);
    }

    protected void cleanVirtualData() {
        if (this.virtualizer != null) {
            this.virtualizer.clearData(this);
        }
    }

    @Override
    public void addElement(JRPrintElement element) {
        this.ensureVirtualData();
        this.elements.add(element);
        this.cacheInContext(element);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String oldUid = (String)in.readObject();
        this.uid = JRVirtualPrintPage.makeUID(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Original uid " + oldUid + "; new uid " + this.uid));
        }
        this.virtualizationContext = (JRVirtualizationContext)in.readObject();
        int length = in.readInt();
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, buffer.length);
        ObjectInputStream elementsStream = new ObjectInputStream(inputStream);
        this.elements = (List)elementsStream.readObject();
        this.afterInternalization();
        this.setThreadVirtualizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        this.ensureVirtualData();
        this.beforeExternalization();
        try {
            out.writeObject(this.uid);
            out.writeObject(this.virtualizationContext);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(bout);
            stream.writeObject(this.elements);
            stream.flush();
            byte[] bytes = bout.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }
        finally {
            this.afterExternalization();
        }
    }

    private void setThreadVirtualizer() {
        JRVirtualizer threadVirtualizer = JRVirtualizationHelper.getThreadVirtualizer();
        if (threadVirtualizer != null) {
            this.virtualizer = threadVirtualizer;
            this.virtualizer.registerObject(this);
        }
    }

    protected void finalize() throws Throwable {
        if (this.virtualizer != null) {
            this.virtualizer.deregisterObject(this);
        }
        super.finalize();
    }

    protected List<JRPrintElement> getDeepElements() {
        ArrayList<JRPrintElement> deepElements = new ArrayList<JRPrintElement>(this.elements.size());
        this.collectDeepElements(this.elements, deepElements);
        return deepElements;
    }

    protected void collectDeepElements(List<JRPrintElement> elementsList, List<JRPrintElement> deepElements) {
        for (JRPrintElement element : elementsList) {
            deepElements.add(element);
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            this.collectDeepElements(frame.getElements(), deepElements);
        }
    }

    @Override
    public void beforeExternalization() {
        this.setElementsExternalData();
    }

    protected void setElementsExternalData() {
        this.traverseDeepElements(new ExternalizationElementVisitor());
    }

    protected void setExternalizationRenderer(JRPrintImage image) {
        JRRenderable renderer = image.getRenderer();
        if (renderer != null && this.virtualizationContext.hasCachedRenderer(renderer.getId())) {
            image.setRenderer(new JRIdHolderRenderer(renderer));
        }
    }

    protected void cacheInContext(List<JRPrintElement> elementList) {
        if (elementList != null && !elementList.isEmpty()) {
            for (JRPrintElement element : elementList) {
                this.cacheInContext(element);
            }
        }
    }

    protected void cacheInContext(JRPrintElement element) {
        JRTemplatePrintElement templateElement;
        JRTemplateElement template;
        if (element instanceof JRTemplatePrintElement && (template = (templateElement = (JRTemplatePrintElement)element).getTemplate()) != null) {
            this.virtualizationContext.cacheTemplate(template);
        }
        if (element instanceof JRPrintFrame) {
            JRPrintFrame frame = (JRPrintFrame)element;
            this.cacheInContext(frame.getElements());
        }
    }

    @Override
    public void afterInternalization() {
        this.restoreElementsData();
    }

    protected void restoreElementsData() {
        this.traverseDeepElements(new InternalizationElementVisitor());
    }

    @Override
    public JRVirtualizationContext getContext() {
        return this.virtualizationContext;
    }

    @Override
    public void afterExternalization() {
        this.restoreElementsData();
    }

    protected void traverseDeepElements(ElementVisitor visitor) {
        this.traverseDeepElements(visitor, this.elements);
    }

    protected void traverseDeepElements(ElementVisitor visitor, List<JRPrintElement> elementsList) {
        for (JRPrintElement element : elementsList) {
            visitor.visitElement(element);
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            this.traverseDeepElements(visitor, frame.getElements());
        }
    }

    protected class InternalizationElementVisitor
    implements ElementVisitor {
        protected InternalizationElementVisitor() {
        }

        public void visitElement(JRPrintElement element) {
            if (element instanceof JRTemplatePrintElement) {
                this.restoreTemplate((JRTemplatePrintElement)element);
            }
            if (element instanceof JRPrintImage) {
                this.restoreRenderer((JRPrintImage)element);
            }
        }

        protected void restoreTemplate(JRTemplatePrintElement element) {
            JRTemplateElement template = element.getTemplate();
            if (template != null && template instanceof JRIdHolderTemplateElement) {
                JRTemplateElement cachedTemplate = JRVirtualPrintPage.this.virtualizationContext.getCachedTemplate(template.getId());
                if (cachedTemplate == null) {
                    throw new JRRuntimeException("Template " + template.getId() + " not found in virtualization context.");
                }
                element.setTemplate(cachedTemplate);
            }
        }

        protected void restoreRenderer(JRPrintImage image) {
            JRRenderable renderer = image.getRenderer();
            if (renderer != null && renderer instanceof JRIdHolderRenderer) {
                JRRenderable cachedRenderer = JRVirtualPrintPage.this.virtualizationContext.getCachedRenderer(renderer.getId());
                if (cachedRenderer == null) {
                    throw new JRRuntimeException("Renderer " + renderer.getId() + " not found in virtualization context.");
                }
                image.setRenderer(cachedRenderer);
            }
        }
    }

    protected class ExternalizationElementVisitor
    implements ElementVisitor {
        private final Map<String, JRIdHolderTemplateElement> idTemplates = new HashMap<String, JRIdHolderTemplateElement>();

        protected ExternalizationElementVisitor() {
        }

        public void visitElement(JRPrintElement element) {
            if (element instanceof JRTemplatePrintElement) {
                this.setExternalizationTemplate((JRTemplatePrintElement)element);
            }
            if (element instanceof JRPrintImage) {
                JRVirtualPrintPage.this.setExternalizationRenderer((JRPrintImage)element);
            }
        }

        protected void setExternalizationTemplate(JRTemplatePrintElement templateElement) {
            JRTemplateElement template = templateElement.getTemplate();
            if (template != null) {
                if (JRVirtualPrintPage.this.virtualizationContext.hasCachedTemplate(template.getId())) {
                    String templateId = template.getId();
                    JRIdHolderTemplateElement idTemplate = this.idTemplates.get(templateId);
                    if (idTemplate == null) {
                        idTemplate = new JRIdHolderTemplateElement(templateId);
                        this.idTemplates.put(templateId, idTemplate);
                    }
                    templateElement.setTemplate(idTemplate);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Template " + template + " having id " + template.getId() + " not found in virtualization context cache"));
                }
            }
        }
    }

    protected static interface ElementVisitor {
        public void visitElement(JRPrintElement var1);
    }

    protected static class JRIdHolderTemplateElement
    extends JRTemplateElement {
        private static final long serialVersionUID = 10200L;

        protected JRIdHolderTemplateElement(String id) {
            super(id);
        }

        public int getHashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean isIdentical(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class JRIdHolderRenderer
    implements JRRenderable,
    Serializable {
        private static final long serialVersionUID = 10200L;
        protected final String id;

        protected JRIdHolderRenderer(JRRenderable renderer) {
            this.id = renderer.getId();
        }

        public String getId() {
            return this.id;
        }

        public byte getType() {
            return 0;
        }

        public byte getImageType() {
            return 0;
        }

        public Dimension2D getDimension() throws JRException {
            return null;
        }

        public byte[] getImageData() throws JRException {
            return null;
        }

        public void render(Graphics2D grx, Rectangle2D rectanle) throws JRException {
        }
    }

    public static interface IdentityDataProvider {
        public ObjectIDPair[] getIdentityData(JRVirtualPrintPage var1);

        public void setIdentityData(JRVirtualPrintPage var1, ObjectIDPair[] var2);
    }

    public static class ObjectIDPair
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        private final Object o;
        private final int id;

        public ObjectIDPair(Object o) {
            this.o = o;
            this.id = System.identityHashCode(o);
        }

        public Object getObject() {
            return this.o;
        }

        public int getIdentity() {
            return this.id;
        }
    }
}

