/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeTextOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.EvaluationType;
import net.sf.jasperreports.engine.fill.DatasetFillContext;
import net.sf.jasperreports.engine.util.JRDateLocaleConverter;
import net.sf.jasperreports.engine.util.JRFloatLocaleConverter;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldFilter
implements DatasetFilter {
    private static final Log log = LogFactory.getLog(FieldFilter.class);
    private LocaleConvertUtilsBean convertBean;
    private final String DEFAULT_NUMBER_PATTERN = "#,##0.##";
    private final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private final String field;
    private String filterValueStart;
    private String filterValueEnd;
    private String filterType;
    private String filterTypeOperator;
    private DatasetFillContext context;
    private Locale locale;
    FilterTypesEnum filterTypeEnum;

    public FieldFilter(String field, String filterValueStart, String filterValueEnd, String filterType, String filterTypeOperator) {
        this.field = field;
        this.filterValueStart = filterValueStart;
        this.filterValueEnd = filterValueEnd;
        this.filterType = filterType;
        this.filterTypeOperator = filterTypeOperator;
    }

    @Override
    public void init(DatasetFillContext context) {
        this.context = context;
        this.locale = context.getLocale();
        this.filterTypeEnum = FilterTypesEnum.getByName(this.filterType);
    }

    @Override
    public boolean matches(EvaluationType evaluation) {
        Object value = this.context.getFieldValue(this.field, evaluation);
        if (value == null) {
            return false;
        }
        boolean result = true;
        switch (this.filterTypeEnum) {
            case DATE: {
                result = this.dateMatch(value, FilterTypeDateOperatorsEnum.getByEnumConstantName(this.filterTypeOperator));
                break;
            }
            case NUMERIC: {
                result = this.numericMatch(value, FilterTypeNumericOperatorsEnum.getByEnumConstantName(this.filterTypeOperator));
                break;
            }
            case TEXT: {
                result = this.textMatch(value, FilterTypeTextOperatorsEnum.getByEnumConstantName(this.filterTypeOperator));
            }
        }
        return result;
    }

    protected boolean numericMatch(Object value, FilterTypeNumericOperatorsEnum numericEnum) {
        Number compareStart = null;
        Number compareEnd = null;
        if (this.filterValueStart != null && this.filterValueStart.length() > 0) {
            compareStart = (Number)this.convertStringValue(this.filterValueStart, value.getClass());
        }
        if (this.filterValueEnd != null && this.filterValueEnd.length() > 0) {
            compareEnd = (Number)this.convertStringValue(this.filterValueEnd, value.getClass());
        }
        return this.compareNumbers((Number)value, compareStart, compareEnd, numericEnum);
    }

    protected boolean dateMatch(Object value, FilterTypeDateOperatorsEnum dateEnum) {
        Date compareStart = null;
        Date compareEnd = null;
        if (this.filterValueStart != null && this.filterValueStart.length() > 0) {
            compareStart = (Date)this.convertStringValue(this.filterValueStart, value.getClass());
        }
        if (this.filterValueEnd != null && this.filterValueEnd.length() > 0) {
            compareEnd = (Date)this.convertStringValue(this.filterValueEnd, value.getClass());
        }
        return this.compareDates((Date)value, compareStart, compareEnd, dateEnum);
    }

    protected boolean textMatch(Object value, FilterTypeTextOperatorsEnum textEnum) {
        return this.compareText((String)value, this.filterValueStart, textEnum);
    }

    protected Object convertStringValue(String text, Class<?> valueClass) {
        Object value = null;
        if (String.class.equals(valueClass)) {
            value = text;
        } else if (Number.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, "#,##0.##");
        } else if (Date.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, "yyyy-MM-dd");
        }
        return value;
    }

    protected LocaleConvertUtilsBean getConvertBean() {
        if (this.convertBean == null) {
            this.convertBean = new LocaleConvertUtilsBean();
            if (this.locale != null) {
                this.convertBean.setDefaultLocale(this.locale);
                this.convertBean.deregister();
            }
            this.convertBean.register((LocaleConverter)new JRDateLocaleConverter(TimeZone.getDefault()), Date.class, this.locale);
            JRFloatLocaleConverter floatConverter = new JRFloatLocaleConverter(this.locale == null ? Locale.getDefault() : this.locale);
            this.convertBean.register((LocaleConverter)floatConverter, Float.class, this.locale);
            this.convertBean.register((LocaleConverter)floatConverter, Float.TYPE, this.locale);
        }
        return this.convertBean;
    }

    protected boolean compareNumbers(Number toCompare, Number compareStart, Number compareEnd, FilterTypeNumericOperatorsEnum numericEnum) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        boolean resultPart1 = true;
        boolean resultPart2 = true;
        BigDecimal dbA = new BigDecimal(toCompare.toString());
        BigDecimal dbStart = compareStart != null ? new BigDecimal(compareStart.toString()) : null;
        BigDecimal dbEnd = compareEnd != null ? new BigDecimal(compareEnd.toString()) : null;
        switch (numericEnum) {
            case DOES_NOT_EQUAL: {
                result = dbStart != null ? dbA.compareTo(dbStart) != 0 : defaultResult;
                break;
            }
            case EQUALS: {
                result = dbStart != null ? dbA.compareTo(dbStart) == 0 : defaultResult;
                break;
            }
            case GREATER_THAN: {
                result = dbStart != null ? dbA.compareTo(dbStart) > 0 : defaultResult;
                break;
            }
            case GREATER_THAN_EQUAL_TO: {
                result = dbStart != null ? dbA.compareTo(dbStart) >= 0 : defaultResult;
                break;
            }
            case IS_BETWEEN: {
                boolean bl = dbStart != null ? dbA.compareTo(dbStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = dbEnd != null ? dbA.compareTo(dbEnd) <= 0 : defaultResult;
                result = resultPart1 && resultPart2;
                break;
            }
            case IS_NOT_BETWEEN: {
                boolean bl = dbStart != null ? dbA.compareTo(dbStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = dbEnd != null ? dbA.compareTo(dbEnd) <= 0 : defaultResult;
                result = !resultPart1 || !resultPart2;
                break;
            }
            case LESS_THAN: {
                result = dbStart != null ? dbA.compareTo(dbStart) < 0 : defaultResult;
                break;
            }
            case LESS_THAN_EQUAL_TO: {
                result = dbStart != null ? dbA.compareTo(dbStart) <= 0 : defaultResult;
            }
        }
        return result;
    }

    protected boolean compareDates(Date toCompare, Date compareStart, Date compareEnd, FilterTypeDateOperatorsEnum dateEnum) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        boolean resultPart1 = true;
        boolean resultPart2 = true;
        switch (dateEnum) {
            case EQUALS: {
                result = compareStart != null ? toCompare.compareTo(compareStart) == 0 : defaultResult;
                break;
            }
            case IS_AFTER: {
                result = compareStart != null ? toCompare.compareTo(compareStart) > 0 : defaultResult;
                break;
            }
            case IS_BEFORE: {
                result = compareStart != null ? toCompare.compareTo(compareStart) < 0 : defaultResult;
                break;
            }
            case IS_BETWEEN: {
                boolean bl = compareStart != null ? toCompare.compareTo(compareStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = compareEnd != null ? toCompare.compareTo(compareEnd) <= 0 : defaultResult;
                result = resultPart1 && resultPart2;
                break;
            }
            case IS_NOT_BETWEEN: {
                boolean bl = compareStart != null ? toCompare.compareTo(compareStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = compareEnd != null ? toCompare.compareTo(compareEnd) <= 0 : defaultResult;
                result = !resultPart1 || !resultPart2;
                break;
            }
            case IS_NOT_EQUAL_TO: {
                result = compareStart != null ? toCompare.compareTo(compareStart) != 0 : defaultResult;
                break;
            }
            case IS_ON_OR_AFTER: {
                result = compareStart != null ? toCompare.compareTo(compareStart) >= 0 : defaultResult;
                break;
            }
            case IS_ON_OR_BEFORE: {
                result = compareStart != null ? toCompare.compareTo(compareStart) <= 0 : defaultResult;
            }
        }
        return result;
    }

    protected boolean compareText(String toCompare, String compareWith, FilterTypeTextOperatorsEnum textEnum) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        boolean gotCompareWith = compareWith != null;
        switch (textEnum) {
            case CONTAINS: {
                result = gotCompareWith ? toCompare.contains(compareWith) : defaultResult;
                break;
            }
            case DOES_NOT_CONTAIN: {
                result = gotCompareWith ? !toCompare.contains(compareWith) : defaultResult;
                break;
            }
            case DOES_NOT_END_WITH: {
                result = gotCompareWith ? !toCompare.endsWith(compareWith) : defaultResult;
                break;
            }
            case DOES_NOT_START_WITH: {
                result = gotCompareWith ? !toCompare.startsWith(compareWith) : defaultResult;
                break;
            }
            case ENDS_WITH: {
                result = gotCompareWith ? toCompare.endsWith(compareWith) : defaultResult;
                break;
            }
            case EQUALS: {
                result = gotCompareWith ? toCompare.equals(compareWith) : defaultResult;
                break;
            }
            case IS_NOT_EQUAL_TO: {
                result = gotCompareWith ? !toCompare.equals(compareWith) : defaultResult;
                break;
            }
            case STARTS_WITH: {
                result = gotCompareWith ? toCompare.startsWith(compareWith) : defaultResult;
            }
        }
        return result;
    }

    public String getField() {
        return this.field;
    }

    public String getFilterValueStart() {
        return this.filterValueStart;
    }

    public void setFilterValueStart(String filterValueStart) {
        this.filterValueStart = filterValueStart;
    }

    public String getFilterValueEnd() {
        return this.filterValueEnd;
    }

    public void setFilterValueEnd(String filterValueEnd) {
        this.filterValueEnd = filterValueEnd;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public String getFilterTypeOperator() {
        return this.filterTypeOperator;
    }

    public void setFilterTypeOperator(String filterTypeOperator) {
        this.filterTypeOperator = filterTypeOperator;
    }

    public FilterTypesEnum getFilterTypeEnum() {
        return this.filterTypeEnum;
    }
}

