/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.jaspersoft.jasperserver.api.JSException;
import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianCell;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianResult;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.DrillThrough;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.jpivot.table.navi.DrillThroughUI;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.table.TableModel;
import java.util.List;
import java.util.StringTokenizer;
import mondrian.olap.Cell;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import org.apache.log4j.Logger;

public class MondrianDrillThrough
extends ExtensionSupport
implements DrillThrough {
    private static Logger logger = Logger.getLogger(MondrianDrillThrough.class);
    private boolean extendedContext = true;
    private boolean includeOnlySelectedMeasure = false;
    public static final int HEAD = 0;
    public static final int MIDDLE = 1;
    public static final int TAIL = 2;
    public static final String FROM = " from ";

    public MondrianDrillThrough() {
        super.setId("drillThrough");
    }

    public boolean canDrillThrough(com.tonbeller.jpivot.olap.model.Cell cell) {
        return ((MondrianCell)cell).getMonCell().canDrillThrough();
    }

    public TableModel drillThrough(com.tonbeller.jpivot.olap.model.Cell cell, DrillThroughUI dtui) {
        MondrianModel model = null;
        Object resultBase = null;
        model = (MondrianModel)this.getModel();
        if (model == null) {
            return null;
        }
        try {
            model.setShowTableBelowCube(dtui.isShowTableBelowCube());
            this.setIncludeOnlySelectedMeasure(dtui.isIncludeOnlySelectedMeasure());
        }
        catch (Exception e) {
            logger.error((Object)"drillThrough", (Throwable)e);
        }
        return this.drillThrough(cell);
    }

    public TableModel drillThrough(com.tonbeller.jpivot.olap.model.Cell cell) {
        logger.debug((Object)Resources.instance().getString("jpivot.MondrianDrillThrough.debug.generateSql"));
        String sql = null;
        if (this.isIncludeOnlySelectedMeasure()) {
            logger.debug((Object)"\ninclude only selected measure");
            sql = ((MondrianCell)cell).getMonCell().getDrillThroughSQL(this.extendedContext);
        } else {
            logger.debug((Object)"\ninclude all measures");
            sql = this.getDrillThroughSQLAll(cell, this.extendedContext);
        }
        if (sql == null || sql.length() == 0) {
            String msg = Resources.instance().getString("jpivot.MondrianDrillThrough.error.drillThroughSQLReturnedNull");
            logger.error((Object)msg);
            throw new NullPointerException(msg + ", or is empty.");
        }
        logger.debug((Object)("\nSQL: " + sql));
        MondrianDrillThroughTableModel dtm = new MondrianDrillThroughTableModel(cell);
        dtm.setSql(sql);
        Util.PropertyList connectInfo = ((MondrianModel)this.getModel()).getConnectProperties();
        String jdbcUrl = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        dtm.setJdbcUrl(jdbcUrl);
        dtm.setJdbcUser(jdbcUser);
        dtm.setJdbcPassword(jdbcPassword);
        dtm.setDataSourceName(dataSourceName);
        dtm.setExternalDataSource(((MondrianModel)this.getModel()).getExternalDataSource());
        logger.debug((Object)"\nreturning from drillThrough...");
        return dtm;
    }

    public boolean isExtendedContext() {
        return this.extendedContext;
    }

    public void setExtendedContext(boolean extendedContext) {
        this.extendedContext = extendedContext;
    }

    private String getDrillThroughSQLAll(com.tonbeller.jpivot.olap.model.Cell cell, boolean extendedContext) {
        if (cell == null || !(cell instanceof MondrianCell)) {
            return null;
        }
        MondrianCell mCell = (MondrianCell)cell;
        Cell mc = mCell.getMonCell();
        if (mc == null) {
            return null;
        }
        String drillThroughSql = mCell.getMonCell().getDrillThroughSQL(extendedContext);
        if (drillThroughSql == null) {
            logger.error((Object)"cannot create DrillThroughSQL statement");
            return null;
        }
        String[] all = MondrianDrillThrough.getHeadMiddleTail(drillThroughSql);
        if (all == null) {
            logger.error((Object)"cannot create SQL statement");
            return null;
        }
        Object imc = ((MondrianCell)cell).getMonCell().getPropertyValue("CELL_ORDINAL");
        if (imc == null) {
            logger.error((Object)"cannot get property value");
            return null;
        }
        int cellOrdinal = -1;
        int measureColumnCount = 0;
        int tableColumnCount = 0;
        try {
            MondrianModel model = ((MondrianCell)cell).getModel();
            if (model == null) {
                return null;
            }
            QueryAdapter qa = model.getQueryAdapter();
            if (qa == null) {
                return null;
            }
            cellOrdinal = (Integer)((MondrianCell)cell).getMonCell().getPropertyValue("CELL_ORDINAL");
            Result modelResult = model.getResult();
            if (modelResult == null) {
                return null;
            }
            measureColumnCount = this.getColumnCount(modelResult, qa.isSwapAxes());
            if (measureColumnCount == 0 || cellOrdinal == -1) {
                logger.error((Object)"cannot find measure row");
                return null;
            }
            tableColumnCount = ((MondrianResult)modelResult).getPosize()[0];
            int rowCount = cellOrdinal / tableColumnCount;
            int colDisp = cellOrdinal % tableColumnCount;
            for (int i = 0; i < measureColumnCount; ++i) {
                int measureColumn;
                String middle;
                int measureIdx;
                int n = measureIdx = qa.isSwapAxes() ? rowCount : colDisp;
                if (i == measureIdx || (middle = this.getMeasureStr(cell, measureColumn = qa.isSwapAxes() ? i * tableColumnCount + colDisp : rowCount * tableColumnCount + i)) == null) continue;
                all[1] = all[1] + ", " + middle;
            }
        }
        catch (Exception e) {
            throw new JSException("get all measures failed", (Throwable)e);
        }
        return all[0] + " " + all[1] + " " + all[2];
    }

    private int getColumnCount(Result modelResult, boolean isSwap) {
        if (isSwap) {
            return ((MondrianResult)modelResult).getPosize()[1];
        }
        return ((MondrianResult)modelResult).getPosize()[0];
    }

    public static String[] getHeadMiddleTail(String s) {
        String[] result = null;
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st != null) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int idxTail = token.trim().toLowerCase().indexOf(FROM);
                if (idxTail < 0) continue;
                result = new String[3];
                result[1] = token.substring(0, idxTail + 1).trim();
                int idxHead = s.indexOf(result[1]);
                result[0] = s.substring(0, idxHead).trim();
                idxTail = s.toLowerCase().indexOf(FROM);
                result[2] = s.substring(idxTail).trim();
                break;
            }
        }
        return result;
    }

    private String getMeasureStr(com.tonbeller.jpivot.olap.model.Cell cell, int idx) throws OlapException {
        String result = null;
        MondrianModel model = ((MondrianCell)cell).getModel();
        if (model == null) {
            return null;
        }
        Result modelResult = model.getResult();
        if (modelResult == null) {
            return null;
        }
        List cellList = modelResult.getCells();
        if (cellList == null) {
            return null;
        }
        com.tonbeller.jpivot.olap.model.Cell c = (com.tonbeller.jpivot.olap.model.Cell)cellList.get(idx);
        if (c != null && this.canDrillThrough(c)) {
            String s = ((MondrianCell)c).getMonCell().getDrillThroughSQL(this.extendedContext);
            result = MondrianDrillThrough.getHeadMiddleTail(s)[1];
        }
        return result;
    }

    public void setIncludeOnlySelectedMeasure(boolean b) {
        this.includeOnlySelectedMeasure = b;
    }

    public boolean isIncludeOnlySelectedMeasure() {
        return this.includeOnlySelectedMeasure;
    }
}

