/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.mdx.SelectNode;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.olap4j.query.Olap4jNodeConverter;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.SelectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    protected final String name;
    protected Map<Axis, QueryAxis> axes = new HashMap<Axis, QueryAxis>();
    protected QueryAxis across;
    protected QueryAxis down;
    protected QueryAxis filter;
    protected QueryAxis unused;
    protected final Cube cube;
    protected Map<String, QueryDimension> dimensionMap = new HashMap<String, QueryDimension>();
    private final OlapConnection connection;
    private final SelectionFactory selectionFactory = new SelectionFactory(this);

    public Query(String name, Cube cube) throws SQLException {
        this.name = name;
        this.cube = cube;
        this.connection = cube.getSchema().getCatalog().getMetaData().getConnection().unwrap(OlapConnection.class);
        this.unused = new QueryAxis(this, null);
        for (Dimension dimension : cube.getDimensions()) {
            QueryDimension queryDimension = new QueryDimension(this, dimension);
            this.unused.getDimensions().add(queryDimension);
            this.dimensionMap.put(queryDimension.getName(), queryDimension);
        }
        this.across = new QueryAxis(this, Axis.COLUMNS);
        this.down = new QueryAxis(this, Axis.ROWS);
        this.filter = new QueryAxis(this, Axis.FILTER);
        this.axes.put(null, this.unused);
        this.axes.put(Axis.COLUMNS, this.across);
        this.axes.put(Axis.ROWS, this.down);
        this.axes.put(Axis.FILTER, this.filter);
    }

    public SelectNode getSelect() {
        return Olap4jNodeConverter.toOlap4j(this);
    }

    public Cube getCube() {
        return this.cube;
    }

    public QueryDimension getDimension(String name) {
        return this.dimensionMap.get(name);
    }

    public void swapAxes() {
        if (this.axes.size() != 4) {
            throw new IllegalArgumentException();
        }
        ArrayList<QueryDimension> tmpAcross = new ArrayList<QueryDimension>();
        tmpAcross.addAll(this.across.getDimensions());
        ArrayList<QueryDimension> tmpDown = new ArrayList<QueryDimension>();
        tmpDown.addAll(this.down.getDimensions());
        this.across.getDimensions().clear();
        this.down.getDimensions().clear();
        this.across.getDimensions().addAll(tmpDown);
        this.down.getDimensions().addAll(tmpAcross);
    }

    public Map<Axis, QueryAxis> getAxes() {
        return this.axes;
    }

    public QueryAxis getUnusedAxis() {
        return this.unused;
    }

    public boolean validate() throws OlapException {
        for (Dimension dimension : this.cube.getDimensions()) {
            QueryDimension queryDimension = this.getDimension(dimension.getName());
            if (queryDimension == null) {
                return false;
            }
            Member member = dimension.getDefaultHierarchy().getDefaultMember();
            if (queryDimension.getAxis() == null || queryDimension.getAxis().getLocation() == null) {
                queryDimension.getSelections().clear();
                queryDimension.getSelections().add(queryDimension.createSelection(member));
                continue;
            }
            if (queryDimension.getSelections().size() != 0) continue;
            queryDimension.getSelections().add(queryDimension.createSelection(member));
        }
        return true;
    }

    public CellSet execute() throws OlapException {
        SelectNode mdx = this.getSelect();
        OlapStatement olapStatement = this.connection.createStatement();
        return olapStatement.executeOlapQuery(mdx);
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    SelectionFactory getSelectionFactory() {
        return this.selectionFactory;
    }
}

