/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRImageEncoder;
import net.sf.jasperreports.engine.util.JRImageReader;
import net.sf.jasperreports.engine.util.JRJdk14ImageEncoder;
import net.sf.jasperreports.engine.util.JRJdk14ImageReader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public final class JRImageLoader {
    public static final String PROPERTY_IMAGE_READER = "net.sf.jasperreports.image.reader";
    public static final String PROPERTY_IMAGE_ENCODER = "net.sf.jasperreports.image.encoder";
    public static final String NO_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/image-16.png";
    public static final String SUBREPORT_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/subreport-16.png";
    public static final String CHART_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/chart-16.png";
    public static final String CROSSTAB_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/crosstab-16.png";
    public static final String COMPONENT_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/component-16.png";
    private static JRImageReader imageReader;
    private static JRImageEncoder imageEncoder;

    public static byte[] loadImageDataFromAWTImage(Image image, byte imageType) throws JRException {
        return imageEncoder.encode(image, imageType);
    }

    public static Image loadImage(byte[] bytes) throws JRException {
        return imageReader.readImage(bytes);
    }

    protected static Image loadImage(String image) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(image);
        if (url == null) {
            classLoader = JRImageLoader.class.getClassLoader();
        }
        InputStream is = classLoader == null ? JRImageLoader.class.getResourceAsStream("/" + image) : classLoader.getResourceAsStream(image);
        return imageReader.readImage(JRLoader.loadBytes(is));
    }

    private JRImageLoader() {
    }

    static {
        String readerClassName = JRProperties.getProperty(PROPERTY_IMAGE_READER);
        if (readerClassName == null) {
            imageReader = new JRJdk14ImageReader();
        } else {
            try {
                Class<?> clazz = JRClassLoader.loadClassForRealName(readerClassName);
                imageReader = (JRImageReader)clazz.newInstance();
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
        String encoderClassName = JRProperties.getProperty(PROPERTY_IMAGE_ENCODER);
        if (encoderClassName == null) {
            imageEncoder = new JRJdk14ImageEncoder();
        } else {
            try {
                Class<?> clazz = JRClassLoader.loadClassForRealName(encoderClassName);
                imageEncoder = (JRImageEncoder)clazz.newInstance();
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

