/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortParameterContributor
implements ParameterContributor {
    private static final Log log = LogFactory.getLog(SortParameterContributor.class);
    private final ParameterContributorContext context;

    public SortParameterContributor(ParameterContributorContext context) {
        this.context = context;
    }

    @Override
    public void contributeParameters(Map<String, Object> parameterValues) throws JRException {
        ReportContext reportContext = (ReportContext)parameterValues.get("REPORT_CONTEXT");
        if (reportContext != null) {
            String reportActionData = (String)reportContext.getParameterValue("jr.sort");
            String paramTableName = (String)reportContext.getParameterValue("jr.dsr");
            String currentDataset = JRAbstractCompiler.getUnitName(this.context.getJasperReport(), this.context.getDataset());
            if (paramTableName == null || !paramTableName.equals(currentDataset)) {
                return;
            }
            if (reportActionData != null) {
                List existingFields = (List)parameterValues.get("SORT_FIELDS");
                ArrayList<JRDesignSortField> sortFields = new ArrayList<JRDesignSortField>();
                if (existingFields != null) {
                    sortFields.addAll(existingFields);
                }
                String[] tokens = reportActionData.split(",");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    String[] chunks = SortElementUtils.extractColumnInfo(token);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding sort " + token));
                    }
                    sortFields.add(new JRDesignSortField(chunks[0], SortFieldTypeEnum.getByName(chunks[1]), SortElementUtils.getSortOrder(chunks[2])));
                }
                parameterValues.put("SORT_FIELDS", sortFields);
            }
            String paramFieldName = (String)reportContext.getParameterValue("jr.fltrFld");
            String paramFieldValue = (String)reportContext.getParameterValue("jr.fltrVl");
            if (paramFieldName != null && paramFieldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Filtering by " + paramFieldName + ": " + paramFieldValue));
                }
                FieldFilter filter = new FieldFilter(paramFieldName, paramFieldValue);
                DatasetFilter existingFilter = (DatasetFilter)parameterValues.get("FILTER");
                DatasetFilter combined = CompositeDatasetFilter.combine(existingFilter, filter);
                parameterValues.put("FILTER", combined);
            }
        }
    }
}

