/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;

public class MapElementImageProvider {
    public static JRPrintImage getImage(JRGenericPrintElement element) throws JRException {
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = Float.valueOf(latitude == null ? 0.0f : latitude.floatValue());
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = Float.valueOf(longitude == null ? 0.0f : longitude.floatValue());
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? 0 : zoom;
        int elementWidth = element.getWidth();
        int elementHeight = element.getHeight();
        String imageLocation = "http://maps.google.com/maps/api/staticmap?center=" + latitude + "," + longitude + "&size=" + elementWidth + "x" + elementHeight + "&format=jpg" + "&zoom=" + zoom + "&sensor=false";
        JRBasePrintImage printImage = new JRBasePrintImage(element.getDefaultStyleProvider());
        printImage.setX(element.getX());
        printImage.setY(element.getY());
        printImage.setWidth(element.getWidth());
        printImage.setHeight(element.getHeight());
        printImage.setStyle(element.getStyle());
        printImage.setMode(element.getModeValue());
        printImage.setBackcolor(element.getBackcolor());
        printImage.setForecolor(element.getForecolor());
        printImage.setLazy(true);
        printImage.setScaleImage(ScaleImageEnum.CLIP);
        printImage.setHorizontalAlignment(HorizontalAlignEnum.LEFT);
        printImage.setVerticalAlignment(VerticalAlignEnum.TOP);
        JRRenderable cacheRenderer = (JRRenderable)element.getParameterValue("cacheRenderer");
        if (cacheRenderer == null) {
            cacheRenderer = JRImageRenderer.getInstance(imageLocation, OnErrorTypeEnum.ERROR, false);
            cacheRenderer.getImageData();
            element.setParameterValue("cacheRenderer", cacheRenderer);
        }
        printImage.setRenderer(cacheRenderer);
        return printImage;
    }
}

