/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eigenbase.xom.Any;
import org.eigenbase.xom.CdataDef;
import org.eigenbase.xom.CommentDef;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.GenericDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.TextDef;
import org.eigenbase.xom.WrapperElementDef;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XMLUtil;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.XercesDOMParser;

public abstract class XOMUtil
extends XMLUtil {
    static final NodeDef[] emptyNodeArray = new NodeDef[0];
    static final int MSXML = 1;
    static final int XERCES = 2;

    public static void discard(boolean bl) {
    }

    public static void discard(byte by) {
    }

    public static void discard(char c) {
    }

    public static void discard(double d) {
    }

    public static void discard(float f) {
    }

    public static void discard(int n) {
    }

    public static void discard(long l) {
    }

    public static void discard(Object object) {
    }

    public static void discard(short s) {
    }

    static String capitalize(String string) {
        if (string == null || string.length() < 1) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static final Vector toVector(Object[] objectArray) {
        Vector vector = new Vector(objectArray.length);
        XOMUtil.addAll(vector, objectArray);
        return vector;
    }

    public static Object toList(Object[] objectArray) {
        ArrayList arrayList = new ArrayList(objectArray.length);
        XOMUtil.addAll(arrayList, objectArray);
        return arrayList;
    }

    public static final void addAll(Vector vector, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
    }

    public static final void addAll(List list, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            list.add(objectArray[i]);
        }
    }

    public static Object[] addElement(Object[] objectArray, Object object) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length + 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = object;
        return objectArray2;
    }

    public static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray3 = (Object[])Array.newInstance(clazz, objectArray.length + objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    public static void addChildren(ElementDef elementDef, NodeDef[] nodeDefArray) throws XOMException {
        if (elementDef instanceof GenericDef) {
            GenericDef genericDef = (GenericDef)elementDef;
            for (int i = 0; i < nodeDefArray.length; ++i) {
                genericDef.addChild(nodeDefArray[i]);
            }
        } else if (elementDef instanceof Any) {
            Any any = (Any)((Object)elementDef);
            Object[] objectArray = any.getChildren();
            if (objectArray == null) {
                objectArray = nodeDefArray instanceof ElementDef[] ? new ElementDef[]{} : new NodeDef[]{};
            }
            NodeDef[] nodeDefArray2 = (NodeDef[])XOMUtil.concatenate(objectArray, nodeDefArray);
            any.setChildren(nodeDefArray2);
        } else {
            Field field = null;
            Field[] fieldArray = elementDef.getClass().getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getType().isArray()) continue;
                field = fieldArray[i];
                break;
            }
            if (field == null) {
                throw new XOMException("cannot add field to " + elementDef.getClass() + ": it has no array field");
            }
            try {
                Object[] objectArray = (Object[])field.get(elementDef);
                Object[] objectArray2 = XOMUtil.concatenate(objectArray, nodeDefArray);
                field.set(elementDef, objectArray2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XOMException(illegalAccessException, "in XOMUtil.getChildren");
            }
        }
    }

    public static void addChild(ElementDef elementDef, ElementDef elementDef2) throws XOMException {
        XOMUtil.addChildren(elementDef, new ElementDef[]{elementDef2});
    }

    public static void addChild(ElementDef elementDef, NodeDef nodeDef) throws XOMException {
        XOMUtil.addChildren(elementDef, new NodeDef[]{nodeDef});
    }

    public static Parser createDefaultParser() throws XOMException {
        String string = "org.eigenbase.xom.wrappers.JaxpDOMParser";
        try {
            Class<?> clazz = Class.forName(string);
            return (Parser)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XOMException(classNotFoundException, "Error while creating xml parser '" + string + "'");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XOMException(illegalAccessException, "Error while creating xml parser '" + string + "'");
        }
        catch (InstantiationException instantiationException) {
            throw new XOMException(instantiationException, "Error while creating xml parser '" + string + "'");
        }
        catch (VerifyError verifyError) {
            throw new XOMException(verifyError, "Error while creating xml parser '" + string + "' " + "(If you are running Weblogic 6.1, try putting " + "xml-apis.jar and xercesImpl.jar BEFORE weblogic.jar " + "on CLASSPATH)");
        }
    }

    static Parser makeParser(int n, boolean bl, String string, String string2, String string3) throws XOMException {
        try {
            switch (n) {
                case 1: {
                    if (bl) {
                        Class<?> clazz = Class.forName("org.eigenbase.xom.wrappers.MSXMLWrapper");
                        Method method = clazz.getDeclaredMethod("createParser", new Class[0]);
                        return (Parser)method.invoke(null, new Object[0]);
                    }
                    File file = new File(string, string2);
                    Class<?> clazz = Class.forName("org.eigenbase.xom.wrappers.MSXMLWrapper");
                    Method method = clazz.getDeclaredMethod("createParser", String.class, String.class);
                    return (Parser)method.invoke(null, string3, file);
                }
                case 2: {
                    return new XercesDOMParser(!bl);
                }
            }
            throw new XOMException("Unknown parser type: " + n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XOMException(classNotFoundException, "while creating xml parser");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XOMException(illegalAccessException, "while creating xml parser");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new XOMException(noSuchMethodException, "while creating xml parser");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XOMException(invocationTargetException, "while creating xml parser");
        }
    }

    public static Object getFirstInstance(Object[] objectArray, Class clazz) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!clazz.isInstance(objectArray[i])) continue;
            return objectArray[i];
        }
        return null;
    }

    public static String wrapperToXml(DOMWrapper dOMWrapper, boolean bl) {
        try {
            NodeDef nodeDef;
            switch (dOMWrapper.getType()) {
                case 2: {
                    nodeDef = new WrapperElementDef(dOMWrapper, null, null);
                    break;
                }
                case 4: {
                    nodeDef = new CdataDef(dOMWrapper);
                    break;
                }
                case 1: {
                    nodeDef = new TextDef(dOMWrapper);
                    break;
                }
                case 3: {
                    nodeDef = new CommentDef(dOMWrapper);
                    break;
                }
                default: {
                    throw new Error("unknown node type " + dOMWrapper.getType() + " while converting node to xml");
                }
            }
            StringWriter stringWriter = new StringWriter();
            XMLOutput xMLOutput = new XMLOutput(stringWriter);
            xMLOutput.setIgnorePcdata(bl);
            xMLOutput.setGlob(true);
            nodeDef.displayXML(xMLOutput, 0);
            return stringWriter.toString();
        }
        catch (XOMException xOMException) {
            throw new Error("[" + xOMException.toString() + "] while converting node to xml");
        }
    }
}

