/*
 * Decompiled with CFR 0.152.
 */
package org.testng.spring.test;

import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.testng.spring.test.AbstractDependencyInjectionSpringContextTests;

public abstract class AbstractTransactionalSpringContextTests
extends AbstractDependencyInjectionSpringContextTests {
    protected PlatformTransactionManager transactionManager;
    protected TransactionStatus transactionStatus;
    private boolean defaultRollback = true;
    private boolean complete;

    public void setDefaultRollback(boolean defaultRollback) {
        this.defaultRollback = defaultRollback;
    }

    public void setTransactionManager(PlatformTransactionManager ptm) {
        this.transactionManager = ptm;
    }

    protected final void onSetUp() throws Exception {
        this.complete = !this.defaultRollback;
        this.onSetUpBeforeTransaction();
        if (this.transactionManager != null) {
            this.transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Began transaction: transaction manager [" + this.transactionManager + "]; defaultRollback " + this.defaultRollback));
            }
        } else {
            this.logger.info((Object)"No transaction manager set: tests will NOT run within a transaction");
        }
        this.onSetUpInTransaction();
    }

    protected void onSetUpBeforeTransaction() throws Exception {
    }

    protected void onSetUpInTransaction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onTearDown() {
        try {
            this.onTearDownInTransaction();
        }
        finally {
            this.endTransaction();
        }
        this.onTearDownAfterTransaction();
    }

    protected void onTearDownInTransaction() {
    }

    protected void onTearDownAfterTransaction() {
    }

    protected void setComplete() throws UnsupportedOperationException {
        if (this.transactionManager == null) {
            throw new UnsupportedOperationException("Cannot set complete: no transaction manager");
        }
        this.complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction() {
        if (this.transactionStatus != null) {
            try {
                if (!this.complete) {
                    this.transactionManager.rollback(this.transactionStatus);
                    this.logger.info((Object)"Rolled back transaction after test execution");
                } else {
                    this.transactionManager.commit(this.transactionStatus);
                    this.logger.info((Object)"Committed transaction after test execution");
                }
            }
            finally {
                this.transactionStatus = null;
            }
        }
    }
}

