package com.jaspersoft.jasperserver.rest.test;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.ClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RESTTest{
	
	private static final String USERNAME_PARAM = "j_username";
	private static final String PASS_PARAM = "j_password";
	private static final String ADMIN_USER_NAME = "jasperadmin";
	private static final String ADMIN_PASS = "jasperadmin";
	private static final String SCHEME = "http";  
	private static final String HOST = "localhost";
	private static final int PORT = 8080;
	
	//Server paths
	private static final String BASE_REST_URL = "/jasperserver/rest";
	
	private static final String RESOURCE_BASE_URL = "/resource";
	private static final String RESOURCES_BASE_URL = "/resources";
	private static final String LOGIN_CALL = "/login";
	protected static final String TEST_DIRECTORY = "/ContentFiles";
	
	protected static final String LIST_RESOURCES_PATH = RESOURCES_BASE_URL+ "/ContentFiles";
	protected static final String RESOURCE_CONTENT_PATH = RESOURCE_BASE_URL + "/ContentFiles";

	
	protected static final String SAMPLE_FOLDER_SERVER_ACTUAL_PATH = "/ContentFiles/JUNIT_NEW_FOLDER";
	
	protected static final String SAMPLE_FOLDER_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_NEW_FOLDER";
	protected static final String SAMPLE_DATA_TYPE_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_DATA_TYPE";
	protected static final String SAMPLE_IMAGE_FILE_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_IMAGE_FILE";
	protected static final String SAMPLE_INPUT_CONTROL_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_INPUT_CONTROL";
	protected static final String SAMPLE_INPUT_CONTROL_WITH_LOCAL_RESOURCE_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE";
	protected static final String SAMPLE_INPUT_CONTROL_WITH_REFERENCES_ERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_INPUT_CONTROL_CONTAINS_REFERENCE";
	protected static final String SAMPLE_JDBC_FILE_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_JDBC";
	protected static final String SAMPLE_LIST_OF_VALUES_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_LIST_OF_VALUES";
	protected static final String SAMPLE_OLAP_MONDRIAN_CON_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_OLAP_CLIENT_CONNECTION_TEST";
	protected static final String SAMPLE_COMPLEX_REPORT_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH";
	protected static final String SAMPLE_PROPERTIES_SERVER_PATH = RESOURCE_BASE_URL+"/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH";
	
	//Local resources paths
	protected static final String LOCAL_RESOURCES_LOCATION = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources";
	private static final String LOCAL_NEW_RESOURCE_DESCRIPTORS_LOCATION = "/descriptors/new";
	private static final String LOCAL_UPDATE_RESOURCE_DESCRIPTORS_LOCATION = "/descriptors/update";
	protected static final String LOCAL_NEW_RDS = LOCAL_RESOURCES_LOCATION + LOCAL_NEW_RESOURCE_DESCRIPTORS_LOCATION;
	protected static final String LOCAL_UPDATE_RDS = LOCAL_RESOURCES_LOCATION + LOCAL_UPDATE_RESOURCE_DESCRIPTORS_LOCATION;
	
	
	
	protected static final String SAMPLE_FOLDER_RD = "/folder_URI.newFolder.xml";
	protected static final String SAMPLE_DATA_TYPE_RD = "/dataType_URI.datasources.DataType1.xml";
	protected static final String SAMPLE_IMAGE_FILE_RD = "/imageFile_URI.ContentFiles.myImage_1.xml";
	protected static final String SAMPLE_IMAGE_FILE_BIN = "/jasperSoftLogo.jpg";
	protected static final String SAMPLE_PROPERTIES_BIN = "/JUNIT_PROPERTIES.properties";
	protected static final String SAMPLE_INPUT_CONTROL_RD = "/inputControl_URI.ContentFiles.isMyInputControl.xml";
	protected static final String SAMPLE_INPUT_CONTROL_WITH_REFERENCE_RD = "/inputControl_URI.ContentFiles.JUNIT_INPUT_CONTROL_CONTAINS_REFERENCE.xml";
	protected static final String SAMPLE_INPUT_CONTROL_WITH_LOCAL_RESOURCE_RD = "/inputControl_URI.ContentFiles.JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE.xml";
	protected static final String SAMPLE_JDBC_FILE_RD = "/jdbc_URI.ContentFiles.New_JDBC.xml";
	protected static final String SAMPLE_LIST_OF_VALUES_RD = "/listOfValues_URI.ContentFiles.JUNIT_LIST_OF_VALUES.xml";
	protected static final String SAMPLE_OLAP_MONDRIAN_CON_RD = "/olapMondrianCon_URI.ContentFiles.OLAP_CLIENT_CONNECTION_TEST.xml";
	protected static final String SAMPLE_COMPOLEX_REPORT_UNIT_RD = "/reportUnit_URI.ContentFiles.COMPLEX_REPORT_UNIT_TEST.xml";
	protected static final String SAMPLE_PROPERITES_RD = "/properities_URI.ContentFiles.JUNIT_PROPERTIES.xml";
	
	
	//Different consts
	protected static final String REQUEST_PARAMENTER_RD = "ResourceDescriptor";
	protected static final String REQUEST_PARAMENTER_RESOURCE_BIN = "ResourceBinaries";
	protected static final String REQUEST_SAMPLE_IMAGE_PATH = "/ContentFiles/JUNIT_IMAGE_FILE";
	
	protected static final String MOVE_TO = "moveTo";
	protected static final String COPY_TO = "copyTo";
	
	
	
	
	private HttpClient httpClient;
	private	CookieStore cookieStore;
	private HttpContext httpContext;
	
	
	protected HttpRequestBase httpReq;
	protected HttpRequestBase tempHttpReq;
	protected HttpResponse httpRes;

	
	private final Log log = LogFactory.getLog(getClass());
	
	@Before
	public void setUp() {
    	httpClient = new DefaultHttpClient();
    	cookieStore = new BasicCookieStore();
    	httpContext = new BasicHttpContext();
    	httpContext.setAttribute(ClientContext.COOKIE_STORE, cookieStore);
    	
    	
    	//create login call to get credentials
    	loginToServer();
     }
	
	@After
	public void tearDown() throws Exception{
    	//releasing the related streams
    	if (httpRes.getEntity().getContent().available()!=0){
    		httpRes.getEntity().getContent();
    	}
    	httpClient.getConnectionManager().closeExpiredConnections();
	}
	
	//Successful delete with a path
    public void deleteResource(String uri) throws Exception
    {
    	httpRes = executeCall(new HttpDelete(), uri);
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
    // adds a directory at /ContentFiles/JUNIT_NEW_FOLDER
    protected void putSampleFolder() throws Exception{
    	tempHttpReq = new HttpPut();
    	
    	
    	String rdFileName = LOCAL_NEW_RDS+SAMPLE_FOLDER_RD ;
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
		
		((HttpEntityEnclosingRequestBase)tempHttpReq).setEntity(reqEntity);
		
		
		//executing the request
		httpRes = executeCall(tempHttpReq, SAMPLE_FOLDER_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
    protected void putSampleImageFileResource(String serverPath) throws Exception 
    {
    	tempHttpReq = new HttpPut();
    	
    	
    	//building a multipart request
		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
		
		//appending the file descriptor from a file 
		String rdFileName = LOCAL_NEW_RDS+SAMPLE_IMAGE_FILE_RD;
		FileBody bin = new FileBody(new File(LOCAL_RESOURCES_LOCATION+SAMPLE_IMAGE_FILE_BIN));
		
		reqEntity.addPart(REQUEST_PARAMENTER_RD, new StringBody(RESTTestUtils.getResourceDescriptor(new File(rdFileName))));
		reqEntity.addPart(REQUEST_SAMPLE_IMAGE_PATH, bin );
		
		((HttpEntityEnclosingRequestBase)tempHttpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(tempHttpReq, serverPath);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
    protected void putSampleFile(String rdPath, String binPath, String serverPath) throws Exception 
    {
    	tempHttpReq = new HttpPut();
    	
    	
    	//building a multipart request
		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
		
		//appending the file descriptor from a file 
		String rdFileName = LOCAL_NEW_RDS+rdPath;
		FileBody bin = new FileBody(new File(LOCAL_RESOURCES_LOCATION+binPath));
		
		reqEntity.addPart(REQUEST_PARAMENTER_RD, new StringBody(RESTTestUtils.getResourceDescriptor(new File(rdFileName))));
		reqEntity.addPart(REQUEST_SAMPLE_IMAGE_PATH, bin );
		
		((HttpEntityEnclosingRequestBase)tempHttpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(tempHttpReq, serverPath);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
    protected void putSampleResource(String rd_path, String call_path) throws Exception
    {
    	tempHttpReq = new HttpPut();

    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(LOCAL_NEW_RDS + rd_path)));
		((HttpEntityEnclosingRequestBase)tempHttpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(tempHttpReq, call_path);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
    private void loginToServer() {
    	//building the request parameters
    	List<NameValuePair> qparams = new ArrayList<NameValuePair>();
    	qparams.add(new BasicNameValuePair(USERNAME_PARAM, ADMIN_USER_NAME));
    	qparams.add(new BasicNameValuePair(PASS_PARAM, ADMIN_PASS));
    	
    	try {
    		httpReq = new HttpPost();
    		executeCall(httpReq, LOGIN_CALL, qparams);
			
    		//consuming the content to close the stream
			IOUtils.toString(httpRes.getEntity().getContent());
    	}
    	catch (Exception e) {
			e.printStackTrace();
		}
	}
    
    protected HttpResponse executeCall(HttpRequestBase req, String action_path) throws Exception
    {
    	URI uri = createURI(action_path, null);
    	req.setURI(uri);
    	
    	httpRes = httpClient.execute(req, httpContext);

    	return httpRes;
    }
    
    protected HttpResponse executeCall(HttpRequestBase req, String action_path, List<NameValuePair> qparams) throws Exception
    {
    	req.setURI(createURI(action_path, qparams));
    	httpRes = httpClient.execute(req, httpContext);
    	
    	return httpRes;
    }
    
    private URI createURI(String action_path, List<NameValuePair> qparams) throws Exception{
    	URI uri;
    	if (qparams!=null)
	    	uri = URIUtils.createURI(SCHEME, HOST, PORT, BASE_REST_URL+action_path, URLEncodedUtils.format(qparams, "UTF-8"), null);
	    
	    else
	    	uri = (new URL(SCHEME, HOST, PORT, BASE_REST_URL+action_path)).toURI(); 
	    return uri;
    }
    
    protected boolean isValidResposnse() throws Exception{
    	return isValidResposnse(HttpStatus.SC_OK);
    }
    
    protected boolean isValidResposnse(int expected_respose_code) throws Exception{
    	String body = EntityUtils.toString(httpRes.getEntity());
    	//System.out.println(body);

    	return 	httpRes.getStatusLine().getStatusCode()==expected_respose_code;
    }

}
