/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util;

import org.hibernate.criterion.*;

/**
 * @author Yuriy Plakosh
 */
public class ResourceCriterionUtils {

    public static Criterion getTextCriterion(String text) {
        String[] words = text.trim().split("\\s+");

        Conjunction wordsCriterion = Restrictions.conjunction();

        for (String word : words) {
            Disjunction wordCriterion = Restrictions.disjunction();

            // Each word should be in label or in description.
            wordCriterion.add(new IlikeEscapeAwareExpression("label", word, MatchMode.ANYWHERE));
            wordCriterion.add(new IlikeEscapeAwareExpression("description", word, MatchMode.ANYWHERE));

            // Resource should contain all the words.
            wordsCriterion.add(wordCriterion);
        }

        return wordsCriterion;
    }
}
