/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.action;

import java.util.HashMap;
import java.util.Map;

import org.springframework.webflow.execution.RequestContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.JRParameter;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: BaseHttpServlet.java 4336 2011-05-24 13:30:34Z teodord $
 */
public class WebflowReportContext implements ReportContext
{
	/**
	 *
	 */
	private static final String SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX = "net.sf.jasperreports.web.report.context_";
	public static final String PARAMETER_FLOW_REPORT_CONTEXT = "rptCtx";//"jr.ctxid";

	public static final String REPORT_CONTEXT_PARAMETER_JASPER_PRINT = "net.sf.jasperreports.web.jasper_print";
	public static final String REPORT_CONTEXT_PARAMETER_JASPER_REPORT = "net.sf.jasperreports.web.jasper_report";
	
	/**
	 *
	 */
	//private ThreadLocal<RequestContext> threadLocalRequest = new ThreadLocal<RequestContext>();
	private RequestContext request;
	private Map<String, Object> parameterValues;
	private Map flowValues;
	private String id;
	
	/**
	 *
	 */
	public static final WebflowReportContext getInstance(RequestContext requestContext)
	{
		return getInstance(requestContext, true);
	}

	/**
	 *
	 */
	public static final WebflowReportContext getInstance(Map flowValues)
	{
		WebflowReportContext webflowReportContext = new WebflowReportContext();
		webflowReportContext.setFlowValues(flowValues);
		return webflowReportContext;
	}

	/**
	 *
	 */
	public static final WebflowReportContext getInstance(RequestContext requestContext, boolean create)
	{
		Map flowValues = null;
		//WebflowReportContext webflowReportContext = null;
		WebflowReportContext webflowReportContext = new WebflowReportContext();

		//String reportContextId = requestContext.getFlowScope().getString(REQUEST_PARAMETER_REPORT_CONTEXT_ID);
		flowValues = (Map)requestContext.getFlowScope().get(PARAMETER_FLOW_REPORT_CONTEXT);
		if (flowValues != null)
		{
			//FIXMEJIVE webflowReportContext = (WebflowReportContext)requestContext.getSession().getAttribute(getSessionAttributeName(reportContextId));
			//webflowReportContext = (WebflowReportContext)requestContext.getFlowScope().get(getSessionAttributeName(reportContextId));
			//webflowReportContext = (WebflowReportContext)requestContext.getSession().getAttribute(getSessionAttributeName(reportContextId));
			//webflowReportContext = (WebflowReportContext)requestContext.getExternalContext().getSessionMap().get(getSessionAttributeName(reportContextId));
			//flowValues = (Map)requestContext.getFlowScope().get(getSessionAttributeName(reportContextId));
		}

		//if (webflowReportContext == null && create)
		if (flowValues == null)
		{
			//webflowReportContext = new WebflowReportContext();
			//FIXMEJIVE requestContext.getSession().setAttribute(webflowReportContext.getSessionAttributeName(), webflowReportContext);
			//requestContext.getFlowScope().put(webflowReportContext.getSessionAttributeName(), webflowReportContext);
			//requestContext.getSession().setAttribute(webflowReportContext.getSessionAttributeName(), webflowReportContext);
			//requestContext.getExternalContext().getSessionMap().put(webflowReportContext.getSessionAttributeName(), webflowReportContext);
			flowValues = new HashMap();
		}

		flowValues.putAll(requestContext.getRequestParameters().asMap());
		requestContext.getFlowScope().put(PARAMETER_FLOW_REPORT_CONTEXT, flowValues);//FIXMEJIVE
		
//		if (webflowReportContext != null)
//		{
			webflowReportContext.setRequestContext(requestContext);
			webflowReportContext.setFlowValues(flowValues);
//		}
		
		return webflowReportContext;
	}

	/**
	 *
	 */
	private WebflowReportContext()
	{
		parameterValues = new HashMap<String, Object>();
		parameterValues.put(JRParameter.REPORT_CONTEXT, this);
	}

	/**
	 *
	 */
	public String getId()
	{
		if (id == null)
		{
			id = String.valueOf(System.currentTimeMillis());//FIXMEJIVE make stronger?
		}
		return id;
	}

	/**
	 *
	 */
	public RequestContext getRequestContext()
	{
		//return threadLocalRequest.get();
		return request;
	}

	/**
	 *
	 */
	public void setRequestContext(RequestContext request)
	{
		//threadLocalRequest.set(request);
		this.request = request;
	}

	/**
	 *
	 */
	public Map getFlowValues()
	{
		//return threadLocalRequest.get();
		return flowValues;
	}

	/**
	 *
	 */
	public void setFlowValues(Map flowValues)
	{
		//threadLocalRequest.set(request);
		this.flowValues = flowValues;
	}

	/**
	 *
	 */
	public String getSessionAttributeName()
	{
		return getSessionAttributeName(getId());
	}

	/**
	 *
	 */
	public Object getParameterValue(String parameterName)
	{
		Object requestParameterValue = null;

		RequestContext requestContext = getRequestContext();
		
		if (requestContext != null)
		{
			//Object requestParameterValue = requestContext.getFlowScope().get(parameterName);
			requestParameterValue = requestContext.getRequestParameters().get(parameterName);
			//Object requestParameterValue = requestContext.getRequestScope().get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}

			requestParameterValue = requestContext.getRequestScope().get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}
			
			requestParameterValue = requestContext.getFlowScope().get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}
		}
//		Map jiveMap = (Map)requestContext.getFlowScope().get("jive");
//		if (jiveMap != null)
//		{
//			requestParameterValue = jiveMap.get(parameterName);
//			if (requestParameterValue != null)
//			{
//				return requestParameterValue;
//			}
//		}

		if (flowValues != null)
		{
			requestParameterValue = flowValues.get(parameterName);
			if (requestParameterValue != null)
			{
				return requestParameterValue;
			}
		}
		
		return parameterValues.get(parameterName);
	}

	/**
	 *
	 */
	public boolean containsParameter(String parameterName)
	{
		RequestContext requestContext = getRequestContext();
		boolean contains = requestContext.getRequestParameters().contains(parameterName);
		return contains ? contains : parameterValues.containsKey(parameterName);
	}

	/**
	 *
	 */
	public void setParameterValue(String parameterName, Object value)
	{
		parameterValues.put(parameterName, value);
	}

	/**
	 *
	 */
	public void setParameterValues(Map<String, Object> newValues)
	{
		parameterValues.putAll(newValues);
	}

	/**
	 *
	 */
	public Map<String, Object> getParameterValues()
	{
		return parameterValues;
	}

	/**
	 *
	 */
	private static final String getSessionAttributeName(String id)
	{
		return SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX + id;
	}
}
