/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.tags.BaseTagSupport;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class CalendarInputTag
extends BaseTagSupport {
    public static final String DEFAULT_DATE_FORMAT_MESSAGE = "calendar.date.format";
    public static final String DEFAULT_DATETIME_FORMAT_MESSAGE = "calendar.datetime.format";
    public static final String DEFAULT_IMAGE = "/images/cal.gif";
    private boolean time = true;
    private String formatPattern;
    private String name;
    private String value;
    private String timezoneOffset;
    private boolean readOnly = false;
    private String onchange;
    private String imageSrc;
    private String imageTipMessage;
    private String calendarInputJsp;

    protected int doStartTagInternal() {
        return 0;
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        WebApplicationContext applicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", this.name);
        attributes.put("value", this.value);
        attributes.put("onchange", this.onchange);
        attributes.put("readOnly", this.isReadOnly());
        attributes.put("imageSrc", this.getImageSource(request));
        attributes.put("imageTooltip", this.getImageTooltip(applicationContext, locale));
        attributes.put("pattern", this.getPattern(applicationContext, locale));
        attributes.put("hasTime", this.time);
        attributes.put("timezoneOffset", this.getTimezoneOffset(request));
        this.includeNested(this.getJsp(), attributes);
        return 0;
    }

    protected String getPattern(WebApplicationContext applicationContext, Locale locale) {
        String pattern = this.formatPattern;
        if (pattern == null) {
            String message = this.isTime() ? DEFAULT_DATETIME_FORMAT_MESSAGE : DEFAULT_DATE_FORMAT_MESSAGE;
            pattern = applicationContext.getMessage(message, null, locale);
        }
        return pattern;
    }

    protected String getImageSource(HttpServletRequest request) {
        String imageSource = this.imageSrc;
        if (imageSource == null) {
            imageSource = request.getContextPath() + DEFAULT_IMAGE;
        }
        return imageSource;
    }

    protected String getImageTooltip(WebApplicationContext applicationContext, Locale locale) {
        String message = null;
        if (this.imageTipMessage != null) {
            message = applicationContext.getMessage(this.imageTipMessage, null, locale);
        }
        return message;
    }

    protected String getTimezoneOffset(HttpServletRequest request) {
        String tzOffset = this.timezoneOffset;
        if (tzOffset == null) {
            TimeZone timezone = JasperServerUtil.getTimezone(request);
            int offset = timezone.getOffset(System.currentTimeMillis());
            tzOffset = Integer.toString(offset);
        }
        return tzOffset;
    }

    protected String getJsp() {
        String jsp = this.calendarInputJsp;
        if (jsp == null) {
            jsp = this.getConfiguration().getCalendarInputJsp();
        }
        return jsp;
    }

    public void release() {
        this.time = true;
        this.formatPattern = null;
        this.name = null;
        this.value = null;
        this.readOnly = false;
        this.onchange = null;
        this.imageSrc = null;
        this.imageTipMessage = null;
        super.release();
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getImageSrc() {
        return this.imageSrc;
    }

    public void setImageSrc(String imageSrc) {
        this.imageSrc = imageSrc;
    }

    public String getImageTipMessage() {
        return this.imageTipMessage;
    }

    public void setImageTipMessage(String imageTipMessage) {
        this.imageTipMessage = imageTipMessage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onChange) {
        this.onchange = onChange;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isTime() {
        return this.time;
    }

    public void setTime(boolean time) {
        this.time = time;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public void setTimezoneOffset(String timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    public String getCalendarInputJsp() {
        return this.calendarInputJsp;
    }

    public void setCalendarInputJsp(String calendarInputJsp) {
        this.calendarInputJsp = calendarInputJsp;
    }
}

