/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.security;

import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.switchuser.SwitchUserProcessingFilter;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ThemeResolver;

public class JSSwitchUserProcessingFilter
extends SwitchUserProcessingFilter {
    private String jsTargetUrl;
    private String exitTargetUrl;
    private AuditContext auditContext;
    private ThemeResolver themeResolver;

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.hasLength((String)this.jsTargetUrl, (String)"jsTargetUrl must be specified");
        Assert.hasLength((String)this.exitTargetUrl, (String)"exitTargetUrl must be specified");
    }

    private void createAuditEvent(final String eventTypeName) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                JSSwitchUserProcessingFilter.this.auditContext.createAuditEvent(eventTypeName);
            }
        });
    }

    private String getTenantId(Authentication authentication) {
        String tenantId = "";
        Object principal = authentication.getPrincipal();
        if (principal instanceof TenantQualified) {
            tenantId = ((TenantQualified)principal).getTenantId();
        }
        return tenantId;
    }

    private void addParamsToSwitchUserAuditEvent(final Authentication authentication) {
        this.auditContext.doInAuditContext("switchUser", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                JSSwitchUserProcessingFilter.this.auditContext.addPropertyToAuditEvent("username", (Object)authentication.getName(), auditEvent);
                JSSwitchUserProcessingFilter.this.auditContext.addPropertyToAuditEvent("organization", (Object)JSSwitchUserProcessingFilter.this.getTenantId(authentication), auditEvent);
            }
        });
    }

    private void addParamsToExitUserAuditEvent(final Authentication authentication) {
        this.auditContext.doInAuditContext("exitSwitchedUser", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                String loggedInUserName = auditEvent.getUsername();
                String loggedInTenantId = auditEvent.getTenantId();
                auditEvent.setUsername(authentication.getName());
                auditEvent.setTenantId(JSSwitchUserProcessingFilter.this.getTenantId(authentication));
                JSSwitchUserProcessingFilter.this.auditContext.addPropertyToAuditEvent("username", (Object)loggedInUserName, auditEvent);
                JSSwitchUserProcessingFilter.this.auditContext.addPropertyToAuditEvent("organization", (Object)loggedInTenantId, auditEvent);
            }
        });
    }

    private void closeAuditEvent(String eventTypeName) {
        this.auditContext.doInAuditContext(eventTypeName, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                JSSwitchUserProcessingFilter.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public void doFilterHttp(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
        if (this.requiresSwitchUser(httpRequest)) {
            this.createAuditEvent("switchUser");
            Authentication targetUser = this.attemptSwitchUser(httpRequest);
            this.addParamsToSwitchUserAuditEvent(targetUser);
            SecurityContextHolder.getContext().setAuthentication(targetUser);
            httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpRequest.getContextPath() + this.jsTargetUrl));
            this.closeAuditEvent("switchUser");
            this.themeResolver.setThemeName(httpRequest, httpResponse, null);
            return;
        }
        if (this.requiresExitUser(httpRequest)) {
            this.createAuditEvent("exitSwitchedUser");
            Authentication originalUser = this.attemptExitUser(httpRequest);
            this.addParamsToExitUserAuditEvent(originalUser);
            SecurityContextHolder.getContext().setAuthentication(originalUser);
            httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpRequest.getContextPath() + this.exitTargetUrl));
            this.closeAuditEvent("exitSwitchedUser");
            this.themeResolver.setThemeName(httpRequest, httpResponse, null);
            return;
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void setTargetUrl(String targetUrl) {
        super.setTargetUrl(targetUrl);
        this.jsTargetUrl = targetUrl;
    }

    public void setExitTargetUrl(String exitTargetUrl) {
        this.exitTargetUrl = exitTargetUrl;
    }

    public ThemeResolver getThemeResolver() {
        return this.themeResolver;
    }

    public void setThemeResolver(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
    }
}

