/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.common.util.TimeZonesList;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityServiceImpl;
import com.jaspersoft.jasperserver.war.common.HeartbeatBean;
import com.jaspersoft.jasperserver.war.common.HeartbeatClientInfo;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.LocalesList;
import com.jaspersoft.jasperserver.war.control.JRBaseMultiActionController;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.web.servlet.ModelAndView;

public class JSCommonController
extends JRBaseMultiActionController {
    protected HeartbeatBean heartbeat;
    private LocalesList locales;
    private TimeZonesList timezones;
    private String allowUserPasswordChange;
    private String passwordExpirationInDays;
    private static final String LICENSE_MANAGER = "com.jaspersoft.ji.license.LicenseManager";
    private static Log log = LogFactory.getLog(JSCommonController.class);

    public ModelAndView homePage(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        return new ModelAndView("modules/home");
    }

    public ModelAndView login(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        this.setupLoginPage(req);
        return new ModelAndView("modules/login/login");
    }

    protected void setupLoginPage(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        String locale = null;
        String preferredTz = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals(JasperServerConstImpl.getUserLocaleSessionAttr())) {
                    locale = cookie.getValue();
                }
                if (!cookie.getName().equals(JasperServerConstImpl.getUserTimezoneSessionAttr())) continue;
                preferredTz = cookie.getValue();
            }
        }
        Locale displayLocale = req.getLocale();
        String preferredLocale = locale == null || locale.length() == 0 ? displayLocale.toString() : locale;
        if (preferredTz == null) {
            preferredTz = this.timezones.getDefaultTimeZoneID();
        }
        req.setAttribute("preferredLocale", (Object)preferredLocale);
        req.setAttribute("userLocales", (Object)this.locales.getUserLocales(displayLocale));
        req.setAttribute("preferredTimezone", (Object)preferredTz);
        req.setAttribute("userTimezones", (Object)this.timezones.getTimeZones(displayLocale));
        try {
            if (Integer.parseInt(this.passwordExpirationInDays) > 0) {
                this.allowUserPasswordChange = "true";
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        req.setAttribute("allowUserPasswordChange", (Object)this.allowUserPasswordChange);
        req.setAttribute("passwordExpirationInDays", (Object)this.passwordExpirationInDays);
        req.setAttribute("usersExceeded", (Object)this.usersExceeded());
        req.setAttribute("banUser", (Object)this.banUser());
    }

    public ModelAndView heartbeat(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        boolean isCallPermitted = false;
        String permit = req.getParameter("permit");
        if (permit != null) {
            isCallPermitted = Boolean.valueOf(permit);
        }
        this.heartbeat.permitCall(isCallPermitted);
        return new ModelAndView("ajax/ajaxresponse");
    }

    public ModelAndView heartbeatInfo(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        final HeartbeatClientInfo info = new HeartbeatClientInfo();
        info.setNavigatorAppName(req.getParameter("navAppName"));
        info.setNavigatorAppVersion(req.getParameter("navAppVersion"));
        info.setNavigatorLocale(req.getLocale());
        info.setUserLocale(LocaleContextHolder.getLocale());
        if (req.getParameter("scrWidth") != null) {
            info.setScreenWidth(new Integer(req.getParameter("scrWidth")));
        }
        if (req.getParameter("scrHeight") != null) {
            info.setScreenHeight(new Integer(req.getParameter("scrHeight")));
        }
        if (req.getParameter("scrColorDepth") != null) {
            info.setScreenColorDepth(new Integer(req.getParameter("scrColorDepth")));
        }
        info.setUserAgent(req.getHeader("user-agent"));
        new Thread(new Runnable(){

            public void run() {
                JSCommonController.this.heartbeat.updateClientInfo(info);
            }
        }).start();
        return new ModelAndView("ajax/ajaxresponse");
    }

    public ModelAndView exitUser(HttpServletRequest req, HttpServletResponse res) {
        String redirectURL = "/logout.html?showPasswordChange=" + req.getParameter("showPasswordChange");
        if (UserAuthorityServiceImpl.isUserSwitched()) {
            redirectURL = "/j_acegi_exit_user";
        }
        return new ModelAndView("redirect:" + redirectURL);
    }

    public ModelAndView logout(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        SecurityContextHolder.clearContext();
        return new ModelAndView("redirect:/login.html?showPasswordChange=" + req.getParameter("showPasswordChange"));
    }

    public ModelAndView loginError(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        log.warn((Object)"There was a login error");
        return new ModelAndView("modules/loginError");
    }

    public ModelAndView menuTest(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        return new ModelAndView("menutest");
    }

    public boolean isProVersion() {
        boolean isPro;
        block3: {
            isPro = false;
            try {
                Class<?> clazz = Class.forName(LICENSE_MANAGER);
                if (clazz != null) {
                    isPro = true;
                }
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.info((Object)"This is not a pro version. Access is denied");
            }
        }
        return isPro;
    }

    public boolean usersExceeded() {
        boolean exceeded;
        block3: {
            exceeded = false;
            if (this.isProVersion()) {
                try {
                    Class<?> clazz = Class.forName(LICENSE_MANAGER);
                    Method method = clazz.getDeclaredMethod("isUsersCountExceeded", new Class[0]);
                    exceeded = (Boolean)method.invoke(method.getDeclaringClass(), new Object[0]);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.info((Object)"This is not a pro version. Access is denied");
                }
            }
        }
        return exceeded;
    }

    public boolean banUser() {
        boolean banUser;
        block3: {
            banUser = false;
            if (this.isProVersion()) {
                try {
                    Class<?> clazz = Class.forName(LICENSE_MANAGER);
                    Method method = clazz.getDeclaredMethod("banUserRole", new Class[0]);
                    banUser = (Boolean)method.invoke(method.getDeclaringClass(), new Object[0]);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.info((Object)"This is not a pro version. Access is denied");
                }
            }
        }
        return banUser;
    }

    public LocalesList getLocales() {
        return this.locales;
    }

    public void setLocales(LocalesList locales) {
        this.locales = locales;
    }

    public TimeZonesList getTimezones() {
        return this.timezones;
    }

    public void setTimezones(TimeZonesList timezones) {
        this.timezones = timezones;
    }

    public String getAllowUserPasswordChange() {
        return this.allowUserPasswordChange;
    }

    public void setAllowUserPasswordChange(String changePassword) {
        this.allowUserPasswordChange = changePassword;
    }

    public String getPasswordExpirationInDays() {
        return this.passwordExpirationInDays;
    }

    public void setPasswordExpirationInDays(String passwordExpirationInDays) {
        this.passwordExpirationInDays = passwordExpirationInDays;
    }

    public HeartbeatBean getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(HeartbeatBean heartbeat) {
        this.heartbeat = heartbeat;
    }
}

