/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.ReportContext;
import org.springframework.webflow.execution.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebflowReportContext
implements ReportContext {
    private static final String SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX = "net.sf.jasperreports.web.report.context_";
    public static final String PARAMETER_FLOW_REPORT_CONTEXT = "rptCtx";
    public static final String REPORT_CONTEXT_PARAMETER_JASPER_PRINT = "net.sf.jasperreports.web.jasper_print";
    public static final String REPORT_CONTEXT_PARAMETER_JASPER_REPORT = "net.sf.jasperreports.web.jasper_report";
    private RequestContext request;
    private Map<String, Object> parameterValues = new HashMap<String, Object>();
    private Map flowValues;
    private String id;

    public static final WebflowReportContext getInstance(RequestContext requestContext) {
        return WebflowReportContext.getInstance(requestContext, true);
    }

    public static final WebflowReportContext getInstance(Map flowValues) {
        WebflowReportContext webflowReportContext = new WebflowReportContext();
        webflowReportContext.setFlowValues(flowValues);
        return webflowReportContext;
    }

    public static final WebflowReportContext getInstance(RequestContext requestContext, boolean create) {
        HashMap flowValues = null;
        WebflowReportContext webflowReportContext = new WebflowReportContext();
        flowValues = (HashMap)requestContext.getFlowScope().get(PARAMETER_FLOW_REPORT_CONTEXT);
        if (flowValues != null) {
            // empty if block
        }
        if (flowValues == null) {
            flowValues = new HashMap();
        }
        flowValues.putAll(requestContext.getRequestParameters().asMap());
        requestContext.getFlowScope().put(PARAMETER_FLOW_REPORT_CONTEXT, flowValues);
        webflowReportContext.setRequestContext(requestContext);
        webflowReportContext.setFlowValues(flowValues);
        return webflowReportContext;
    }

    private WebflowReportContext() {
        this.parameterValues.put("REPORT_CONTEXT", this);
    }

    public String getId() {
        if (this.id == null) {
            this.id = String.valueOf(System.currentTimeMillis());
        }
        return this.id;
    }

    public RequestContext getRequestContext() {
        return this.request;
    }

    public void setRequestContext(RequestContext request) {
        this.request = request;
    }

    public Map getFlowValues() {
        return this.flowValues;
    }

    public void setFlowValues(Map flowValues) {
        this.flowValues = flowValues;
    }

    public String getSessionAttributeName() {
        return WebflowReportContext.getSessionAttributeName(this.getId());
    }

    public Object getParameterValue(String parameterName) {
        Object requestParameterValue = null;
        RequestContext requestContext = this.getRequestContext();
        if (requestContext != null) {
            requestParameterValue = requestContext.getRequestParameters().get(parameterName);
            if (requestParameterValue != null) {
                return requestParameterValue;
            }
            requestParameterValue = requestContext.getRequestScope().get(parameterName);
            if (requestParameterValue != null) {
                return requestParameterValue;
            }
            requestParameterValue = requestContext.getFlowScope().get(parameterName);
            if (requestParameterValue != null) {
                return requestParameterValue;
            }
        }
        if (this.flowValues != null && (requestParameterValue = this.flowValues.get(parameterName)) != null) {
            return requestParameterValue;
        }
        return this.parameterValues.get(parameterName);
    }

    public boolean containsParameter(String parameterName) {
        RequestContext requestContext = this.getRequestContext();
        boolean contains = requestContext.getRequestParameters().contains(parameterName);
        return contains ? contains : this.parameterValues.containsKey(parameterName);
    }

    public void setParameterValue(String parameterName, Object value) {
        this.parameterValues.put(parameterName, value);
    }

    public void setParameterValues(Map<String, Object> newValues) {
        this.parameterValues.putAll(newValues);
    }

    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    private static final String getSessionAttributeName(String id) {
        return SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX + id;
    }
}

