/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.VirtualizerFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.war.action.ReportCanceledException;
import com.jaspersoft.jasperserver.war.action.ReportParametersAction;
import com.jaspersoft.jasperserver.war.action.WebflowReportContext;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFactoryFlowFactory;
import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ViewReportAction
extends ReportParametersAction {
    protected static final Log log = LogFactory.getLog(ViewReportAction.class);
    public static final String REPORTUNIT_URI = "reportUnit";
    private String flowAttributeInhibitRequestParsing;
    private String requestParameterPageIndex;
    private String flowAttributePageIndex;
    private String requestAttributeHtmlLinkHandlerFactory;
    private String flowAttributeDepth;
    private String flowAttributeJasperPrintName;
    private HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory;
    private String flowAttributeIsSubflow;
    private String requestParameterReportOutput;
    private String flowAttributeReportOutput;
    private String flowAttributeUseClientTimezone;
    private SessionObjectSerieAccessor jasperPrintAccessor;
    private VirtualizerFactory virtualizerFactory;
    private Map configuredExporters;
    private String attributeReportControlsLayout;
    private String attributeReportForceControls;
    private String attributeSavedInputsState;
    private String attributeControlsHidden;
    private String attributeDashboardParametersHasError;
    private String attributeReportLocale;
    private String attributeNeedsInput;
    private String parameterReportLocale;
    private AuditContext auditContext;
    private String requestParameterAnchor;
    private String flowAttributeInitialPageIndex;
    private String flowAttributeInitialAnchor;

    protected void createInputControlsAuditEvent() {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ViewReportAction.this.auditContext.createAuditEvent("inputControlsQuery");
            }
        });
    }

    protected void setResourceUriToInputControlsAuditEvent(final String resourceUri) {
        this.auditContext.doInAuditContext("inputControlsQuery", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                if (auditEvent.getResourceUri() == null) {
                    auditEvent.setResourceUri(resourceUri);
                }
            }
        });
    }

    protected void closeInputControlsAuditEvent() {
        this.auditContext.doInAuditContext("inputControlsQuery", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ViewReportAction.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public Event checkForParams(RequestContext context) throws Exception {
        String reportOutput;
        String standAlone;
        this.createInputControlsAuditEvent();
        MutableAttributeMap flowScope = context.getFlowScope();
        Integer depth = flowScope.getInteger(this.getFlowAttributeDepth());
        if (depth == null) {
            depth = new Integer(0);
            flowScope.put(this.getFlowAttributeDepth(), (Object)depth);
        }
        boolean isSubflow = !context.getFlowExecutionContext().getActiveSession().isRoot();
        flowScope.put(this.getFlowAttributeIsSubflow(), (Object)isSubflow);
        String folderURI = context.getRequestParameters().get("ParentFolderUri");
        if (folderURI != null) {
            flowScope.put("ParentFolderUri", (Object)folderURI);
        }
        if ((standAlone = context.getRequestParameters().get("standAlone")) != null) {
            flowScope.put("standAlone", (Object)standAlone);
        }
        if ((reportOutput = context.getRequestParameters().get(this.getRequestParameterReportOutput())) != null) {
            flowScope.put(this.getFlowAttributeReportOutput(), (Object)reportOutput);
        }
        try {
            Integer initialPageIndex = context.getRequestParameters().getInteger(this.requestParameterPageIndex);
            if (initialPageIndex != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting initial page index to " + initialPageIndex));
                }
                flowScope.put(this.flowAttributeInitialPageIndex, (Object)initialPageIndex);
            }
        }
        catch (ConversionExecutionException e) {
            log.debug((Object)("Unable to parse page index parameter with value " + context.getRequestParameters().get(this.requestParameterPageIndex)));
        }
        String initialAnchor = context.getRequestParameters().get(this.requestParameterAnchor);
        if (initialAnchor != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting initial anchor to " + initialAnchor));
            }
            flowScope.put(this.flowAttributeInitialAnchor, (Object)initialAnchor);
        }
        this.setReportLocale(context);
        boolean parseRequest = this.toParseRequest(context);
        flowScope.put(this.getFlowAttributeUseClientTimezone(), (Object)(!parseRequest ? 1 : 0));
        try {
            this.createWrappers(context);
            flowScope.put(this.getAttributeNeedsInput(), (Object)this.needsInput(context, (List)flowScope.get("wrappers")));
            this.saveInputsState(context);
        }
        catch (Exception e) {
            if ("true".equals(context.getRequestParameters().get("viewAsDashboardFrame"))) {
                context.getFlashScope().put(this.getAttributeDashboardParametersHasError(), (Object)"true");
            }
            throw e;
        }
        this.closeInputControlsAuditEvent();
        return this.success();
    }

    protected void setReportLocale(RequestContext context) {
        Locale locale = (Locale)context.getFlowScope().get(this.getAttributeReportLocale(), Locale.class);
        if (locale == null) {
            String localeCode = context.getRequestParameters().get(this.getParameterReportLocale());
            locale = localeCode == null ? LocaleContextHolder.getLocale() : LocaleHelper.getInstance().getLocale(localeCode);
            context.getFlowScope().put(this.getAttributeReportLocale(), (Object)locale);
        }
    }

    protected void setReportUnitAttributes(RequestContext context, ReportUnit reportUnit) {
        super.setReportUnitAttributes(context, reportUnit);
        MutableAttributeMap flowScope = context.getFlowScope();
        flowScope.put(this.getAttributeReportControlsLayout(), (Object)new Byte(reportUnit.getControlsLayout()));
        flowScope.put(this.getAttributeReportForceControls(), (Object)reportUnit.isAlwaysPromptControls());
    }

    protected boolean isForceControls(RequestContext context) {
        Boolean force = context.getFlowScope().getBoolean(this.getAttributeReportForceControls());
        return force != null && force != false;
    }

    protected boolean isControlsDialog(RequestContext context) {
        Byte layoutType = (Byte)context.getFlowScope().get(this.getAttributeReportControlsLayout(), Byte.class);
        return layoutType != null && layoutType == 1;
    }

    protected boolean toParseRequest(RequestContext context) {
        Boolean inhibitRequestParsingAttr = context.getFlowScope().getBoolean(this.getFlowAttributeInhibitRequestParsing());
        boolean parseRequest = inhibitRequestParsingAttr == null || inhibitRequestParsingAttr == false;
        return parseRequest;
    }

    protected boolean needsInput(RequestContext context, List wrappers) {
        boolean needsInput = super.needsInput(context, wrappers);
        if (needsInput && this.validateValues(wrappers, false) && !this.isForceControls(context)) {
            needsInput = false;
        }
        return needsInput;
    }

    protected void addReportExecutionParameters(RequestContext context, Map parameterValues) {
        if (this.virtualizerFactory != null) {
            parameterValues.put("REPORT_VIRTUALIZER", this.virtualizerFactory.getVirtualizer());
        }
        this.setReportLocaleParameter(context, parameterValues);
        WebflowReportContext webflowReportContext = WebflowReportContext.getInstance(context);
        parameterValues.put("REPORT_CONTEXT", webflowReportContext);
    }

    protected void setReportLocaleParameter(RequestContext context, Map parameterValues) {
        Locale locale = (Locale)context.getFlowScope().get(this.getAttributeReportLocale(), Locale.class);
        if (locale != null) {
            parameterValues.put("REPORT_LOCALE", locale);
        }
    }

    public Event parseRequestParameters(RequestContext context) {
        List wrappers = this.getInputControlWrappers(context);
        if (!this.parseRequest(context, wrappers, true)) {
            return this.error();
        }
        return this.success();
    }

    public Event runReport(RequestContext context) {
        ReportUnitResult result = this.executeReport(context);
        this.setJasperPrint(context, result);
        Integer pageIndex = this.getInitialPageIndex(result, context);
        if (pageIndex == null) {
            context.getFlowScope().remove(this.getFlowAttributePageIndex());
        } else {
            context.getFlowScope().put(this.getFlowAttributePageIndex(), (Object)pageIndex);
        }
        this.saveInputsState(context);
        return this.success();
    }

    protected Integer getInitialPageIndex(ReportUnitResult result, RequestContext context) {
        JasperPrint jasperPrint = result.getJasperPrint();
        Integer pageIndex = context.getFlowScope().getInteger(this.flowAttributeInitialPageIndex);
        if (pageIndex == null) {
            String anchor = context.getFlowScope().getString(this.flowAttributeInitialAnchor);
            if (anchor != null) {
                Map anchorIndexes = jasperPrint.getAnchorIndexes();
                JRPrintAnchorIndex anchorIndex = (JRPrintAnchorIndex)anchorIndexes.get(anchor);
                if (anchorIndex != null) {
                    pageIndex = anchorIndex.getPageIndex();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resolved anchor " + anchor + " to page " + pageIndex));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Anchor " + anchor + " not found in report"));
                }
            }
        } else if (pageIndex < 1 || pageIndex > jasperPrint.getPages().size()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Page index " + pageIndex + " out of range for report with " + jasperPrint.getPages().size() + " pages"));
            }
            pageIndex = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using initial page index " + pageIndex));
            }
            pageIndex = pageIndex - 1;
        }
        return pageIndex;
    }

    protected void saveInputsState(RequestContext context) {
        if (this.hasInputs(context)) {
            InputsState state = this.createInputsState(context);
            context.getFlowScope().put(this.getAttributeSavedInputsState(), (Object)state);
        }
    }

    protected InputsState createInputsState(RequestContext context) {
        return new InputsState(this.collectInputValues(context));
    }

    protected Map collectInputValues(RequestContext context) {
        HashMap values = new HashMap();
        List wrappers = this.getInputControlWrappers(context);
        for (RuntimeInputControlWrapper wrapper : wrappers) {
            ArrayList<Object> wrapperInfo = new ArrayList<Object>();
            wrapperInfo.add(wrapper.getValue());
            wrapperInfo.add(wrapper.getQueryResults());
            values.put(wrapper.getInputControl().getName(), wrapperInfo);
        }
        return values;
    }

    public Event revertToSavedInputs(RequestContext context) {
        this.revertInputsState(context);
        return this.success();
    }

    protected void revertInputsState(RequestContext context) {
        InputsState state;
        if (this.hasInputs(context) && (state = this.retrieveSavedInputsState(context)) != null) {
            this.applyInputsState(context, state);
        }
    }

    public Event toggleTopControls(RequestContext context) {
        Boolean controlsHidden = context.getFlowScope().getBoolean(this.getAttributeControlsHidden(), Boolean.FALSE);
        if (!controlsHidden.booleanValue()) {
            this.revertInputsState(context);
        }
        context.getFlowScope().put(this.getAttributeControlsHidden(), (Object)(controlsHidden == false ? 1 : 0));
        return this.success();
    }

    protected InputsState retrieveSavedInputsState(RequestContext context) {
        return (InputsState)context.getFlowScope().get(this.getAttributeSavedInputsState(), InputsState.class);
    }

    protected void applyInputsState(RequestContext context, InputsState state) {
        Map values = state.getValues();
        List wrappers = this.getInputControlWrappers(context);
        for (RuntimeInputControlWrapper wrapper : wrappers) {
            String name = wrapper.getInputControl().getName();
            if (!values.containsKey(name)) continue;
            wrapper.setErrorMessage(null);
            wrapper.setValue(((List)values.get(name)).get(0));
            wrapper.setQueryResults((Map)((List)values.get(name)).get(1));
        }
    }

    protected void createAuditEvent() {
        this.getAuditContext().doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ViewReportAction.this.getAuditContext().createAuditEvent("runReport");
            }
        });
    }

    protected void addParamsAndCloseAuditEvent(final long startTime) {
        this.getAuditContext().doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ViewReportAction.this.getAuditContext().addPropertyToAuditEvent("reportExecutionStartTime", (Object)new Date(startTime), auditEvent);
                ViewReportAction.this.getAuditContext().addPropertyToAuditEvent("reportExecutionTime", (Object)(System.currentTimeMillis() - startTime), auditEvent);
                ViewReportAction.this.getAuditContext().closeAuditEvent(auditEvent);
            }
        });
    }

    protected ReportUnitResult executeReport(RequestContext context) {
        long currentTime = System.currentTimeMillis();
        this.createAuditEvent();
        Map parameterValues = this.getParameterValues(context);
        this.addReportExecutionParameters(context, parameterValues);
        String reportUnitUri = this.getReportURI(context);
        ReportUnitRequest request = new ReportUnitRequest(reportUnitUri, parameterValues);
        ReportUnitResult result = this.executeReport(context, request);
        this.addParamsAndCloseAuditEvent(currentTime);
        return result;
    }

    protected ReportUnitResult executeReport(RequestContext context, ReportUnitRequest request) {
        try {
            return (ReportUnitResult)this.getEngine().execute(ViewReportAction.getExecutionContext(context), (Request)request);
        }
        catch (JRFillInterruptedException e) {
            throw new ReportCanceledException(e);
        }
    }

    protected void setJasperPrint(RequestContext context, ReportUnitResult result) {
        ServletExternalContext externalContext = (ServletExternalContext)context.getExternalContext();
        String name = this.getJasperPrintAccessor().putObject((HttpServletRequest)externalContext.getNativeRequest(), result);
        this.setJasperPrintId(context, name);
    }

    protected void removeCurrentJasperPrint(RequestContext context) {
        String jasperPrintName = this.getJasperPrintId(context);
        if (jasperPrintName != null) {
            ServletExternalContext externalContext = (ServletExternalContext)context.getExternalContext();
            ReportUnitResult result = (ReportUnitResult)this.getJasperPrintAccessor().getObject((HttpServletRequest)externalContext.getNativeRequest(), jasperPrintName);
            if (result != null && this.virtualizerFactory != null) {
                this.virtualizerFactory.disposeVirtualizer(result.getVirtualizer());
            }
            this.getJasperPrintAccessor().removeObject((HttpServletRequest)externalContext.getNativeRequest(), jasperPrintName);
        }
    }

    protected String getJasperPrintId(RequestContext context) {
        return context.getFlowScope().getString(this.getFlowAttributeJasperPrintName());
    }

    protected void setJasperPrintId(RequestContext context, String jasperPrintId) {
        context.getFlowScope().put(this.getFlowAttributeJasperPrintName(), (Object)jasperPrintId);
    }

    public Event navigate(RequestContext context) {
        Integer pageIndex = (Integer)context.getRequestParameters().getNumber(this.getRequestParameterPageIndex(), Integer.class);
        if (pageIndex == null) {
            context.getFlowScope().remove(this.getFlowAttributePageIndex());
        } else {
            context.getFlowScope().put(this.getFlowAttributePageIndex(), (Object)pageIndex);
        }
        return this.success();
    }

    public Event prepareReportView(RequestContext context) {
        if (this.getHyperlinkProducerFactory() != null) {
            context.getRequestScope().put(this.getRequestAttributeHtmlLinkHandlerFactory(), (Object)this.getHyperlinkProducerFactory());
        }
        context.getRequestScope().put("configuredExporters", (Object)this.getConfiguredExporters());
        WebflowReportContext.getInstance(context);
        return this.success();
    }

    public Event cleanSession(RequestContext context) {
        this.removeCurrentJasperPrint(context);
        return this.success();
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public Event resetInputsToDefaults(RequestContext context) {
        this.resetValuesToDefaults(context);
        return this.success();
    }

    public String getFlowAttributeInhibitRequestParsing() {
        return this.flowAttributeInhibitRequestParsing;
    }

    public void setFlowAttributeInhibitRequestParsing(String flowAttributeInhibitRequestParsing) {
        this.flowAttributeInhibitRequestParsing = flowAttributeInhibitRequestParsing;
    }

    public String getFlowAttributePageIndex() {
        return this.flowAttributePageIndex;
    }

    public void setFlowAttributePageIndex(String flowAttributePageIndex) {
        this.flowAttributePageIndex = flowAttributePageIndex;
    }

    public String getRequestParameterPageIndex() {
        return this.requestParameterPageIndex;
    }

    public void setRequestParameterPageIndex(String requestParameterPageIndex) {
        this.requestParameterPageIndex = requestParameterPageIndex;
    }

    public String getRequestAttributeHtmlLinkHandlerFactory() {
        return this.requestAttributeHtmlLinkHandlerFactory;
    }

    public void setRequestAttributeHtmlLinkHandlerFactory(String requestAttributeHtmlLinkHandlerFactory) {
        this.requestAttributeHtmlLinkHandlerFactory = requestAttributeHtmlLinkHandlerFactory;
    }

    public String getFlowAttributeDepth() {
        return this.flowAttributeDepth;
    }

    public void setFlowAttributeDepth(String flowAttributeDepth) {
        this.flowAttributeDepth = flowAttributeDepth;
    }

    public String getFlowAttributeJasperPrintName() {
        return this.flowAttributeJasperPrintName;
    }

    public void setFlowAttributeJasperPrintName(String flowAttributeJasperPrintName) {
        this.flowAttributeJasperPrintName = flowAttributeJasperPrintName;
    }

    public HyperlinkProducerFactoryFlowFactory getHyperlinkProducerFactory() {
        return this.hyperlinkProducerFactory;
    }

    public void setHyperlinkProducerFactory(HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory) {
        this.hyperlinkProducerFactory = hyperlinkProducerFactory;
    }

    public String getFlowAttributeIsSubflow() {
        return this.flowAttributeIsSubflow;
    }

    public void setFlowAttributeIsSubflow(String requestAttributeIsSubflow) {
        this.flowAttributeIsSubflow = requestAttributeIsSubflow;
    }

    public String getFlowAttributeReportOutput() {
        return this.flowAttributeReportOutput;
    }

    public void setFlowAttributeReportOutput(String flowAttributeReportOutput) {
        this.flowAttributeReportOutput = flowAttributeReportOutput;
    }

    public String getRequestParameterReportOutput() {
        return this.requestParameterReportOutput;
    }

    public void setRequestParameterReportOutput(String requestParameterReportOutput) {
        this.requestParameterReportOutput = requestParameterReportOutput;
    }

    public String getFlowAttributeUseClientTimezone() {
        return this.flowAttributeUseClientTimezone;
    }

    public void setFlowAttributeUseClientTimezone(String flowAttributeUseClientTimezone) {
        this.flowAttributeUseClientTimezone = flowAttributeUseClientTimezone;
    }

    public SessionObjectSerieAccessor getJasperPrintAccessor() {
        return this.jasperPrintAccessor;
    }

    public void setJasperPrintAccessor(SessionObjectSerieAccessor jasperPrintAccessor) {
        this.jasperPrintAccessor = jasperPrintAccessor;
    }

    public VirtualizerFactory getVirtualizerFactory() {
        return this.virtualizerFactory;
    }

    public void setVirtualizerFactory(VirtualizerFactory virtualizerFactory) {
        this.virtualizerFactory = virtualizerFactory;
    }

    public Map getConfiguredExporters() {
        return this.configuredExporters;
    }

    public void setConfiguredExporters(Map configuredExporters) {
        this.configuredExporters = configuredExporters;
    }

    public String getAttributeReportControlsLayout() {
        return this.attributeReportControlsLayout;
    }

    public void setAttributeReportControlsLayout(String attributeReportControlsLayout) {
        this.attributeReportControlsLayout = attributeReportControlsLayout;
    }

    public String getAttributeReportForceControls() {
        return this.attributeReportForceControls;
    }

    public void setAttributeReportForceControls(String attributeReportForceControls) {
        this.attributeReportForceControls = attributeReportForceControls;
    }

    public String getAttributeSavedInputsState() {
        return this.attributeSavedInputsState;
    }

    public void setAttributeSavedInputsState(String attributeLastInputsState) {
        this.attributeSavedInputsState = attributeLastInputsState;
    }

    public String getAttributeControlsHidden() {
        return this.attributeControlsHidden;
    }

    public void setAttributeControlsHidden(String attributeControlsHidden) {
        this.attributeControlsHidden = attributeControlsHidden;
    }

    public String getAttributeReportLocale() {
        return this.attributeReportLocale;
    }

    public void setAttributeReportLocale(String attributeReportLocale) {
        this.attributeReportLocale = attributeReportLocale;
    }

    public String getAttributeNeedsInput() {
        return this.attributeNeedsInput;
    }

    public void setAttributeNeedsInput(String attributeNeedsInput) {
        this.attributeNeedsInput = attributeNeedsInput;
    }

    public String getAttributeDashboardParametersHasError() {
        return this.attributeDashboardParametersHasError;
    }

    public void setAttributeDashboardParametersHasError(String attributeDashboardParametersHasError) {
        this.attributeDashboardParametersHasError = attributeDashboardParametersHasError;
    }

    public String getParameterReportLocale() {
        return this.parameterReportLocale;
    }

    public void setParameterReportLocale(String parameterReportLocale) {
        this.parameterReportLocale = parameterReportLocale;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public String getRequestParameterAnchor() {
        return this.requestParameterAnchor;
    }

    public void setRequestParameterAnchor(String requestParameterAnchor) {
        this.requestParameterAnchor = requestParameterAnchor;
    }

    public String getFlowAttributeInitialPageIndex() {
        return this.flowAttributeInitialPageIndex;
    }

    public void setFlowAttributeInitialPageIndex(String flowAttributeInitialPageIndex) {
        this.flowAttributeInitialPageIndex = flowAttributeInitialPageIndex;
    }

    public String getFlowAttributeInitialAnchor() {
        return this.flowAttributeInitialAnchor;
    }

    public void setFlowAttributeInitialAnchor(String flowAttributeInitialAnchor) {
        this.flowAttributeInitialAnchor = flowAttributeInitialAnchor;
    }

    protected static class InputsState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map values;

        public InputsState(Map values) {
            this.values = values;
        }

        public Map getValues() {
            return this.values;
        }
    }
}

