/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlsInformation;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceKey;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.war.action.ReportInputControlsAction;
import com.jaspersoft.jasperserver.war.action.ReportParametersUtils;
import com.jaspersoft.jasperserver.war.common.InputControlLabelResolver;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.common.ResourceBundleHelper;
import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReportParametersAction
extends FormAction
implements ReportInputControlsAction {
    private static final Log log = LogFactory.getLog(ReportParametersAction.class);
    protected static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    public static final String INPUTWRAPPERS_ATTR = "wrappers";
    public static final String NULL_SUBSTITUTE = "~NULL~";
    public static final String NULL_SUBSTITUTE_LABEL = "[Null]";
    public static final String NOTHING_SUBSTITUTE = "~NOTHING~";
    public static final String NOTHING_SUBSTITUTE_LABEL = "---";
    public static final String WRAPPERS_FLOW_SCOPE_UUID = "wrappersUUID";
    public static final String VIEW_AS_DASHBOARD_FRAME = "viewAsDashboardFrame";
    public static final String IS_DASHBOARD = "isDashboard";
    private static final String COLUMN_VALUE_SEPARATOR = " | ";
    private static final int COLUMN_VALUE_SEPARATOR_LENGTH = " | ".length();
    private String reportUnitAttrName;
    private String reportUnitObjectAttrName;
    private String messageSourceObjectAttrName;
    private String controlsDisplayFormAttrName;
    private String controlsDisplayViewAttrName;
    private String reportDisplayFormAttrName;
    private String calendarDatePatternAttrName;
    private String calendarDatetimePatternAttrName;
    private EngineService engine;
    private RepositoryService repository;
    private MessageSource messages;
    private String hasInputControlsAttrName;
    private String staticDatePattern;
    private CalendarFormatProvider calendarFormatProvider;
    private String inputNamePrefix;
    private String attributeInputControlsInformation;

    protected void createWrappers(RequestContext context) {
        ReportUnit reportUnit = this.loadReportUnit(context);
        MutableAttributeMap flowScope = context.getFlowScope();
        if (reportUnit == null) {
            throw new JSException("jsexception.view.report.could.not.load");
        }
        flowScope.put(this.getReportUnitObjectAttrName(), (Object)reportUnit);
        this.setReportUnitAttributes(context, reportUnit);
        flowScope.put(this.getCalendarDatePatternAttrName(), (Object)this.getCalendarDatePattern());
        flowScope.put(this.getCalendarDatetimePatternAttrName(), (Object)this.getCalendarDatetimePattern());
        ExecutionContext exContext = ReportParametersAction.getExecutionContext(context);
        Map reportParameters = this.engine.getReportInputControlDefaultValues(exContext, this.getReportURI(context), null);
        List wrappers = this.createWrappers(context, reportUnit, reportParameters);
        flowScope.put(INPUTWRAPPERS_ATTR, (Object)wrappers);
        this.putWrappersToSession(context, wrappers);
        MessageSource messageSource = this.loadMessageSource(exContext, reportUnit);
        if (messageSource != null) {
            context.getExternalContext().getSessionMap().put(this.getMessageSourceObjectAttrName(), (Object)messageSource);
        } else {
            context.getExternalContext().getSessionMap().remove(this.getMessageSourceObjectAttrName());
        }
        flowScope.put(this.getHasInputControlsAttrName(), (Object)this.hasUserInputControls(wrappers));
    }

    protected boolean hasUserInputControls(List wrappers) {
        boolean hasVisibleControls = false;
        for (RuntimeInputControlWrapper control : wrappers) {
            if (!control.getInputControl().isVisible()) continue;
            hasVisibleControls = true;
            break;
        }
        return hasVisibleControls;
    }

    protected boolean hasUserInputControls(RequestContext context) {
        List wrappers = this.getInputControlWrappers(context);
        return this.hasUserInputControls(wrappers);
    }

    protected void putWrappersToSession(RequestContext context, List wrappers) {
        Object wrappersFlowScopeUUID;
        HashMap<Object, List> wrappersMap = (HashMap<Object, List>)context.getExternalContext().getSessionMap().get(INPUTWRAPPERS_ATTR);
        if (wrappersMap == null) {
            wrappersMap = new HashMap<Object, List>();
            context.getExternalContext().getSessionMap().put(INPUTWRAPPERS_ATTR, wrappersMap);
        }
        if ((wrappersFlowScopeUUID = context.getFlowScope().get(WRAPPERS_FLOW_SCOPE_UUID)) == null) {
            wrappersFlowScopeUUID = String.valueOf(System.currentTimeMillis());
        }
        context.getFlowScope().put(WRAPPERS_FLOW_SCOPE_UUID, wrappersFlowScopeUUID);
        wrappersMap.put(wrappersFlowScopeUUID, wrappers);
    }

    protected void setReportUnitAttributes(RequestContext context, ReportUnit reportUnit) {
        MutableAttributeMap flowScope = context.getFlowScope();
        String controlsView = reportUnit.getInputControlRenderingView();
        if (controlsView != null && controlsView.endsWith(".jsp")) {
            String controlsFlowView = controlsView.substring(0, controlsView.length() - ".jsp".length());
            flowScope.put(this.getControlsDisplayViewAttrName(), (Object)controlsFlowView);
        }
        flowScope.put(this.getControlsDisplayFormAttrName(), (Object)controlsView);
        flowScope.put(this.getReportDisplayFormAttrName(), (Object)reportUnit.getReportRenderingView());
    }

    @Override
    public String getReportURI(RequestContext context) {
        String reportURI = context.getFlowScope().getString(this.getReportUnitAttrName());
        return reportURI;
    }

    protected ReportUnit loadReportUnit(RequestContext context) {
        String reportUnitUri = (String)context.getFlowScope().get(this.getReportUnitAttrName());
        if (reportUnitUri == null && (reportUnitUri = context.getRequestParameters().get(this.getReportUnitAttrName())) != null) {
            context.getFlowScope().put(this.getReportUnitAttrName(), (Object)reportUnitUri);
        }
        ReportUnit reportUnit = reportUnitUri == null || reportUnitUri.trim().length() == 0 ? null : (ReportUnit)this.repository.getResource(ReportParametersAction.getExecutionContext(context), reportUnitUri);
        return reportUnit;
    }

    protected static ExecutionContext getExecutionContext(RequestContext reqContext) {
        return ReportParametersAction.getExecutionContext(JasperServerUtil.getExecutionContext(reqContext), reqContext);
    }

    protected static ExecutionContext getExecutionContext(ExecutionContext exContext, RequestContext reqContext) {
        String dashFrameParam = reqContext.getRequestParameters().get(VIEW_AS_DASHBOARD_FRAME);
        Boolean dashFlowParam = (Boolean)reqContext.getFlowScope().get(IS_DASHBOARD);
        if (Boolean.valueOf(dashFrameParam).booleanValue() || dashFlowParam != null && dashFlowParam.booleanValue()) {
            exContext = EngineServiceImpl.getRuntimeExecutionContext((ExecutionContext)exContext);
        }
        return exContext;
    }

    protected boolean needsInput(RequestContext context, List wrappers) {
        return !wrappers.isEmpty();
    }

    @Override
    public Map getReportParameters(RequestContext context) {
        return this.getParameterValues(context);
    }

    protected Map getRequestParameterValues(RequestContext context) {
        boolean valid;
        List wrappers = this.getInputControlWrappers(context);
        if (!wrappers.isEmpty() && !(valid = this.parseRequest(context, wrappers, true))) {
            return null;
        }
        return this.getParameterValues(context);
    }

    protected Map getParameterValues(RequestContext context) {
        List wrappers = this.getInputControlWrappers(context);
        String reportUnitUri = this.getReportURI(context);
        Map parameterValues = this.bindParameterValues(reportUnitUri, wrappers);
        this.addCustomParameters(context, parameterValues);
        return parameterValues;
    }

    @Override
    public List getInputControlWrappers(RequestContext context) {
        String wrappersFlowScopeUUID = (String)context.getFlowScope().get(WRAPPERS_FLOW_SCOPE_UUID);
        return (List)((Map)context.getExternalContext().getSessionMap().asMap().get(INPUTWRAPPERS_ATTR)).get(wrappersFlowScopeUUID);
    }

    protected boolean hasInputs(RequestContext context) {
        List wrappers = this.getInputControlWrappers(context);
        return wrappers != null && !wrappers.isEmpty();
    }

    @Override
    public void setParameterValues(RequestContext context, Map values) {
        List inputControls = this.getInputControlWrappers(context);
        MapValueProvider valueProvider = new MapValueProvider(values, this.defaultValuesProvider(context));
        this.setInputParameterValues(inputControls, valueProvider);
    }

    @Override
    public void resetValuesToDefaults(RequestContext context) {
        this.createWrappers(context);
    }

    public static int getDSTSavings(TimeZone tz) {
        if (tz.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    protected void addCustomParameters(RequestContext context, Map parameterValues) {
    }

    protected InputValueProvider initialValueProvider(RequestContext context) {
        return this.defaultValuesProvider(context);
    }

    protected InputValueProvider defaultValuesProvider(RequestContext context) {
        ReportInputControlsInformation controlsInfo = this.getControlsInformation(context);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        for (String name : controlsInfo.getControlNames()) {
            ReportInputControlInformation info = controlsInfo.getInputControlInformation(name);
            if (info == null) continue;
            defaults.put(name, info.getDefaultValue());
        }
        return new MapValueProvider(defaults);
    }

    protected ReportInputControlsInformation getControlsInformation(RequestContext context) {
        return (ReportInputControlsInformation)context.getFlowScope().getRequired(this.getAttributeInputControlsInformation(), ReportInputControlsInformation.class);
    }

    protected void setInputParameterValues(List wrappers, InputValueProvider valueProvider) {
        for (RuntimeInputControlWrapper inputControl : wrappers) {
            String inputName = inputControl.getInputControl().getName();
            Object paramValue = valueProvider.getValue(inputName);
            ReportParametersUtils.setInputControlParameterValue(inputControl, paramValue, this.repository);
        }
    }

    protected ReportInputControlsInformation loadInputControlsInformation(ExecutionContext exContext, RequestContext context, ReportUnit report) {
        String reportURI = report.getURIString();
        HashMap params = new HashMap();
        this.addCustomParameters(context, params);
        return this.getEngine().getReportInputControlsInformation(exContext, reportURI, params);
    }

    protected List createWrappers(RequestContext context, ReportUnit reportUnit, Map reportParameters) {
        ExecutionContext exContext = ReportParametersAction.getExecutionContext(JasperServerUtil.getExecutionContext(context), context);
        return this.createWrappers(exContext, context, reportUnit, reportParameters);
    }

    protected List<RuntimeInputControlWrapper> createWrappers(ExecutionContext exContext, RequestContext context, ReportUnit reportUnit, Map<String, Object> reportParameters) {
        List inputControls;
        Map<String, Object> wrapperValueFromRequest;
        HashMap<String, Object> clonedParams = reportParameters != null ? new HashMap<String, Object>(reportParameters) : new HashMap();
        for (Map.Entry entry : clonedParams.entrySet()) {
            if (!(entry.getValue() instanceof Collection)) continue;
            clonedParams.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        ReportInputControlsInformation controlsInfo = null;
        if (context != null) {
            controlsInfo = this.loadInputControlsInformation(exContext, context, reportUnit);
            context.getFlowScope().put(this.getAttributeInputControlsInformation(), (Object)controlsInfo);
        }
        boolean hasRequestValues = !(wrapperValueFromRequest = this.getWrapperValueFromRequest(exContext, inputControls = reportUnit.getInputControls(), context)).isEmpty();
        ArrayList<RuntimeInputControlWrapper> wrappers = new ArrayList<RuntimeInputControlWrapper>();
        for (ResourceReference controlReference : inputControls) {
            ListOfValuesItem[] items;
            ResourceReference rr;
            ListOfValues lov;
            Object defaultValue;
            Object paramValue;
            InputControl control = this.getInputControl(exContext, controlReference);
            Format format = this.getWrapperFormat(exContext, control);
            ResourceReference listOfValuesRef = control.getListOfValues();
            if (listOfValuesRef != null && !listOfValuesRef.isLocal()) {
                ListOfValues listOfValues = (ListOfValues)this.repository.getResource((ExecutionContext)new ExecutionContextImpl(), listOfValuesRef.getReferenceURI());
                control.setListOfValues(listOfValues);
            }
            RuntimeInputControlWrapper wrapper = new RuntimeInputControlWrapper(control);
            String uriString = control.getURIString();
            wrapper.setResourceUriPrefix(uriString);
            wrapper.setFormat(format);
            HashMap<Object, Object> executionParams = new HashMap();
            InputValueProvider valueProvider = null;
            if (controlsInfo != null) {
                valueProvider = this.initialValueProvider(context);
                for (String paramName : clonedParams.keySet()) {
                    executionParams.put(paramName, valueProvider.getValue(paramName));
                }
                for (String paramName : wrapperValueFromRequest.keySet()) {
                    executionParams.put(paramName, wrapperValueFromRequest.get(paramName));
                }
            } else {
                executionParams = clonedParams;
            }
            if (control.getQuery() != null) {
                OrderedMap results = this.executeQuery(control.getQuery(), reportUnit.getDataSource(), wrapper, executionParams);
                wrapper.setQueryResults((Map)results);
            }
            String paramName = wrapper.getInputControl().getName();
            if (controlsInfo != null) {
                ReportInputControlInformation rici = controlsInfo.getInputControlInformation(paramName);
                wrapper.setControlInfo(rici);
                paramValue = wrapperValueFromRequest.containsKey(paramName) ? wrapperValueFromRequest.get(paramName) : valueProvider.getValue(paramName);
                if (paramValue == null) {
                    Object newDefaultValue;
                    if (wrapper.getQueryResults() != null && !wrapper.getQueryResults().isEmpty() && wrapper.getInputControl().isMandatory() && (newDefaultValue = this.createDefaultValueAsFirstListResult(wrapper)) != null) {
                        ReportParametersUtils.setInputControlParameterValue(wrapper, newDefaultValue, this.getRepository());
                    }
                } else if ((paramValue = this.processParamValue(paramValue, wrapper)) != null) {
                    ReportParametersUtils.setInputControlParameterValue(wrapper, paramValue, this.getRepository());
                }
                if (wrapper.getValue() != null && hasRequestValues) {
                    wrapperValueFromRequest.put(paramName, wrapper.getValue());
                }
            } else if (wrapper.getQueryResults() != null && !wrapper.getQueryResults().isEmpty()) {
                Object newDefaultValue;
                defaultValue = clonedParams.get(paramName);
                if (defaultValue != null) {
                    paramValue = this.processParamValue(defaultValue, wrapper);
                    if (paramValue != null) {
                        ReportParametersUtils.setInputControlParameterValue(wrapper, paramValue, this.getRepository());
                    }
                } else if (wrapper.getInputControl().isMandatory() && (newDefaultValue = this.createDefaultValueAsFirstListResult(wrapper)) != null) {
                    ReportParametersUtils.setInputControlParameterValue(wrapper, newDefaultValue, this.getRepository());
                }
            } else {
                defaultValue = clonedParams.get(paramName);
                if (defaultValue != null && (paramValue = this.processParamValue(defaultValue, wrapper)) != null) {
                    ReportParametersUtils.setInputControlParameterValue(wrapper, paramValue, this.getRepository());
                }
            }
            clonedParams.put(paramName, wrapper.getValue());
            String displayLabel = InputControlLabelResolver.resolve(wrapper.getInputControl().getLabel(), this.loadMessageSource(exContext, reportUnit), this.messages);
            wrapper.setDisplayLabel(displayLabel);
            if (wrapper.isListOfValues() && (lov = (rr = wrapper.getInputControl().getListOfValues()).isLocal() ? (ListOfValues)rr.getLocalResource() : (ListOfValues)this.repository.getResource(JasperServerUtil.getExecutionContext(LocaleContextHolder.getLocale()), rr.getReferenceURI())) != null && (items = lov.getValues()) != null) {
                for (ListOfValuesItem item : items) {
                    wrapper.getListOfValuesDisplayLabels().put(item.getLabel(), InputControlLabelResolver.resolve(item.getLabel(), this.loadMessageSource(exContext, reportUnit), this.messages));
                }
            }
            wrappers.add(wrapper);
        }
        return wrappers;
    }

    protected Object createDefaultValueAsFirstListResult(RuntimeInputControlWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        Object newDefaultValue = null;
        if (wrapper.isMulti()) {
            if (wrapper.isQuery()) {
                if (wrapper.getQueryResults() != null && !wrapper.getQueryResults().isEmpty()) {
                    newDefaultValue = new ArrayList();
                    ((List)newDefaultValue).add(wrapper.getQueryResults().keySet().toArray()[0]);
                }
            } else if (wrapper.isListOfValues()) {
                // empty if block
            }
        } else if (wrapper.isQuery()) {
            if (wrapper.getQueryResults() != null && !wrapper.getQueryResults().isEmpty()) {
                newDefaultValue = wrapper.getQueryResults().keySet().toArray()[0];
            }
        } else if (wrapper.isListOfValues()) {
            // empty if block
        }
        return newDefaultValue;
    }

    protected Object processParamValue(Object paramValue, RuntimeInputControlWrapper wrapper) {
        if (paramValue == null || wrapper == null) {
            return null;
        }
        if (wrapper.isMulti()) {
            int size = ((Collection)paramValue).size();
            int notPresentedValuesSize = 0;
            for (Object value : (Collection)paramValue) {
                if (this.isValuePresentInList(wrapper, value)) continue;
                ++notPresentedValuesSize;
            }
            if (size == notPresentedValuesSize && wrapper.getInputControl().isMandatory()) {
                return this.createDefaultValueAsFirstListResult(wrapper);
            }
            if (size > 0) {
                return paramValue;
            }
        } else {
            if (this.isValuePresentInList(wrapper, paramValue)) {
                return paramValue;
            }
            if (wrapper.getInputControl().isMandatory()) {
                return this.createDefaultValueAsFirstListResult(wrapper);
            }
        }
        return null;
    }

    private boolean isValuePresentInList(RuntimeInputControlWrapper wrapper, Object value) {
        boolean present = false;
        if (wrapper.isQuery()) {
            if (wrapper.getQueryResults() != null && !wrapper.getQueryResults().isEmpty()) {
                for (Object queryResult : wrapper.getQueryResults().values()) {
                    Object[] valueArray = (Object[])queryResult;
                    if ((value != null || valueArray[0] != null) && (value == null || valueArray[0] == null || !value.toString().equals(valueArray[0].toString()))) continue;
                    present = true;
                    break;
                }
            }
        } else {
            present = wrapper.isListOfValues() ? true : true;
        }
        return present;
    }

    private InputControl getInputControl(ExecutionContext exContext, ResourceReference inputControlRef) {
        InputControl control;
        if (inputControlRef.isLocal()) {
            control = (InputControl)inputControlRef.getLocalResource();
        } else {
            exContext = ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)exContext);
            control = (InputControl)this.repository.getResource(exContext, inputControlRef.getReferenceURI());
        }
        return control;
    }

    private Format getWrapperFormat(ExecutionContext exContext, InputControl control) {
        Format format = null;
        ResourceReference dataTypeRef = control.getDataType();
        if (dataTypeRef != null) {
            DataType dataType;
            if (!dataTypeRef.isLocal()) {
                exContext = ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)exContext);
                dataType = (DataType)this.repository.getResource(exContext, dataTypeRef.getReferenceURI());
                control.setDataType(dataType);
            } else {
                dataType = (DataType)dataTypeRef.getLocalResource();
            }
            switch (dataType.getType()) {
                case 3: {
                    format = this.getDateFormat(true);
                    break;
                }
                case 4: {
                    format = this.getDatetimeFormat(true);
                    format.setTimeZone(JasperServerUtil.getTimezone(exContext));
                    break;
                }
                case 2: {
                    if (dataType.getRegularExpr() != null && dataType.getRegularExpr().length() > 0) {
                        format = new DecimalFormat(dataType.getRegularExpr());
                        break;
                    }
                    DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(LocaleContextHolder.getLocale());
                    String separator = Character.toString(df.getDecimalFormatSymbols().getDecimalSeparator());
                    if (separator.equals(".")) {
                        df.applyLocalizedPattern("###.###");
                        format = df;
                        break;
                    }
                    if (!separator.equals(",")) break;
                    df.applyLocalizedPattern("###,###");
                    format = df;
                }
            }
        }
        return format;
    }

    protected Map<String, Object> getWrapperValueFromRequest(ExecutionContext exContext, List inputControls, RequestContext context) {
        RuntimeInputControlWrapper wrapper2;
        HashMap<String, Object> controlValues = new HashMap<String, Object>();
        if (context == null || exContext == null || inputControls == null) {
            return controlValues;
        }
        ArrayList<RuntimeInputControlWrapper> wrappersList = new ArrayList<RuntimeInputControlWrapper>();
        for (Object controlObj : inputControls) {
            InputControl control = this.getInputControl(exContext, (ResourceReference)controlObj);
            wrapper2 = new RuntimeInputControlWrapper(control);
            String uriString = control.getURIString().replace("/", "\\/");
            wrapper2.setResourceUriPrefix(uriString);
            wrapper2.setFormat(this.getWrapperFormat(exContext, control));
            wrappersList.add(wrapper2);
        }
        HttpServletRequest request = JasperServerUtil.getServletRequestFromRequestContext(context);
        Map requestParametersMap = request.getParameterMap();
        Iterator i = wrappersList.iterator();
        while (i.hasNext()) {
            wrapper2 = (RuntimeInputControlWrapper)i.next();
            String parameterName = this.getParameterName(wrapper2);
            if (requestParametersMap.containsKey(parameterName)) continue;
            i.remove();
        }
        this.parseRequest(request.getParameterMap(), wrappersList, false);
        for (RuntimeInputControlWrapper wrapper2 : wrappersList) {
            controlValues.put(wrapper2.getInputControl().getName(), wrapper2.getValue());
        }
        return controlValues;
    }

    protected MessageSource loadMessageSource(ExecutionContext exContext, ReportUnit reportUnit) {
        List resources = reportUnit.getResources();
        LinkedHashMap<String, RepositoryResourceKey> map = new LinkedHashMap<String, RepositoryResourceKey>();
        LinkedHashSet<String> baseNames = new LinkedHashSet<String>();
        for (int i = 0; i < resources.size(); ++i) {
            boolean isBundle;
            ResourceReference resRef = (ResourceReference)resources.get(i);
            Resource genericResource = resRef.isLocal() ? resRef.getLocalResource() : this.repository.getResource(exContext, resRef.getReferenceURI());
            if (!(genericResource instanceof FileResource)) continue;
            FileResource resource = (FileResource)genericResource;
            String fileName = resource.getName();
            String fileType = resource.getFileType();
            boolean bl = isBundle = fileType != null ? fileType.equals("prop") : ResourceBundleHelper.isBundle(fileName);
            if (!isBundle) continue;
            map.put(fileName, new RepositoryResourceKey((Resource)resource));
            String baseName = ResourceBundleHelper.getBaseName(fileName);
            if (baseName == null || baseName.length() == 0) continue;
            baseNames.add(baseName);
        }
        if (map.isEmpty()) {
            return null;
        }
        this.setupThreadRepositoryContext(exContext);
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBundleClassLoader((ClassLoader)new RepositoryResourceClassLoader(Thread.currentThread().getContextClassLoader(), map, false));
        messageSource.setBasenames(baseNames.toArray(new String[baseNames.size()]));
        return messageSource;
    }

    protected void setupThreadRepositoryContext(ExecutionContext exContext) {
        if (RepositoryUtil.getThreadRepositoryContext() == null) {
            RepositoryContext rc = new RepositoryContext();
            rc.setRepository(this.repository);
            rc.setExecutionContext(exContext);
            RepositoryUtil.setThreadRepositoryContext((RepositoryContext)rc);
        }
    }

    protected OrderedMap executeQuery(ResourceReference queryReference, ResourceReference dataSourceReference, RuntimeInputControlWrapper wrapper, Map parameters) {
        String[] visibleColumns;
        InputControl control = wrapper.getInputControl();
        String valueColumn = control.getQueryValueColumn();
        OrderedMap results = this.engine.executeQuery(null, queryReference, valueColumn, visibleColumns = control.getQueryVisibleColumns(), dataSourceReference, parameters);
        if (results == null) {
            return null;
        }
        LinkedMap inputData = new LinkedMap();
        for (Map.Entry entry : results.entrySet()) {
            Object keyValue = entry.getKey();
            String[] columnValues = (String[])entry.getValue();
            String columnValuesString = "";
            if (columnValues != null && columnValues.length > 0) {
                StringBuffer visibleColumnBuffer = new StringBuffer();
                for (int i = 0; i < columnValues.length; ++i) {
                    visibleColumnBuffer.append(COLUMN_VALUE_SEPARATOR);
                    visibleColumnBuffer.append(columnValues[i] != null ? columnValues[i] : "");
                }
                columnValuesString = visibleColumnBuffer.substring(COLUMN_VALUE_SEPARATOR_LENGTH);
            }
            inputData.put((Object)(keyValue == null ? null : keyValue.toString()), (Object)new Object[]{keyValue, columnValuesString});
        }
        return inputData;
    }

    public Event setInputValues(RequestContext context) {
        List wrappers = this.getInputControlWrappers(context);
        boolean valid = this.parseRequest(context, wrappers, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input values valid: " + valid));
        }
        if (!valid) {
            StringBuffer sb = new StringBuffer();
            sb.append("<div id=\"wrappersErrors\" class=\"hidden\">");
            sb.append(this.getWrappersErrorsAsJSON(wrappers).toString());
            sb.append("</div>");
            context.getFlashScope().put(AJAX_RESPONSE_MODEL, (Object)sb.toString());
            return this.error();
        }
        return this.success();
    }

    protected JSONObject getWrappersErrorsAsJSON(List wrappers) {
        HashMap<String, String> wrappersErrorMessages = new HashMap<String, String>();
        for (Object icw : wrappers) {
            RuntimeInputControlWrapper wrapper = (RuntimeInputControlWrapper)icw;
            if (wrapper.getErrorMessage() == null) continue;
            wrappersErrorMessages.put(wrapper.getInputControl().getName(), wrapper.getErrorMessage());
        }
        return new JSONObject(wrappersErrorMessages);
    }

    protected boolean parseRequest(RequestContext context, List wrappers, boolean interactiveParameters) {
        HttpServletRequest request = JasperServerUtil.getServletRequestFromRequestContext(context);
        if (request != null) {
            return this.parseRequest(request.getParameterMap(), wrappers, interactiveParameters);
        }
        return false;
    }

    protected boolean parseRequest(Map requestParameters, List wrappers, boolean interactiveParameters) {
        boolean isValid = true;
        for (int i = 0; i < wrappers.size(); ++i) {
            RuntimeInputControlWrapper wrapper = (RuntimeInputControlWrapper)wrappers.get(i);
            boolean parsed = this.parseRequestInput(requestParameters, interactiveParameters, wrapper);
            boolean valueValid = parsed && this.validateValue(wrapper, interactiveParameters);
            isValid = isValid && valueValid;
        }
        return isValid;
    }

    protected boolean parseRequestInput(RequestContext context, boolean interactiveParameters, RuntimeInputControlWrapper wrapper) {
        HttpServletRequest request = JasperServerUtil.getServletRequestFromRequestContext(context);
        if (request != null) {
            return this.parseRequestInput(request.getParameterMap(), interactiveParameters, wrapper);
        }
        return false;
    }

    protected boolean parseRequestInput(Map requestParameters, boolean interactiveParameters, RuntimeInputControlWrapper wrapper) {
        wrapper.setErrorMessage(null);
        boolean parsed = wrapper.isMulti() ? this.parseRequestValues(requestParameters, wrapper, interactiveParameters) : this.parseRequestValue(requestParameters, wrapper, interactiveParameters);
        return parsed;
    }

    protected String getParameterName(RuntimeInputControlWrapper wrapper) {
        InputControl control = wrapper.getInputControl();
        String paramName = this.getInputNamePrefix() == null ? control.getName() : this.getInputNamePrefix() + control.getName();
        return paramName;
    }

    protected boolean parseRequestValue(RequestContext context, RuntimeInputControlWrapper wrapper, boolean interactiveParameters) {
        HttpServletRequest request = JasperServerUtil.getServletRequestFromRequestContext(context);
        if (request != null) {
            return this.parseRequestValue(request.getParameterMap(), wrapper, interactiveParameters);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parseRequestValue(Map requestParameters, RuntimeInputControlWrapper wrapper, boolean interactiveParameters) {
        wrapper.setErrorMessage(null);
        parameterName = this.getParameterName(wrapper);
        if (!interactiveParameters && !requestParameters.containsKey(parameterName)) {
            return true;
        }
        strValues = (String[])requestParameters.get(parameterName);
        if (strValues == null) {
            strValue = null;
        } else {
            strValue = strValues[0];
            if ("~NULL~".equals(strValue)) {
                strValue = null;
            } else if ("~NOTHING~".equals(strValue)) {
                wrapper.setValue(wrapper.getControlInfo().getDefaultValue());
                return true;
            }
        }
        control = wrapper.getInputControl();
        dataType = ReportParametersUtils.getDatatype(control, this.repository);
        if (control.getType() == 1) {
            if (interactiveParameters) {
                wrapper.setValue(strValue != null);
            } else {
                wrapper.setValue(strValue == null || strValue.equals("false") == false);
            }
            return true;
        }
        if (control.getType() == 3 || control.getType() == 8) {
            wrapper.setValue(this.getLovValue(wrapper, strValue));
            return true;
        }
        if (control.getType() == 4 || control.getType() == 9) {
            wrapper.setValue(this.getQueryValue(wrapper, strValue));
            return true;
        }
        if (dataType == null || strValue == null) {
            wrapper.setValue(null);
            return true;
        }
        switch (dataType.getType()) {
            case 1: {
                wrapper.setValue(strValue);
                break;
            }
            case 2: {
                try {
                    if (strValue == null || strValue.trim().length() == 0) {
                        wrapper.setValue(null);
                        ** break;
                    }
                    df = (DecimalFormat)NumberFormat.getNumberInstance(LocaleContextHolder.getLocale());
                    df.setGroupingUsed(false);
                    separator = Character.toString(df.getDecimalFormatSymbols().getDecimalSeparator());
                    if (separator.equals(".") && strValue.lastIndexOf(".") > 0) {
                        wrapper.setValue(df.format(new BigDecimal(strValue)));
                        ** break;
                    }
                    if (separator.equals(",") && strValue.lastIndexOf(",") > 0) {
                        wrapper.setValue(df.format(new BigDecimal(strValue.replace(",", "."))));
                        ** break;
                    }
                    if (strValue.lastIndexOf(".") < 0 && strValue.lastIndexOf(",") < 0) {
                        wrapper.setValue(new BigDecimal(strValue));
                        ** break;
                    }
                    throw new NumberFormatException();
lbl55:
                    // 4 sources

                }
                catch (NumberFormatException e) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidFloat", null, LocaleContextHolder.getLocale()));
                    wrapper.setValue(strValue);
                }
                break;
            }
            case 3: {
                format = this.getDateFormat(interactiveParameters);
                ReportParametersUtils.parseDateAndDateTime(strValue, wrapper, format, this.messages);
                break;
            }
            case 4: {
                format = this.getDatetimeFormat(interactiveParameters);
                format.setTimeZone(((DateFormat)wrapper.getFormat()).getTimeZone());
                ReportParametersUtils.parseDateAndDateTime(strValue, wrapper, format, this.messages);
                break;
            }
        }
        return wrapper.getErrorMessage() == null;
    }

    protected boolean parseRequestValues(RequestContext context, RuntimeInputControlWrapper wrapper, boolean interactiveParameters) {
        HttpServletRequest request = JasperServerUtil.getServletRequestFromRequestContext(context);
        if (request != null) {
            return this.parseRequestValues(request.getParameterMap(), wrapper, interactiveParameters);
        }
        return false;
    }

    protected boolean parseRequestValues(Map requestParameters, RuntimeInputControlWrapper wrapper, boolean interactiveParameters) {
        InputControl control = wrapper.getInputControl();
        String parameterName = this.getParameterName(wrapper);
        if (!interactiveParameters && !requestParameters.containsKey(parameterName)) {
            return true;
        }
        String[] strValues = (String[])requestParameters.get(parameterName);
        if (strValues == null) {
            strValues = new String[]{};
        }
        if (strValues.length == 1 && strValues[0] != null && strValues[0].startsWith("[") && strValues[0].endsWith("]")) {
            strValues = strValues[0].substring(1, strValues[0].length() - 1).split(",\\s");
        }
        for (int i = 0; i < strValues.length; ++i) {
            if (!NULL_SUBSTITUTE.equals(strValues[i])) continue;
            strValues[i] = null;
        }
        if (control.getType() == 6 || control.getType() == 10) {
            ListOrderedSet values = new ListOrderedSet();
            for (int i = 0; i < strValues.length; ++i) {
                values.add(this.getLovValue(wrapper, strValues[i]));
            }
            wrapper.setValue(values);
            return true;
        }
        if (control.getType() == 7 || control.getType() == 11) {
            ListOrderedSet values = new ListOrderedSet();
            for (int i = 0; i < strValues.length; ++i) {
                values.add(this.getQueryValue(wrapper, strValues[i]));
            }
            wrapper.setValue(values);
            return true;
        }
        return true;
    }

    protected boolean validateValues(List wrappers, boolean setMissingMessage) {
        boolean valid = true;
        for (RuntimeInputControlWrapper inputWrapper : wrappers) {
            valid &= this.validateValue(inputWrapper, setMissingMessage);
        }
        return valid;
    }

    protected boolean validateValue(RuntimeInputControlWrapper wrapper, boolean setMissingMessage) {
        Comparable maxValue;
        boolean empty;
        Object value = wrapper.getValue();
        if (wrapper.isMulti()) {
            empty = value == null || ((Collection)value).isEmpty();
        } else {
            boolean bl = empty = value == null;
        }
        if (empty) {
            if (wrapper.getInputControl().isMandatory()) {
                if (setMissingMessage) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.mandatoryField", null, LocaleContextHolder.getLocale()));
                }
                return false;
            }
            return true;
        }
        DataType dataType = ReportParametersUtils.getDatatype(wrapper.getInputControl(), this.repository);
        if (dataType == null) {
            return true;
        }
        if (dataType.getType() == 1) {
            String strValue = (String)value;
            if (dataType.getMaxLength() != null && dataType.getMaxLength() < strValue.length()) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidType", null, LocaleContextHolder.getLocale()));
                return false;
            }
            if (dataType.getRegularExpr() != null && dataType.getRegularExpr().trim().length() > 0 && strValue.length() > 0 && !Pattern.matches(dataType.getRegularExpr(), strValue)) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidPattern", null, LocaleContextHolder.getLocale()));
                return false;
            }
        }
        Comparable compValue = (Comparable)value;
        Comparable minValue = this.realDatatypeValue(dataType, dataType.getMinValue());
        if (minValue != null) {
            if (dataType.isStrictMin()) {
                if (minValue.compareTo(compValue) >= 0) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.smallerThan", null, LocaleContextHolder.getLocale()));
                }
            } else if (minValue.compareTo(compValue) > 0) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.smallerOrEqual", null, LocaleContextHolder.getLocale()));
            }
        }
        if ((maxValue = this.realDatatypeValue(dataType, dataType.getMaxValue())) != null) {
            if (dataType.isStrictMax()) {
                if (maxValue.compareTo(compValue) <= 0) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.greaterThan", null, LocaleContextHolder.getLocale()));
                }
            } else if (maxValue.compareTo(compValue) < 0) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.greaterOrEqual", null, LocaleContextHolder.getLocale()));
            }
        }
        return wrapper.getErrorMessage() == null;
    }

    protected Comparable realDatatypeValue(DataType dataType, Comparable value) {
        Comparable rValue = value;
        if (rValue != null) {
            if (rValue instanceof String && ((String)((Object)rValue)).length() == 0) {
                rValue = null;
            } else if (dataType.getType() == 2) {
                rValue = ReportParametersUtils.toInputControlNumber(value);
            }
        }
        return rValue;
    }

    protected Object getLovValue(RuntimeInputControlWrapper wrapper, String strValue) {
        return strValue;
    }

    protected Object getQueryValue(RuntimeInputControlWrapper wrapper, String strValue) {
        return strValue;
    }

    protected DateFormat getDateFormat(boolean interactiveParameters) {
        DateFormat format = interactiveParameters ? this.getCalendarFormatProvider().getDateFormat() : new SimpleDateFormat(this.getStaticDatePattern());
        return format;
    }

    protected DateFormat getDatetimeFormat(boolean interactiveParameters) {
        DateFormat format = interactiveParameters ? this.getCalendarFormatProvider().getDatetimeFormat() : new SimpleDateFormat(this.getStaticDatePattern());
        return format;
    }

    protected Map bindParameterValues(String reportName, List wrappers) {
        HashMap parameterValues = new HashMap();
        for (RuntimeInputControlWrapper wrapper : wrappers) {
            String parameterName = wrapper.getInputControl().getName();
            ReportInputControlInformation controlInfo = wrapper.getControlInfo();
            if (controlInfo == null) continue;
            HashSet value = wrapper.getValue();
            if (value != null) {
                Class parameterType = controlInfo.getValueType();
                if (wrapper.isMulti()) {
                    if (value instanceof List) {
                        value = new HashSet((List)((Object)value));
                    }
                    value = this.getParameterMultiValue(controlInfo, value);
                } else {
                    value = this.toParameterSingleValue(parameterType, value);
                }
            }
            parameterValues.put(parameterName, value);
        }
        return parameterValues;
    }

    protected Object toParameterSingleValue(Class parameterType, Object value) {
        if (Number.class.isAssignableFrom(parameterType)) {
            value = this.getParameterNumberValue(parameterType, value);
        } else if (java.util.Date.class.isAssignableFrom(parameterType)) {
            value = this.getParameterDateValue(parameterType, value);
        } else if (String.class.equals((Object)parameterType)) {
            value = value.toString();
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getParameterNumberValue(Class type, Object value) {
        if (value instanceof String) {
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(LocaleContextHolder.getLocale());
            df.setGroupingUsed(false);
            String separator = Character.toString(df.getDecimalFormatSymbols().getDecimalSeparator());
            if (separator.equals(".") && ((String)value).lastIndexOf(".") > 0) {
                value = new BigDecimal((String)value);
            } else if (separator.equals(",") && ((String)value).lastIndexOf(",") > 0) {
                value = new BigDecimal(((String)value).replace(",", "."));
            } else {
                if (((String)value).lastIndexOf(".") >= 0) throw new NumberFormatException();
                if (((String)value).lastIndexOf(",") >= 0) throw new NumberFormatException();
                value = new BigDecimal((String)value);
            }
        } else if (!(value instanceof Number)) {
            throw new JSException("Cannot convert input value \"" + value + "\" of type " + value.getClass().getName() + " to a numerical parameter");
        }
        String className = type.getName();
        if (Byte.class.getName().equals(className)) {
            return new Byte(((Number)value).byteValue());
        }
        if (Short.class.getName().equals(className)) {
            return new Short(((Number)value).shortValue());
        }
        if (Integer.class.getName().equals(className)) {
            return new Integer(((Number)value).intValue());
        }
        if (Long.class.getName().equals(className)) {
            return new Long(((Number)value).longValue());
        }
        if (Float.class.getName().equals(className)) {
            return new Float(((Number)value).floatValue());
        }
        if (Double.class.getName().equals(className)) {
            return new Double(((Number)value).doubleValue());
        }
        if (!BigInteger.class.getName().equals(className)) return value;
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof BigInteger) return value;
        return BigInteger.valueOf(((Number)value).longValue());
    }

    protected Object getParameterDateValue(Class type, Object value) {
        java.util.Date parameterValue;
        if (!(value instanceof java.util.Date)) {
            throw new JSException("exception.report.unsupported.date.input.value", new Object[]{value, value.getClass().getName()});
        }
        java.util.Date dateValue = (java.util.Date)value;
        String parameterClassName = type.getName();
        if (java.util.Date.class.getName().equals(parameterClassName)) {
            parameterValue = dateValue;
        } else if (Date.class.getName().equals(parameterClassName)) {
            parameterValue = new Date(dateValue.getTime());
        } else if (Timestamp.class.getName().equals(parameterClassName)) {
            parameterValue = new Timestamp(dateValue.getTime());
        } else {
            throw new JSException("exception.report.unsupported.date.parameter.type", new Object[]{parameterClassName});
        }
        return parameterValue;
    }

    protected Object getParameterMultiValue(ReportInputControlInformation controlInfo, Set values) {
        Object value;
        Class paramType = controlInfo.getValueType();
        if (paramType.equals(Object.class) || paramType.equals(Collection.class) || paramType.equals(Set.class) || paramType.equals(List.class)) {
            ArrayList paramValues = paramType.equals(List.class) ? new ArrayList(values.size()) : new ListOrderedSet();
            Class componentType = controlInfo.getNestedType();
            for (Object val : values) {
                Object paramValue = componentType == null ? val : this.toParameterSingleValue(componentType, val);
                paramValues.add(paramValue);
            }
            value = paramValues;
        } else if (paramType.isArray()) {
            Class<?> componentType = paramType.getComponentType();
            value = Array.newInstance(componentType, values.size());
            int idx = 0;
            for (Object val : values) {
                Object paramValue = this.toParameterSingleValue(componentType, val);
                Array.set(value, idx, paramValue);
                ++idx;
            }
        } else {
            throw new JSException("jsexception.unknown.parameter.type.for.multiple.value.input", new Object[]{paramType.getName()});
        }
        return value;
    }

    protected String getCalendarDatePattern() {
        return this.getCalendarFormatProvider().getCalendarDatePattern();
    }

    protected String getCalendarDatetimePattern() {
        return this.getCalendarFormatProvider().getCalendarDatetimePattern();
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public String getReportUnitAttrName() {
        return this.reportUnitAttrName;
    }

    public void setReportUnitAttrName(String reportUnitAttrName) {
        this.reportUnitAttrName = reportUnitAttrName;
    }

    public String getHasInputControlsAttrName() {
        return this.hasInputControlsAttrName;
    }

    public void setHasInputControlsAttrName(String hasInputControlsAttrName) {
        this.hasInputControlsAttrName = hasInputControlsAttrName;
    }

    public String getStaticDatePattern() {
        return this.staticDatePattern;
    }

    public void setStaticDatePattern(String staticDatePattern) {
        this.staticDatePattern = staticDatePattern;
    }

    public String getReportUnitObjectAttrName() {
        return this.reportUnitObjectAttrName;
    }

    public void setReportUnitObjectAttrName(String reportUnitObjectAttrName) {
        this.reportUnitObjectAttrName = reportUnitObjectAttrName;
    }

    public String getControlsDisplayFormAttrName() {
        return this.controlsDisplayFormAttrName;
    }

    public String getMessageSourceObjectAttrName() {
        return this.messageSourceObjectAttrName;
    }

    public void setMessageSourceObjectAttrName(String messageSourceObjectAttrName) {
        this.messageSourceObjectAttrName = messageSourceObjectAttrName;
    }

    public void setControlsDisplayFormAttrName(String controlsDisplayFormAttrName) {
        this.controlsDisplayFormAttrName = controlsDisplayFormAttrName;
    }

    public String getReportDisplayFormAttrName() {
        return this.reportDisplayFormAttrName;
    }

    public void setReportDisplayFormAttrName(String reportDisplayFormAttrName) {
        this.reportDisplayFormAttrName = reportDisplayFormAttrName;
    }

    public String getCalendarDatePatternAttrName() {
        return this.calendarDatePatternAttrName;
    }

    public void setCalendarDatePatternAttrName(String calendarDatePatternAttrName) {
        this.calendarDatePatternAttrName = calendarDatePatternAttrName;
    }

    public CalendarFormatProvider getCalendarFormatProvider() {
        return this.calendarFormatProvider;
    }

    public void setCalendarFormatProvider(CalendarFormatProvider calendarFormatProvider) {
        this.calendarFormatProvider = calendarFormatProvider;
    }

    public String getCalendarDatetimePatternAttrName() {
        return this.calendarDatetimePatternAttrName;
    }

    public void setCalendarDatetimePatternAttrName(String calendarDatetimePatternAttrName) {
        this.calendarDatetimePatternAttrName = calendarDatetimePatternAttrName;
    }

    public String getInputNamePrefix() {
        return this.inputNamePrefix;
    }

    public void setInputNamePrefix(String inputNamePrefix) {
        this.inputNamePrefix = inputNamePrefix;
    }

    public String getControlsDisplayViewAttrName() {
        return this.controlsDisplayViewAttrName;
    }

    public void setControlsDisplayViewAttrName(String controlsDisplayViewAttrName) {
        this.controlsDisplayViewAttrName = controlsDisplayViewAttrName;
    }

    public String getAttributeInputControlsInformation() {
        return this.attributeInputControlsInformation;
    }

    public void setAttributeInputControlsInformation(String attributeInputControlsInformation) {
        this.attributeInputControlsInformation = attributeInputControlsInformation;
    }

    protected static class MapValueProvider
    extends InputValueProvider {
        private final Map values;

        public MapValueProvider(Map values) {
            this.values = values;
        }

        public MapValueProvider(Map values, InputValueProvider parent) {
            super(parent);
            this.values = values;
        }

        protected boolean hasOwnValue(String inputName) {
            return this.values.containsKey(inputName);
        }

        protected Object getOwnValue(String inputName) {
            return this.values.get(inputName);
        }
    }

    protected static abstract class InputValueProvider {
        private final InputValueProvider parent;

        protected InputValueProvider() {
            this(null);
        }

        protected InputValueProvider(InputValueProvider parent) {
            this.parent = parent;
        }

        public Object getValue(String inputName) {
            Object value = this.hasOwnValue(inputName) ? this.getOwnValue(inputName) : (this.parent != null ? this.parent.getValue(inputName) : null);
            return value;
        }

        protected abstract boolean hasOwnValue(String var1);

        protected abstract Object getOwnValue(String var1);
    }
}

