/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RepoAdminAction
extends FormAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map resourceTypes;
    private RepositoryService repository;
    private String flowAttributeFolder;
    private MessageSource messages;
    private ConfigurationBean configuration;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public Map getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Map resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public Event initAction(RequestContext context) {
        String folderURI = context.getRequestParameters().get("folder");
        if (folderURI == null) {
            folderURI = context.getFlowScope().getString(this.getFlowAttributeFolder());
            if (folderURI == null) {
                folderURI = "/";
            }
        } else {
            context.getFlowScope().put(this.getFlowAttributeFolder(), (Object)folderURI);
        }
        List pathFolders = this.getPathFolders(folderURI);
        context.getRequestScope().put("pathFolders", (Object)pathFolders);
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
        List folders = this.repository.getSubFolders(JasperServerUtil.getExecutionContext(context), folderURI);
        List resources = this.repository.loadResourcesList(JasperServerUtil.getExecutionContext(context), criteria);
        ArrayList allResources = new ArrayList();
        allResources.addAll(folders);
        allResources.addAll(resources);
        context.getRequestScope().put("resources", allResources);
        context.getRequestScope().put("resourceTypes", (Object)this.getResourceTypes());
        HashMap removableResources = new HashMap();
        HashMap editableResources = new HashMap();
        this.repositoryServiceSecurityChecker.filterResources(allResources, removableResources, editableResources);
        context.getRequestScope().put("removableResources", removableResources);
        context.getRequestScope().put("editableResources", editableResources);
        return this.success();
    }

    public Event goToPage(RequestContext context) {
        context.getFlowScope().put("currentPage", (Object)context.getRequestParameters().get("currentPage"));
        return this.success();
    }

    public Event remove(RequestContext context) {
        this.log.debug((Object)"RepositoryAdminAction.remove");
        String[] selectedFolders = context.getRequestParameters().getArray("selectedFolders");
        String[] selectedResources = context.getRequestParameters().getArray("selectedResources");
        ArrayList<String> failedResources = new ArrayList<String>();
        try {
            int i;
            if (selectedResources != null && selectedResources.length > 0) {
                for (i = 0; i < selectedResources.length; ++i) {
                    try {
                        if (!this.repository.resourceExists(null, selectedResources[i])) continue;
                        this.repository.deleteResource(null, selectedResources[i]);
                        continue;
                    }
                    catch (JSExceptionWrapper ex) {
                        if (ex.getOriginalException() instanceof DataIntegrityViolationException) {
                            this.log.error((Object)("Failed to remove resource: " + selectedResources[i]), (Throwable)ex);
                            failedResources.add(selectedResources[i]);
                            continue;
                        }
                        throw ex;
                    }
                }
            }
            if (selectedFolders != null && selectedFolders.length > 0) {
                for (i = 0; i < selectedFolders.length; ++i) {
                    try {
                        this.repository.deleteFolder(null, selectedFolders[i]);
                        continue;
                    }
                    catch (JSExceptionWrapper ex) {
                        if (ex.getOriginalException() instanceof DataIntegrityViolationException) {
                            this.log.error((Object)("Failed to remove folder: " + selectedFolders[i]), (Throwable)ex);
                            failedResources.add(selectedFolders[i]);
                            continue;
                        }
                        throw ex;
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unexpected error during removing resources. ", (Throwable)e);
            return this.error(e);
        }
        if (failedResources.size() > 0) {
            this.log.debug((Object)"There are resources that cannot be removed");
            context.getRequestScope().put("failedResources", failedResources);
            return this.no();
        }
        return this.success();
    }

    protected List getPathFolders(String uri) {
        ArrayList<FolderImpl> pathFolders = new ArrayList<FolderImpl>();
        FolderImpl parentFolder = null;
        StringTokenizer tkzer = new StringTokenizer(uri, "/", false);
        while (tkzer.hasMoreTokens()) {
            String token = tkzer.nextToken();
            FolderImpl folder = new FolderImpl();
            folder.setName(token);
            folder.setParentFolder(parentFolder);
            pathFolders.add(folder);
            parentFolder = folder;
        }
        return pathFolders;
    }

    public String getFlowAttributeFolder() {
        return this.flowAttributeFolder;
    }

    public void setFlowAttributeFolder(String flowAttributeFolder) {
        this.flowAttributeFolder = flowAttributeFolder;
    }

    public RepositorySecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }
}

