/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OlapViewListAction
extends FormAction {
    private RepositoryService repository;
    private ConfigurationBean configuration;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    private boolean isReportFilteredOut(ResourceLookup report) {
        boolean isFilteredOut = false;
        for (int i = 0; i < this.configuration.getViewReportsFilterList().size(); ++i) {
            String regexp = (String)this.configuration.getViewReportsFilterList().get(i);
            Matcher matcher = Pattern.compile(regexp).matcher(report.getURIString());
            if (!matcher.find()) continue;
            isFilteredOut = true;
            break;
        }
        return isFilteredOut;
    }

    public Event olapViewList(RequestContext context) {
        List olapUnitsList = this.repository.loadResourcesList(JasperServerUtil.getExecutionContext(), FilterCriteria.createFilter(OlapUnit.class));
        ArrayList filteredOlapUnitsList = new ArrayList();
        for (int i = 0; i < olapUnitsList.size(); ++i) {
            if (this.isReportFilteredOut((ResourceLookup)olapUnitsList.get(i))) continue;
            filteredOlapUnitsList.add(olapUnitsList.get(i));
        }
        context.getRequestScope().put("olapUnits", filteredOlapUnitsList);
        return this.success();
    }

    public Event goToPage(RequestContext context) {
        context.getFlowScope().put("currentPage", (Object)context.getRequestParameters().get("currentPage"));
        return this.success();
    }

    private String getParentFolderDisplayName(String uri) {
        int fromIndex = 1;
        if (uri.equals("/")) {
            return "/root";
        }
        StringBuffer displayLabel = new StringBuffer("/root");
        if (uri.length() > 1) {
            int lastIndex = uri.lastIndexOf("/");
            while ((fromIndex = uri.indexOf(47, fromIndex)) != -1) {
                String currentUri = uri.substring(0, uri.indexOf(47, fromIndex));
                displayLabel.append("/").append(this.repository.getFolder(null, currentUri).getLabel());
                if (lastIndex == fromIndex) break;
                ++fromIndex;
            }
            displayLabel.append("/").append(this.repository.getFolder(null, uri).getLabel());
        }
        return displayLabel.toString();
    }
}

