/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.xml.JaxenXPathExecuter;
import org.apache.commons.collections.ReferenceMap;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxenNsAwareXPathExecuter
extends JaxenXPathExecuter {
    private final Map<String, XPath> cachedXPaths = new ReferenceMap();
    private Map<String, String> xmlNamespaceMap;
    private NamespaceContext context;
    boolean detectXmlNamespaces;

    public Map<String, String> getXmlNamespaceMap() {
        return this.xmlNamespaceMap;
    }

    public void setXmlNamespaceMap(Map<String, String> xmlNamespaceMap) throws JRException {
        this.xmlNamespaceMap = xmlNamespaceMap;
    }

    public boolean getDetectXmlNamespaces() {
        return this.detectXmlNamespaces;
    }

    public void setDetectXmlNamespaces(boolean detectXmlNamespaces) {
        this.detectXmlNamespaces = detectXmlNamespaces;
    }

    protected XPath getXPath(Node contextNode, String expression) throws JRException {
        XPath xPath = this.cachedXPaths.get(expression);
        if (xPath == null) {
            try {
                xPath = new DOMXPath(expression);
                this.addNamespaceContext(contextNode, xPath, expression);
            }
            catch (JaxenException e) {
                throw new JRException("XPath compilation failed. Expression: " + expression, e);
            }
            this.cachedXPaths.put(expression, xPath);
        }
        return xPath;
    }

    @Override
    public NodeList selectNodeList(Node contextNode, String expression) throws JRException {
        try {
            ArrayList<Object> nodes;
            XPath xpath = this.getXPath(contextNode, expression);
            Object object = xpath.evaluate((Object)contextNode);
            if (object instanceof List) {
                nodes = (ArrayList<Object>)object;
            } else {
                nodes = new ArrayList<Object>();
                nodes.add(object);
            }
            return new JaxenXPathExecuter.NodeListWrapper(nodes);
        }
        catch (JaxenException e) {
            throw new JRException("XPath selection failed. Expression: " + expression, e);
        }
    }

    @Override
    public Object selectObject(Node contextNode, String expression) throws JRException {
        try {
            List list;
            XPath xpath = this.getXPath(contextNode, expression);
            Object object = xpath.evaluate((Object)contextNode);
            Object value = object instanceof List ? ((list = (List)object).isEmpty() ? null : list.get(0)) : (object instanceof Number || object instanceof Boolean ? object : object.toString());
            return value;
        }
        catch (JaxenException e) {
            throw new JRException("XPath selection failed. Expression: " + expression, e);
        }
    }

    protected boolean containsPrefixes(String expression) {
        String[] tokens;
        for (String token : tokens = expression.split("::")) {
            if (token.indexOf(":") == -1) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> extractXmlNamespaces(Node contextNode) throws JRException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        String namespaceXPathString = "//namespace::node()";
        try {
            DOMXPath xpath = new DOMXPath(namespaceXPathString);
            List nlist = xpath.selectNodes((Object)contextNode);
            for (int i = 0; i < nlist.size(); ++i) {
                Node node = (Node)nlist.get(i);
                if (node.getParentNode() == null || node.getParentNode().getPrefix() == null || namespaces.containsKey(node.getParentNode().getPrefix())) continue;
                namespaces.put(node.getParentNode().getPrefix(), node.getParentNode().getNamespaceURI());
            }
        }
        catch (JaxenException e) {
            throw new JRException("XPath selection failed. Expression: " + namespaceXPathString, e);
        }
        return namespaces;
    }

    protected void addNamespaceContext(Node contextNode, XPath xPath, String expression) throws JRException {
        if (this.xmlNamespaceMap == null && this.detectXmlNamespaces && this.containsPrefixes(expression) && this.context == null) {
            this.xmlNamespaceMap = this.extractXmlNamespaces(contextNode);
        }
        if (this.xmlNamespaceMap != null && this.xmlNamespaceMap.size() > 0) {
            if (this.context == null) {
                this.context = new NamespaceContext(){

                    public String translateNamespacePrefixToUri(String prefix) {
                        return (String)JaxenNsAwareXPathExecuter.this.xmlNamespaceMap.get(prefix);
                    }
                };
            }
            xPath.setNamespaceContext(this.context);
        }
    }
}

