/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.TxtExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.Output;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class TxtReportOutput
implements Output {
    private static final Log log = LogFactory.getLog(TxtReportOutput.class);
    private TxtExportParametersBean exportParams;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportOutput getOutput(EngineService engineService, ExecutionContext executionContext, String reportUnitURI, DataContainer txtData, JRHyperlinkProducerFactory hyperlinkProducerFactory, RepositoryService repositoryService, JasperPrint jasperPrint, String baseFilename, Locale locale, String characterEncoding) throws JobExecutionException {
        try {
            JRTextExporter exporter = new JRTextExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            boolean close = false;
            OutputStream txtDataOut = txtData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)characterEncoding);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)txtDataOut);
                if (this.exportParams != null) {
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)this.exportParams.getCharacterHeight());
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)this.exportParams.getCharacterWidth());
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)this.exportParams.getPageHeight());
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)this.exportParams.getPageWidth());
                }
                exporter.exportReport();
                close = false;
                txtDataOut.close();
                String fileName = baseFilename + ".txt";
                ReportOutput reportOutput = new ReportOutput(txtData, "txt", fileName);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        txtDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public TxtExportParametersBean getExportParams() {
        return this.exportParams;
    }

    public void setExportParams(TxtExportParametersBean exportParams) {
        this.exportParams = exportParams;
    }
}

