/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core;

import org.unitils.core.UnitilsException;
import org.unitils.mock.proxy.ProxyInvocationHandler;

public class SyntaxMonitor {
    protected String mockObjectName;
    protected String definingMethodName;
    protected ProxyInvocationHandler activeProxyInvocationHandler;
    protected StackTraceElement[] invokedAt;

    public void startDefinition(String mockObjectName, String methodName, ProxyInvocationHandler proxyInvocationHandler, StackTraceElement[] invokedAt) {
        this.assertNotExpectingInvocation();
        this.activeProxyInvocationHandler = proxyInvocationHandler;
        this.mockObjectName = mockObjectName;
        this.definingMethodName = methodName;
        this.invokedAt = invokedAt;
    }

    public void endDefinition() {
        this.activeProxyInvocationHandler = null;
        this.mockObjectName = null;
        this.definingMethodName = null;
        this.invokedAt = null;
    }

    public void assertNotExpectingInvocation() {
        if (this.activeProxyInvocationHandler != null) {
            UnitilsException exception = new UnitilsException("Invalid syntax. " + this.mockObjectName + "." + this.definingMethodName + "() must be followed by a method invocation on the returned proxy. E.g. " + this.mockObjectName + "." + this.definingMethodName + "().myMethod();");
            exception.setStackTrace(this.invokedAt);
            throw exception;
        }
    }
}

