/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.inject.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import ognl.DefaultMemberAccess;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.inject.util.PropertyAccess;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionUtils {
    private static Log logger = LogFactory.getLog(InjectionUtils.class);

    public static Object injectInto(Object objectToInject, Object target, String property) {
        if (target == null) {
            throw new UnitilsException("Target for injection should not be null");
        }
        try {
            OgnlContext ognlContext = new OgnlContext();
            ognlContext.setMemberAccess((MemberAccess)new DefaultMemberAccess(true));
            Object ognlExpression = Ognl.parseExpression((String)property);
            Object oldValue = null;
            try {
                Ognl.getValue((Object)ognlExpression, (Map)ognlContext, (Object)target);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to retrieve current value of field to inject into. Will not be able to restore value after injection.", (Throwable)e);
            }
            Ognl.setValue((Object)ognlExpression, (Map)ognlContext, (Object)target, (Object)objectToInject);
            return oldValue;
        }
        catch (OgnlException e) {
            throw new UnitilsException("Failed to set value using OGNL expression " + property, e);
        }
    }

    public static Object injectIntoStatic(Object objectToInject, Class<?> targetClass, String property) {
        String staticProperty = StringUtils.substringBefore((String)property, (String)".");
        if (property.equals(staticProperty)) {
            Object oldValue = null;
            try {
                oldValue = InjectionUtils.getValueStatic(targetClass, staticProperty);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to retrieve current value of field to inject into. Will not be able to restore value after injection.", (Throwable)e);
            }
            InjectionUtils.setValueStatic(targetClass, staticProperty, objectToInject);
            return oldValue;
        }
        Object objectToInjectInto = InjectionUtils.getValueStatic(targetClass, staticProperty);
        String remainingPropertyPart = StringUtils.substringAfter((String)property, (String)".");
        try {
            return InjectionUtils.injectInto(objectToInject, objectToInjectInto, remainingPropertyPart);
        }
        catch (UnitilsException e) {
            throw new UnitilsException("Property named " + remainingPropertyPart + " not found on " + objectToInjectInto.getClass().getSimpleName(), e);
        }
    }

    public static Object injectIntoByType(Object objectToInject, Class<?> objectToInjectType, Object target, PropertyAccess propertyAccess) {
        if (target == null) {
            throw new UnitilsException("Target for injection should not be null");
        }
        if (propertyAccess == PropertyAccess.FIELD) {
            return InjectionUtils.injectIntoFieldByType(objectToInject, objectToInjectType, target, target.getClass(), false);
        }
        return InjectionUtils.injectIntoSetterByType(objectToInject, objectToInjectType, target, target.getClass(), false);
    }

    public static Object injectIntoStaticByType(Object objectToInject, Class<?> objectToInjectType, Class<?> targetClass, PropertyAccess propertyAccess) {
        if (propertyAccess == PropertyAccess.FIELD) {
            return InjectionUtils.injectIntoFieldByType(objectToInject, objectToInjectType, null, targetClass, true);
        }
        return InjectionUtils.injectIntoSetterByType(objectToInject, objectToInjectType, null, targetClass, true);
    }

    public static void injectIntoAnnotated(Object objectToInject, Object target, Class<? extends Annotation> annotation) {
        InjectionUtils.injectIntoAnnotatedFields(objectToInject, target, annotation);
        InjectionUtils.injectIntoAnnotatedMethods(objectToInject, target, annotation);
    }

    public static void injectIntoAnnotatedMethods(Object objectToInject, Object target, Class<? extends Annotation> annotation) {
        Set<Method> annotatedMethods = AnnotationUtils.getMethodsAnnotatedWith(target.getClass(), annotation);
        for (Method annotatedMethod : annotatedMethods) {
            try {
                annotatedMethod.invoke(target, objectToInject);
            }
            catch (IllegalArgumentException e) {
                throw new UnitilsException("Method " + annotatedMethod.getName() + " annotated with " + annotation.getName() + " must have exactly one argument with a type equal to or a superclass / implemented interface of " + objectToInject.getClass().getSimpleName());
            }
            catch (IllegalAccessException e) {
                throw new UnitilsException("Unable to inject value into following method annotated with " + annotation.getName() + ": " + annotatedMethod.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Unable to inject value into following method annotated with " + annotation.getName() + ": " + annotatedMethod.getName(), e);
            }
        }
    }

    public static void injectIntoAnnotatedFields(Object objectToInject, Object target, Class<? extends Annotation> annotation) {
        Set<Field> annotatedFields = AnnotationUtils.getFieldsAnnotatedWith(target.getClass(), annotation);
        for (Field annotatedField : annotatedFields) {
            ReflectionUtils.setFieldValue(target, annotatedField, objectToInject);
        }
    }

    private static Object injectIntoFieldByType(Object objectToInject, Class<?> objectToInjectType, Object target, Class<?> targetClass, boolean isStatic) {
        Field fieldToInjectTo = null;
        Set<Field> fieldsWithExactType = ReflectionUtils.getFieldsOfType(targetClass, objectToInjectType, isStatic);
        if (fieldsWithExactType.size() > 1) {
            throw new UnitilsException("More than one " + (isStatic ? "static " : "") + "field with exact type " + objectToInjectType.getSimpleName() + " found in " + targetClass.getSimpleName());
        }
        if (fieldsWithExactType.size() == 1) {
            fieldToInjectTo = fieldsWithExactType.iterator().next();
        } else {
            Set<Field> fieldsOfType = ReflectionUtils.getFieldsAssignableFrom(targetClass, objectToInjectType, isStatic);
            if (fieldsOfType.size() == 0) {
                throw new UnitilsException("No " + (isStatic ? "static " : "") + "field with (super)type " + objectToInjectType.getSimpleName() + " found in " + targetClass.getSimpleName());
            }
            for (Field field : fieldsOfType) {
                boolean moreSpecific = true;
                for (Field compareToField : fieldsOfType) {
                    if (field == compareToField || !field.getClass().isAssignableFrom(compareToField.getClass())) continue;
                    moreSpecific = false;
                    break;
                }
                if (!moreSpecific) continue;
                fieldToInjectTo = field;
                break;
            }
            if (fieldToInjectTo == null) {
                throw new UnitilsException("Multiple candidate target " + (isStatic ? "static " : "") + "fields found in " + targetClass.getSimpleName() + ", with none of them more specific than all others.");
            }
        }
        Object oldValue = null;
        try {
            oldValue = ReflectionUtils.getFieldValue(target, fieldToInjectTo);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to retrieve current value of field to inject into. Will not be able to restore value after injection.", (Throwable)e);
        }
        ReflectionUtils.setFieldValue(target, fieldToInjectTo, objectToInject);
        return oldValue;
    }

    private static Object injectIntoSetterByType(Object objectToInject, Class<?> objectToInjectType, Object target, Class<?> targetClass, boolean isStatic) {
        Method setterToInjectTo = null;
        Set<Method> settersWithExactType = ReflectionUtils.getSettersOfType(targetClass, objectToInjectType, isStatic);
        if (settersWithExactType.size() > 1) {
            throw new UnitilsException("More than one " + (isStatic ? "static " : "") + "setter with exact type " + objectToInjectType.getSimpleName() + " found in " + targetClass.getSimpleName());
        }
        if (settersWithExactType.size() == 1) {
            setterToInjectTo = settersWithExactType.iterator().next();
        } else {
            Set<Method> settersOfType = ReflectionUtils.getSettersAssignableFrom(targetClass, objectToInjectType, isStatic);
            if (settersOfType.size() == 0) {
                throw new UnitilsException("No " + (isStatic ? "static " : "") + "setter with (super)type " + objectToInjectType.getSimpleName() + " found in " + targetClass.getSimpleName());
            }
            for (Method setter : settersOfType) {
                boolean moreSpecific = true;
                for (Method compareToSetter : settersOfType) {
                    if (setter == compareToSetter || !setter.getClass().isAssignableFrom(compareToSetter.getClass())) continue;
                    moreSpecific = false;
                    break;
                }
                if (!moreSpecific) continue;
                setterToInjectTo = setter;
                break;
            }
            if (setterToInjectTo == null) {
                throw new UnitilsException("Multiple candidate target " + (isStatic ? "static " : "") + "setters found in " + targetClass.getSimpleName() + ", with none of them more specific than all others.");
            }
        }
        Object oldValue = null;
        try {
            Method getter = ReflectionUtils.getGetter(setterToInjectTo, isStatic);
            if (getter == null) {
                logger.warn((Object)("Unable to retrieve current value of field to inject into, no getter found for setter: " + setterToInjectTo + ". Will not be able to restore value after injection."));
            } else {
                oldValue = ReflectionUtils.invokeMethod(target, getter, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to retrieve current value of field to inject into. Will not be able to restore value after injection.", (Throwable)e);
        }
        try {
            ReflectionUtils.invokeMethod(target, setterToInjectTo, objectToInject);
        }
        catch (InvocationTargetException e) {
            throw new UnitilsException("Unable to inject to setter, exception thrown by target.", e);
        }
        return oldValue;
    }

    private static Object getValueStatic(Class<?> targetClass, String staticProperty) {
        Method staticGetter = ReflectionUtils.getGetter(targetClass, staticProperty, true);
        if (staticGetter != null) {
            try {
                return ReflectionUtils.invokeMethod(targetClass, staticGetter, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Exception thrown by target", e);
            }
        }
        Field staticField = ReflectionUtils.getFieldWithName(targetClass, staticProperty, true);
        if (staticField != null) {
            return ReflectionUtils.getFieldValue(targetClass, staticField);
        }
        throw new UnitilsException("Static property named " + staticProperty + " not found on class " + targetClass.getSimpleName());
    }

    private static void setValueStatic(Class<?> targetClass, String staticProperty, Object value) {
        Method staticSetter = ReflectionUtils.getSetter(targetClass, staticProperty, true);
        if (staticSetter != null) {
            try {
                ReflectionUtils.invokeMethod(targetClass, staticSetter, value);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Exception thrown by target", e);
            }
        } else {
            Field staticField = ReflectionUtils.getFieldWithName(targetClass, staticProperty, true);
            if (staticField == null) {
                throw new UnitilsException("Static property named " + staticProperty + " not found on class " + targetClass.getSimpleName());
            }
            ReflectionUtils.setFieldValue(targetClass, staticField, value);
        }
    }
}

