/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database.config;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.database.config.DataSourceFactory;
import org.unitils.util.PropertyUtils;

public class PropertiesDataSourceFactory
implements DataSourceFactory {
    private static Log logger = LogFactory.getLog(PropertiesDataSourceFactory.class);
    public static final String PROPKEY_DATASOURCE_DRIVERCLASSNAME = "database.driverClassName";
    public static final String PROPKEY_DATASOURCE_URL = "database.url";
    public static final String PROPKEY_DATASOURCE_USERNAME = "database.userName";
    public static final String PROPKEY_DATASOURCE_PASSWORD = "database.password";
    private String driverClassName;
    private String databaseUrl;
    private String userName;
    private String password;

    public void init(Properties configuration) {
        this.driverClassName = PropertyUtils.getString(PROPKEY_DATASOURCE_DRIVERCLASSNAME, configuration);
        this.databaseUrl = PropertyUtils.getString(PROPKEY_DATASOURCE_URL, configuration);
        this.userName = PropertyUtils.getString(PROPKEY_DATASOURCE_USERNAME, null, configuration);
        this.password = PropertyUtils.getString(PROPKEY_DATASOURCE_PASSWORD, null, configuration);
    }

    public DataSource createDataSource() {
        logger.info((Object)("Creating data source. Driver: " + this.driverClassName + ", url: " + this.databaseUrl + ", user: " + this.userName + ", password: <not shown>"));
        BasicDataSource dataSource = this.getNewDataSource();
        dataSource.setDriverClassName(this.driverClassName);
        dataSource.setUsername(this.userName);
        dataSource.setPassword(this.password);
        dataSource.setUrl(this.databaseUrl);
        return dataSource;
    }

    protected BasicDataSource getNewDataSource() {
        return new BasicDataSource();
    }
}

