/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.client;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class FileResourceImpl
extends ResourceImpl
implements FileResource {
    private String fileType;
    private byte[] data;
    private String referenceURI;

    public FileResourceImpl() {
    }

    public FileResourceImpl(FileResourceImpl another) {
        super(another);
        this.fileType = another.fileType;
        this.data = another.data != null ? (byte[])another.data.clone() : null;
        this.referenceURI = another.referenceURI;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void readData(InputStream is) {
        this.setData(DataContainerStreamUtil.readData(is));
    }

    public InputStream getDataStream() {
        return this.data == null ? null : new ByteArrayInputStream(this.data);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public boolean isReference() {
        return this.referenceURI != null && this.referenceURI.length() > 0;
    }

    public String getReferenceURI() {
        return this.referenceURI;
    }

    public void setReferenceURI(String referenceURI) {
        this.referenceURI = referenceURI;
    }

    public boolean hasData() {
        return !this.isReference() && this.data != null && this.data.length > 0;
    }

    protected Class getImplementingItf() {
        return FileResource.class;
    }

    public boolean isSameType(Resource resource) {
        boolean same = super.isSameType(resource);
        if (same) {
            FileResource fileRes = (FileResource)resource;
            String resType = fileRes.getFileType();
            String type = this.getFileType();
            if (type != null && resType != null && !type.equals(resType)) {
                same = false;
            }
        }
        return same;
    }
}

