/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.filter.BaseSearchFilter;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class TimeFilter
extends BaseSearchFilter {
    public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
        String timeFilter;
        SearchAttributes searchAttributes = this.getSearchAttributes(context);
        if (searchAttributes != null && searchAttributes.getState() != null && (timeFilter = searchAttributes.getState().getCustomFiltersMap().get("timeFilter")) != null && !timeFilter.equals("timeFilter-anyTime")) {
            Calendar cal = Calendar.getInstance();
            if (timeFilter.equals("timeFilter-today")) {
                cal.setTime(new Date());
                this.resetDateTime(cal);
                Date startDate = cal.getTime();
                criteria.add((Criterion)Restrictions.gt((String)"updateDate", (Object)startDate));
            } else if (timeFilter.equals("timeFilter-yesterday")) {
                cal.setTime(new Date());
                this.resetDateTime(cal);
                Date endDate = cal.getTime();
                cal.setTime(this.rollDay(new Date(), -1L));
                this.resetDateTime(cal);
                Date startDate = cal.getTime();
                criteria.add(Restrictions.between((String)"updateDate", (Object)startDate, (Object)endDate));
            } else if (timeFilter.equals("timeFilter-pastWeek")) {
                cal.setTime(new Date());
                cal.setTime(this.rollDay(new Date(), -7L));
                this.resetDateTime(cal);
                Date startDate = cal.getTime();
                criteria.add((Criterion)Restrictions.gt((String)"updateDate", (Object)startDate));
            } else if (timeFilter.equals("timeFilter-pastMonth")) {
                cal.setTime(new Date());
                cal.setTime(this.rollDay(new Date(), -30L));
                this.resetDateTime(cal);
                Date startDate = cal.getTime();
                criteria.add((Criterion)Restrictions.gt((String)"updateDate", (Object)startDate));
            }
        }
    }

    private void resetDateTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private Date rollDay(Date date, long amount) {
        long millisecondsInDay = 86400000L;
        long rolledTime = date.getTime() + amount * millisecondsInDay;
        return new Date(rolledTime);
    }
}

