/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SetAction
extends AbstractAction {
    private Expression nameExpression;
    private Expression valueExpression;
    private Class expectedType;
    private ConversionService conversionService;

    public SetAction(Expression nameExpression, Expression valueExpression, Class expectedType, ConversionService conversionService) {
        Assert.notNull((Object)nameExpression, (String)"The name expression is required");
        Assert.notNull((Object)valueExpression, (String)"The value expression is required");
        if (expectedType != null) {
            Assert.notNull((Object)conversionService, (String)"The conversion service is required if the expectedType is provided");
        }
        this.nameExpression = nameExpression;
        this.valueExpression = valueExpression;
        this.expectedType = expectedType;
        this.conversionService = conversionService;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Object value = this.valueExpression.getValue((Object)context);
        this.nameExpression.setValue((Object)context, this.applyTypeConversionIfNecessary(value));
        return this.success();
    }

    private Object applyTypeConversionIfNecessary(Object value) {
        if (value == null || this.expectedType == null) {
            return value;
        }
        return this.conversionService.getConversionExecutor(value.getClass(), this.expectedType).execute(value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.nameExpression).append("value", (Object)this.valueExpression).append("type", (Object)this.expectedType).toString();
    }
}

