/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.codehaus.plexus.logging.Logger;

public class ScopeArtifactFilter
implements ArtifactFilter,
StatisticsReportingArtifactFilter {
    private final boolean compileScope;
    private final boolean runtimeScope;
    private final boolean testScope;
    private final boolean providedScope;
    private final boolean systemScope;
    private boolean compileScopeHit = false;
    private boolean runtimeScopeHit = false;
    private boolean testScopeHit = false;
    private boolean providedScopeHit = false;
    private boolean systemScopeHit = false;
    private List filteredArtifactIds = new ArrayList();

    public ScopeArtifactFilter(String scope) {
        if ("compile".equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = false;
            this.testScope = false;
        } else if ("runtime".equals(scope)) {
            this.systemScope = false;
            this.providedScope = false;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = false;
        } else if ("test".equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = true;
        } else if ("provided".equals(scope)) {
            this.systemScope = false;
            this.providedScope = true;
            this.compileScope = false;
            this.runtimeScope = false;
            this.testScope = false;
        } else if ("system".equals(scope)) {
            this.systemScope = true;
            this.providedScope = false;
            this.compileScope = false;
            this.runtimeScope = false;
            this.testScope = false;
        } else {
            this.systemScope = false;
            this.providedScope = false;
            this.compileScope = false;
            this.runtimeScope = false;
            this.testScope = false;
        }
    }

    public boolean include(Artifact artifact) {
        boolean result = true;
        if ("compile".equals(artifact.getScope())) {
            this.compileScopeHit = true;
            result = this.compileScope;
        } else if ("runtime".equals(artifact.getScope())) {
            this.runtimeScopeHit = true;
            result = this.runtimeScope;
        } else if ("test".equals(artifact.getScope())) {
            this.testScopeHit = true;
            result = this.testScope;
        } else if ("provided".equals(artifact.getScope())) {
            this.providedScopeHit = true;
            result = this.providedScope;
        } else if ("system".equals(artifact.getScope())) {
            this.systemScopeHit = true;
            result = this.systemScope;
        }
        if (!result) {
            this.filteredArtifactIds.add(artifact.getId());
        }
        return result;
    }

    public String toString() {
        return "Scope filter [compile=" + this.compileScope + ", runtime=" + this.runtimeScope + ", test=" + this.testScope + ", provided=" + this.providedScope + ", system=" + this.systemScope + "]";
    }

    public void reportFilteredArtifacts(Logger logger) {
        if (!this.filteredArtifactIds.isEmpty() && logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer("The following artifacts were removed by this filter: ");
            Iterator it = this.filteredArtifactIds.iterator();
            while (it.hasNext()) {
                String artifactId = (String)it.next();
                buffer.append('\n').append(artifactId);
            }
            logger.debug(buffer.toString());
        }
    }

    public void reportMissedCriteria(Logger logger) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            boolean report = false;
            if (!this.compileScopeHit) {
                buffer.append("\no Compile");
                report = true;
            }
            if (!this.runtimeScopeHit) {
                buffer.append("\no Runtime");
                report = true;
            }
            if (!this.testScopeHit) {
                buffer.append("\no Test");
                report = true;
            }
            if (!this.providedScopeHit) {
                buffer.append("\no Provided");
                report = true;
            }
            if (!this.systemScopeHit) {
                buffer.append("\no System");
                report = true;
            }
            if (report) {
                logger.debug("The following scope filters were not used: " + buffer.toString());
            }
        }
    }

    public boolean hasMissedCriteria() {
        boolean report = false;
        if (!this.compileScopeHit) {
            report = true;
        }
        if (!this.runtimeScopeHit) {
            report = true;
        }
        if (!this.testScopeHit) {
            report = true;
        }
        if (!this.providedScopeHit) {
            report = true;
        }
        if (!this.systemScopeHit) {
            report = true;
        }
        return report;
    }
}

