/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.PasteStyledElementItem;
import java.util.Enumeration;
import java.util.Vector;

public class PasteStyleOperation
implements UndoOperation {
    private Vector transformations = null;
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;

    public PasteStyleOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement) {
        this.setCrosstabReportElement(crosstabReportElement);
        this.transformations = new Vector();
        this.jrf = jrf;
    }

    public PasteStyleOperation(JReportFrame jrf) {
        this(jrf, null);
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getTransformations().elements();
        while (e.hasMoreElements()) {
            PasteStyledElementItem ri = (PasteStyledElementItem)e.nextElement();
            ReportElement element = ri.getElement();
            JReportFrame.applyStyle(element, ri.getNewStyle());
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), element, 3));
        }
        this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        if (this.getCrosstabReportElement() != null) {
            this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().repaint();
        } else {
            this.jrf.getReportPanel().repaint();
        }
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getTransformations().elements();
        while (e.hasMoreElements()) {
            PasteStyledElementItem ri = (PasteStyledElementItem)e.nextElement();
            ReportElement element = ri.getElement();
            JReportFrame.applyStyle(element, ri.getOriginalStyle());
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), element, 3));
        }
        this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        if (this.getCrosstabReportElement() != null) {
            this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().repaint();
        } else {
            this.jrf.getReportPanel().repaint();
        }
    }

    public String toString() {
        return "paste style";
    }

    public Vector getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Vector transformations) {
        this.transformations = transformations;
    }

    public void addElement(ReportElement element, ReportElement originalStyle, ReportElement newStyle) {
        PasteStyledElementItem et = new PasteStyledElementItem(element, originalStyle, newStyle);
        this.getTransformations().add(et);
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return this.crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
    }
}

