/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.ElementTransformation;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class BandDraggedOperation
implements UndoOperation {
    private Vector transformations = new Vector();
    private int bandDelta = 0;
    private JReportFrame jrf = null;
    private Band band;

    public BandDraggedOperation(JReportFrame jrf, Band band) {
        this.band = band;
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        this.band.setHeight(this.band.getHeight() + this.bandDelta);
        Enumeration e = this.getTransformations().elements();
        while (e.hasMoreElements()) {
            ElementTransformation pe = (ElementTransformation)e.nextElement();
            ReportElement element = pe.element;
            element.getPosition().x = pe.newBounds.x;
            element.getPosition().y = pe.newBounds.y;
            element.setWidth(pe.newBounds.width);
            element.setHeight(pe.newBounds.height);
            element.updateBounds();
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
        }
        this.jrf.setIsDocDirty(true);
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.band.setHeight(this.band.getHeight() - this.bandDelta);
        for (int i = this.getTransformations().size() - 1; i >= 0; --i) {
            ElementTransformation pe = (ElementTransformation)this.getTransformations().get(i);
            ReportElement element = pe.element;
            element.getPosition().x = pe.oldBounds.x;
            element.getPosition().y = pe.oldBounds.y;
            element.setWidth(pe.oldBounds.width);
            element.setHeight(pe.oldBounds.height);
            element.updateBounds();
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
        }
        this.jrf.setIsDocDirty(true);
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "band resize";
    }

    public Vector getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Vector transformations) {
        this.transformations = transformations;
    }

    public void addElement(ReportElement element, Rectangle oldBounds, Rectangle newBounds) {
        ElementTransformation et = new ElementTransformation();
        et.element = element;
        et.oldBounds = oldBounds;
        et.newBounds = newBounds;
        this.getTransformations().add(et);
    }

    public Band getBand() {
        return this.band;
    }

    public void setBand(Band band) {
        this.band = band;
    }

    public int getBandDelta() {
        return this.bandDelta;
    }

    public void setBandDelta(int bandDelta) {
        this.bandDelta = bandDelta;
    }
}

