/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ObjectPermissionServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.acl.basic.BasicAclEntryCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsPrefetcher
extends HibernateDaoImpl
implements MethodInterceptor {
    private static Logger log = Logger.getLogger(PermissionsPrefetcher.class);
    private int minimumPrefetch = 10;
    private RepositoryService repositoryService;
    private ObjectPermissionServiceImpl objectPermissionService;
    private ResourceFactory objectMappingFactory;
    private ResourceFactory persistentClassFactory;

    public Object invoke(MethodInvocation call) throws Throwable {
        if (call.getMethod().getName().equals("getSubFolders")) {
            List subFolderList = (List)call.proceed();
            String folderURI = (String)call.getArguments()[1];
            this.preloadSubFolderPerms(folderURI, subFolderList);
            return subFolderList;
        }
        return call.proceed();
    }

    private void preloadSubFolderPerms(String folderURI, List<?> subFolderList) {
        if (folderURI.equals("/")) {
            return;
        }
        BasicAclEntryCache cache = this.objectPermissionService.getBasicAclEntryCache();
        HashSet<String> missingEntries = new HashSet<String>();
        for (Object subFolderObj : subFolderList) {
            Folder subFolder = (Folder)subFolderObj;
            String uri = subFolder.getURI();
            if (cache.getEntriesFromCache((AclObjectIdentity)new ObjectPermissionServiceImpl.URIObjectIdentity(uri)) != null) continue;
            missingEntries.add(uri);
        }
        if (missingEntries.size() < this.minimumPrefetch) {
            return;
        }
        List userList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("from RepoUser u left join fetch u.roles");
                return query.list();
            }
        });
        String objPermissionClassName = this.getPersistentClassFactory().getImplementationClassName(ObjectPermission.class);
        final String queryString = "from " + objPermissionClassName + " where URI like 'repo:" + folderURI + "%'" + " order by URI";
        List permList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(queryString);
                return query.list();
            }
        });
        String currentURI = null;
        ArrayList<BasicAclEntry> permsForURI = new ArrayList<BasicAclEntry>();
        for (Object permObj : permList) {
            RepoObjectPermission perm = (RepoObjectPermission)permObj;
            if (!missingEntries.contains(perm.getURI())) continue;
            if (!perm.getURI().equals(currentURI)) {
                if (permsForURI.size() > 0) {
                    BasicAclEntry[] aclArray = permsForURI.toArray(new BasicAclEntry[permsForURI.size()]);
                    cache.putEntriesInCache(aclArray);
                    permsForURI.clear();
                }
                missingEntries.remove(currentURI);
                currentURI = perm.getURI();
            }
            ObjectPermission clientPermission = (ObjectPermission)perm.toClient(this.objectMappingFactory);
            BasicAclEntry aclEntry = this.objectPermissionService.createBasicAclEntry(currentURI, clientPermission);
            permsForURI.add(aclEntry);
        }
        if (permsForURI.size() > 0) {
            BasicAclEntry[] aclArray = permsForURI.toArray(new BasicAclEntry[permsForURI.size()]);
            cache.putEntriesInCache(aclArray);
            missingEntries.remove(currentURI);
        }
        for (String uriWithNoPerms : missingEntries) {
            BasicAclEntry[] emptyAclEntries = new BasicAclEntry[]{this.objectPermissionService.createBasicAclEntry(uriWithNoPerms, null)};
            cache.putEntriesInCache(emptyAclEntries);
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setObjectPermissionService(ObjectPermissionServiceImpl objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public ObjectPermissionServiceImpl getObjectPermissionService() {
        return this.objectPermissionService;
    }

    public void setMinimumPrefetch(int minimumPrefetch) {
        this.minimumPrefetch = minimumPrefetch;
    }

    public int getMinimumPrefetch() {
        return this.minimumPrefetch;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectMappingFactory = objectFactory;
    }

    public ResourceFactory getObjectMappingFactory() {
        return this.objectMappingFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    public ResourceFactory getPersistentClassFactory() {
        return this.persistentClassFactory;
    }
}

