/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.CustomReportDataSourceImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;
import java.util.HashMap;
import java.util.Map;

public class RepoCustomDataSource
extends RepoDataSource
implements RepoReportDataSource {
    private String serviceClass;
    private Map propertyMap;

    protected Class getClientItf() {
        return CustomReportDataSource.class;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(Map propertyMap) {
        this.propertyMap = propertyMap;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        CustomReportDataSourceImpl ds = (CustomReportDataSourceImpl)clientRes;
        HashMap<String, String> aPropertyMap = new HashMap<String, String>(this.getPropertyMap());
        String password = (String)aPropertyMap.get("password");
        if (password != null && password.trim().length() > 0) {
            aPropertyMap.put("password", PasswordCipherer.getInstance().decodePassword(password));
        }
        ds.setPropertyMap(aPropertyMap);
        ds.setServiceClass(this.getServiceClass());
    }

    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        CustomReportDataSourceImpl ds = (CustomReportDataSourceImpl)clientRes;
        String password = (String)ds.getPropertyMap().get("password");
        if (password != null && password.trim().length() > 0) {
            ds.getPropertyMap().put("password", PasswordCipherer.getInstance().encodePassword(password));
        }
        this.setPropertyMap(ds.getPropertyMap());
        this.setServiceClass(ds.getServiceClass());
    }
}

