/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.BaseRepositorySecurityChecker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryServiceSecurityChecker
extends BaseRepositorySecurityChecker {
    private static final Log log = LogFactory.getLog(RepositoryServiceSecurityChecker.class);
    private RepositoryService securityChecker;

    public boolean isEditable(Resource resource) {
        try {
            this.securityChecker.saveResource(null, resource);
            return true;
        }
        catch (Exception e) {
            log.debug((Object)("No UPDATE permission for < " + resource.getURIString() + ">:" + e.getMessage()));
            return false;
        }
    }

    public boolean isRemovable(Resource resource) {
        try {
            this.securityChecker.deleteResource(null, resource.getURI());
            return true;
        }
        catch (Exception e) {
            log.debug((Object)("No DELETE permission for < " + resource.getURIString() + ">:" + e.getMessage()));
            return false;
        }
    }

    public boolean isResourceReadable(String uri) {
        try {
            this.securityChecker.getResource(null, uri);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFolderReadable(String uri) {
        try {
            this.securityChecker.getFolder(null, uri);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RepositoryService getSecurityChecker() {
        return this.securityChecker;
    }

    public void setSecurityChecker(RepositoryService securityChecker) {
        this.securityChecker = securityChecker;
    }
}

