/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.impl.NoSuchContainerException;
import org.apache.tiles.util.TilesIOException;

public final class ServletUtil {
    public static final String FORCE_INCLUDE_ATTRIBUTE_NAME = "org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE";
    public static final String CURRENT_CONTAINER_ATTRIBUTE_NAME = "org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY";

    private ServletUtil() {
    }

    public static boolean isForceInclude(HttpServletRequest request) {
        Boolean retValue = (Boolean)request.getAttribute(FORCE_INCLUDE_ATTRIBUTE_NAME);
        return retValue != null && retValue != false;
    }

    public static void setForceInclude(HttpServletRequest request, boolean forceInclude) {
        Boolean retValue = forceInclude;
        request.setAttribute(FORCE_INCLUDE_ATTRIBUTE_NAME, (Object)retValue);
    }

    public static TilesContainer getContainer(ServletContext context) {
        return ServletUtil.getContainer(context, "org.apache.tiles.CONTAINER");
    }

    public static TilesContainer getContainer(ServletContext context, String key) {
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        return (TilesContainer)context.getAttribute(key);
    }

    public static void setContainer(ServletContext context, TilesContainer container) {
        ServletUtil.setContainer(context, container, "org.apache.tiles.CONTAINER");
    }

    public static void setContainer(ServletContext context, TilesContainer container, String key) {
        Log log = LogFactory.getLog(ServletUtil.class);
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        if (container == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing TilesContext for context: " + context.getClass().getName()));
            }
            context.removeAttribute(key);
        }
        if (container != null && log.isInfoEnabled()) {
            log.info((Object)("Publishing TilesContext for context: " + context.getClass().getName()));
        }
        context.setAttribute(key, (Object)container);
    }

    public static void setCurrentContainer(ServletRequest request, ServletContext context, String key) {
        TilesContainer container = ServletUtil.getContainer(context, key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        request.setAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME, (Object)container);
    }

    public static void setCurrentContainer(ServletRequest request, ServletContext context, TilesContainer container) {
        if (container == null) {
            throw new NoSuchContainerException("The container cannot be null");
        }
        request.setAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME, (Object)container);
    }

    public static TilesContainer getCurrentContainer(ServletRequest request, ServletContext context) {
        TilesContainer container = (TilesContainer)request.getAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME);
        if (container == null) {
            container = ServletUtil.getContainer(context);
            request.setAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME, (Object)container);
        }
        return container;
    }

    public static IOException wrapServletException(ServletException ex, String message) {
        Throwable rootCause = ex.getRootCause();
        TilesIOException retValue = rootCause != null ? new TilesIOException(message, rootCause) : new TilesIOException(message, (Throwable)ex);
        return retValue;
    }
}

