/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator;

import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.AlignedTableCellRenderer;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.ElementValidationItem;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.UploadResourcesDialog;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class JrxmlValidationDialog
extends JDialog {
    private JServer server = null;
    private RepositoryReportUnit reportUnit = null;
    private List elementVelidationItems = null;
    private Report report = null;
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonDeselectAll;
    private JButton jButtonOk;
    private JButton jButtonSelectAll;
    private JButton jButtonSkip;
    private JCheckBox jCheckBoxDoNotShowAgain;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTable jTable1;

    public JrxmlValidationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        TableColumn dtcm = this.jTable1.getColumnModel().getColumn(0);
        dtcm.setMinWidth(22);
        dtcm.setMaxWidth(22);
        dtcm.setPreferredWidth(20);
        dtcm.setResizable(false);
        this.jTable1.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                JrxmlValidationDialog.this.updateContinue();
            }
        });
        dtcm = this.jTable1.getColumnModel().getColumn(1);
        dtcm.setMinWidth(100);
        dtcm.setPreferredWidth(100);
        dtcm.setCellRenderer(new AlignedTableCellRenderer(2));
        dtcm = this.jTable1.getColumnModel().getColumn(2);
        dtcm.setMinWidth(100);
        dtcm.setPreferredWidth(300);
        dtcm = this.jTable1.getColumnModel().getColumn(3);
        dtcm.setMinWidth(100);
        dtcm.setPreferredWidth(300);
        dtcm = this.jTable1.getColumnModel().getColumn(4);
        dtcm.setMinWidth(50);
        dtcm.setMaxWidth(100);
        dtcm.setPreferredWidth(80);
        dtcm.setCellRenderer(new AlignedTableCellRenderer(4));
        this.applyI18n();
        this.pack();
        Misc.centerFrame((Component)this);
    }

    public void applyI18n() {
        this.jButtonCancel.setText(IRPlugin.getString("jrxmlValidationDialog.buttonCancel", "Cancel"));
        this.jButtonDeselectAll.setText(IRPlugin.getString("jrxmlValidationDialog.buttonDeselectAll", "Deselect all"));
        this.jButtonOk.setText(IRPlugin.getString("jrxmlValidationDialog.buttonOk", "Continue"));
        this.jButtonSelectAll.setText(IRPlugin.getString("jrxmlValidationDialog.buttonSelectAll", "Select all"));
        this.jButtonSkip.setText(IRPlugin.getString("jrxmlValidationDialog.buttonSkip", "Skip this step"));
        this.jCheckBoxDoNotShowAgain.setText(IRPlugin.getString("jrxmlValidationDialog.checkDoNotShowAgain", "Do not show this window again"));
        this.jLabel1.setText(IRPlugin.getString("jrxmlValidationDialog.message", "<html>JasperServer Plugin has detected some locally referenced images in your report.<br>\nYou can choose to attach these images to the Report Unit importing them into the repository and replace the relative image expressions with an url like \"repo:myImage.jpg\".<br><b>Please check the images you want attach to this Report Unit</b>.</html>"));
        try {
            this.jTable1.getColumn("Image").setHeaderValue(IRPlugin.getString("jrxmlValidationDialog.table.image", "Image"));
            this.jTable1.getColumn("Local file").setHeaderValue(IRPlugin.getString("jrxmlValidationDialog.table.localFile", "Local file"));
            this.jTable1.getColumn("Proposed exp").setHeaderValue(IRPlugin.getString("jrxmlValidationDialog.table.proposedExpression", "Proposed exp"));
            this.jTable1.getColumn("File size").setHeaderValue(IRPlugin.getString("jrxmlValidationDialog.table.fileSize", "File size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jTable1.updateUI();
    }

    public void updateContinue() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            if (!((Boolean)this.jTable1.getValueAt(i, 0)).booleanValue()) continue;
            this.jButtonOk.setEnabled(true);
            return;
        }
        this.jButtonOk.setEnabled(false);
    }

    public void setElementVelidationItems(List items) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        dtm.setRowCount(0);
        DecimalFormat formatter = new DecimalFormat("#,##0");
        for (int i = 0; i < items.size(); ++i) {
            ElementValidationItem iev = (ElementValidationItem)items.get(i);
            String filesize = "";
            filesize = iev.getOriginalFileName().length() < 1024L ? formatter.format(iev.getOriginalFileName().length()) + " bytes" : formatter.format(iev.getOriginalFileName().length() / 1024L) + " KB";
            dtm.addRow(new Object[]{Boolean.TRUE, iev, iev.getOriginalFileName() + "", iev.getProposedExpression(), filesize});
        }
        this.elementVelidationItems = items;
    }

    public List getElementVelidationItems() {
        return this.elementVelidationItems;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jButtonSelectAll = new JButton();
        this.jButtonDeselectAll = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jCheckBoxDoNotShowAgain = new JCheckBox();
        this.jButtonOk = new JButton();
        this.jButtonSkip = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("JRXML validation");
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("<html>JasperServer Plugin has detected some locally referenced images in your report.<br>\nYou can choose to attach these images to the Report Unit importing them into the repository and replace the relative image expressions with an url like \"repo:myImage.jpg\".<br>\n<b>Please check the images you want attach to this Report Unit</b>.</html>");
        this.jLabel1.setMinimumSize(new Dimension(64, 60));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(452, 200));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Image", "Local file", "Proposed exp", "File size"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{true, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonSelectAll.setMnemonic('a');
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlValidationDialog.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonSelectAll, new GridBagConstraints());
        this.jButtonDeselectAll.setMnemonic('d');
        this.jButtonDeselectAll.setText("Deselect all");
        this.jButtonDeselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlValidationDialog.this.jButtonDeselectAllActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonDeselectAll, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jCheckBoxDoNotShowAgain.setMnemonic('n');
        this.jCheckBoxDoNotShowAgain.setText("Do not show this window again for this report");
        this.jCheckBoxDoNotShowAgain.setActionCommand("Do not show this window again");
        this.jCheckBoxDoNotShowAgain.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxDoNotShowAgain.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxDoNotShowAgain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlValidationDialog.this.jCheckBoxDoNotShowAgainActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jCheckBoxDoNotShowAgain, gridBagConstraints);
        this.jButtonOk.setMnemonic('O');
        this.jButtonOk.setText("Continue");
        this.jButtonOk.setEnabled(false);
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlValidationDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonSkip.setMnemonic('O');
        this.jButtonSkip.setText("Skip this step");
        this.jButtonSkip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlValidationDialog.this.jButtonOkActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonSkip, gridBagConstraints);
        this.jButtonCancel.setMnemonic('C');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlValidationDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void jButtonOkActionPerformed1(ActionEvent evt) {
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            if (!((Boolean)this.jTable1.getValueAt(i, 0)).booleanValue()) continue;
            selectedItems.add(this.jTable1.getValueAt(i, 1));
        }
        if (selectedItems.size() > 0) {
            UploadResourcesDialog urd = new UploadResourcesDialog((Frame)MainFrame.getMainInstance(), true);
            urd.setResourceItems(selectedItems);
            urd.setValidationDialog(this);
            urd.setVisible(true);
            return;
        }
        this.elaborationFinished(true);
    }

    public void elaborationFinished(boolean result) {
        this.dialogResult = result ? 0 : 2;
        this.setVisible(false);
        this.dispose();
    }

    private void jCheckBoxDoNotShowAgainActionPerformed(ActionEvent evt) {
        if (this.getReport() != null) {
            boolean found = false;
            for (int i = 0; i < this.getReport().getJRproperties().size(); ++i) {
                JRProperty prop = (JRProperty)this.getReport().getJRproperties().get(i);
                if (prop.getName() == null || !prop.getName().equals("com.jaspersoft.irplugin.validation")) continue;
                prop.setValue("0");
                found = true;
            }
            if (!found) {
                JRProperty prop = new JRProperty();
                prop.setName("com.jaspersoft.irplugin.validation");
                prop.setValue("0");
                this.getReport().getJRproperties().add(prop);
            }
            this.getReport().saveXMLFile();
        }
    }

    private void jButtonDeselectAllActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            this.jTable1.setValueAt(Boolean.FALSE, i, 0);
        }
        this.jTable1.updateUI();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            this.jTable1.setValueAt(Boolean.TRUE, i, 0);
        }
        this.jTable1.updateUI();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new JrxmlValidationDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public RepositoryReportUnit getReportUnit() {
        return this.reportUnit;
    }

    public void setReportUnit(RepositoryReportUnit reportUnit) {
        this.reportUnit = reportUnit;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

