/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.rest.test.RESTTestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTTest {
    private static final String USERNAME_PARAM = "j_username";
    private static final String PASS_PARAM = "j_password";
    private static final String ADMIN_USER_NAME = "jasperadmin";
    private static final String ADMIN_PASS = "jasperadmin";
    private static final String SCHEME = "http";
    private static final String HOST = "localhost";
    private static final int PORT = 8080;
    private static final String BASE_REST_URL = "/jasperserver/rest";
    private static final String RESOURCE_BASE_URL = "/resource";
    private static final String RESOURCES_BASE_URL = "/resources";
    private static final String LOGIN_CALL = "/login";
    protected static final String TEST_DIRECTORY = "/ContentFiles";
    protected static final String LIST_RESOURCES_PATH = "/resources/ContentFiles";
    protected static final String RESOURCE_CONTENT_PATH = "/resource/ContentFiles";
    protected static final String SAMPLE_FOLDER_SERVER_ACTUAL_PATH = "/ContentFiles/JUNIT_NEW_FOLDER";
    protected static final String SAMPLE_FOLDER_SERVER_PATH = "/resource/ContentFiles/JUNIT_NEW_FOLDER";
    protected static final String SAMPLE_DATA_TYPE_SERVER_PATH = "/resource/ContentFiles/JUNIT_DATA_TYPE";
    protected static final String SAMPLE_IMAGE_FILE_SERVER_PATH = "/resource/ContentFiles/JUNIT_IMAGE_FILE";
    protected static final String SAMPLE_INPUT_CONTROL_SERVER_PATH = "/resource/ContentFiles/JUNIT_INPUT_CONTROL";
    protected static final String SAMPLE_INPUT_CONTROL_WITH_LOCAL_RESOURCE_SERVER_PATH = "/resource/ContentFiles/JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE";
    protected static final String SAMPLE_INPUT_CONTROL_WITH_REFERENCES_ERVER_PATH = "/resource/ContentFiles/JUNIT_INPUT_CONTROL_CONTAINS_REFERENCE";
    protected static final String SAMPLE_JDBC_FILE_SERVER_PATH = "/resource/ContentFiles/JUNIT_JDBC";
    protected static final String SAMPLE_LIST_OF_VALUES_SERVER_PATH = "/resource/ContentFiles/JUNIT_LIST_OF_VALUES";
    protected static final String SAMPLE_OLAP_MONDRIAN_CON_SERVER_PATH = "/resource/ContentFiles/JUNIT_OLAP_CLIENT_CONNECTION_TEST";
    protected static final String SAMPLE_COMPLEX_REPORT_SERVER_PATH = "/resource/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH";
    protected static final String SAMPLE_PROPERTIES_SERVER_PATH = "/resource/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH";
    protected static final String LOCAL_RESOURCES_LOCATION = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources";
    private static final String LOCAL_NEW_RESOURCE_DESCRIPTORS_LOCATION = "/descriptors/new";
    private static final String LOCAL_UPDATE_RESOURCE_DESCRIPTORS_LOCATION = "/descriptors/update";
    protected static final String LOCAL_NEW_RDS = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new";
    protected static final String LOCAL_UPDATE_RDS = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update";
    protected static final String SAMPLE_FOLDER_RD = "/folder_URI.newFolder.xml";
    protected static final String SAMPLE_DATA_TYPE_RD = "/dataType_URI.datasources.DataType1.xml";
    protected static final String SAMPLE_IMAGE_FILE_RD = "/imageFile_URI.ContentFiles.myImage_1.xml";
    protected static final String SAMPLE_IMAGE_FILE_BIN = "/jasperSoftLogo.jpg";
    protected static final String SAMPLE_PROPERTIES_BIN = "/JUNIT_PROPERTIES.properties";
    protected static final String SAMPLE_INPUT_CONTROL_RD = "/inputControl_URI.ContentFiles.isMyInputControl.xml";
    protected static final String SAMPLE_INPUT_CONTROL_WITH_REFERENCE_RD = "/inputControl_URI.ContentFiles.JUNIT_INPUT_CONTROL_CONTAINS_REFERENCE.xml";
    protected static final String SAMPLE_INPUT_CONTROL_WITH_LOCAL_RESOURCE_RD = "/inputControl_URI.ContentFiles.JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE.xml";
    protected static final String SAMPLE_JDBC_FILE_RD = "/jdbc_URI.ContentFiles.New_JDBC.xml";
    protected static final String SAMPLE_LIST_OF_VALUES_RD = "/listOfValues_URI.ContentFiles.JUNIT_LIST_OF_VALUES.xml";
    protected static final String SAMPLE_OLAP_MONDRIAN_CON_RD = "/olapMondrianCon_URI.ContentFiles.OLAP_CLIENT_CONNECTION_TEST.xml";
    protected static final String SAMPLE_COMPOLEX_REPORT_UNIT_RD = "/reportUnit_URI.ContentFiles.COMPLEX_REPORT_UNIT_TEST.xml";
    protected static final String SAMPLE_PROPERITES_RD = "/properities_URI.ContentFiles.JUNIT_PROPERTIES.xml";
    protected static final String REQUEST_PARAMENTER_RD = "ResourceDescriptor";
    protected static final String REQUEST_PARAMENTER_RESOURCE_BIN = "ResourceBinaries";
    protected static final String REQUEST_SAMPLE_IMAGE_PATH = "/ContentFiles/JUNIT_IMAGE_FILE";
    protected static final String MOVE_TO = "moveTo";
    protected static final String COPY_TO = "copyTo";
    private HttpClient httpClient;
    private CookieStore cookieStore;
    private HttpContext httpContext;
    protected HttpRequestBase httpReq;
    protected HttpRequestBase tempHttpReq;
    protected HttpResponse httpRes;
    private final Log log = LogFactory.getLog(this.getClass());

    @Before
    public void setUp() {
        this.httpClient = new DefaultHttpClient();
        this.cookieStore = new BasicCookieStore();
        this.httpContext = new BasicHttpContext();
        this.httpContext.setAttribute("http.cookie-store", (Object)this.cookieStore);
        this.loginToServer();
    }

    @After
    public void tearDown() throws Exception {
        if (this.httpRes.getEntity().getContent().available() != 0) {
            this.httpRes.getEntity().getContent();
        }
        this.httpClient.getConnectionManager().closeExpiredConnections();
    }

    public void deleteResource(String uri) throws Exception {
        this.httpRes = this.executeCall((HttpRequestBase)new HttpDelete(), uri);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    protected void putSampleFolder() throws Exception {
        this.tempHttpReq = new HttpPut();
        String rdFileName = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml";
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream(new File(rdFileName)));
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.executeCall(this.tempHttpReq, SAMPLE_FOLDER_SERVER_PATH);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    protected void putSampleImageFileResource(String serverPath) throws Exception {
        this.tempHttpReq = new HttpPut();
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        String rdFileName = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/imageFile_URI.ContentFiles.myImage_1.xml";
        FileBody bin = new FileBody(new File("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperSoftLogo.jpg"));
        reqEntity.addPart(REQUEST_PARAMENTER_RD, (ContentBody)new StringBody(RESTTestUtils.getResourceDescriptor(new File(rdFileName))));
        reqEntity.addPart(REQUEST_SAMPLE_IMAGE_PATH, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.executeCall(this.tempHttpReq, serverPath);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    protected void putSampleFile(String rdPath, String binPath, String serverPath) throws Exception {
        this.tempHttpReq = new HttpPut();
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        String rdFileName = LOCAL_NEW_RDS + rdPath;
        FileBody bin = new FileBody(new File(LOCAL_RESOURCES_LOCATION + binPath));
        reqEntity.addPart(REQUEST_PARAMENTER_RD, (ContentBody)new StringBody(RESTTestUtils.getResourceDescriptor(new File(rdFileName))));
        reqEntity.addPart(REQUEST_SAMPLE_IMAGE_PATH, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.executeCall(this.tempHttpReq, serverPath);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    protected void putSampleResource(String rd_path, String call_path) throws Exception {
        this.tempHttpReq = new HttpPut();
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream(new File(LOCAL_NEW_RDS + rd_path)));
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.executeCall(this.tempHttpReq, call_path);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    private void loginToServer() {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair(USERNAME_PARAM, "jasperadmin"));
        qparams.add((NameValuePair)new BasicNameValuePair(PASS_PARAM, "jasperadmin"));
        try {
            this.httpReq = new HttpPost();
            this.executeCall(this.httpReq, LOGIN_CALL, qparams);
            IOUtils.toString((InputStream)this.httpRes.getEntity().getContent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected HttpResponse executeCall(HttpRequestBase req, String action_path) throws Exception {
        URI uri = this.createURI(action_path, null);
        req.setURI(uri);
        this.httpRes = this.httpClient.execute((HttpUriRequest)req, this.httpContext);
        return this.httpRes;
    }

    protected HttpResponse executeCall(HttpRequestBase req, String action_path, List<NameValuePair> qparams) throws Exception {
        req.setURI(this.createURI(action_path, qparams));
        this.httpRes = this.httpClient.execute((HttpUriRequest)req, this.httpContext);
        return this.httpRes;
    }

    private URI createURI(String action_path, List<NameValuePair> qparams) throws Exception {
        URI uri = qparams != null ? URIUtils.createURI((String)SCHEME, (String)HOST, (int)8080, (String)(BASE_REST_URL + action_path), (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null) : new URL(SCHEME, HOST, 8080, BASE_REST_URL + action_path).toURI();
        return uri;
    }

    protected boolean isValidResposnse() throws Exception {
        return this.isValidResposnse(200);
    }

    protected boolean isValidResposnse(int expected_respose_code) throws Exception {
        String body = EntityUtils.toString((HttpEntity)this.httpRes.getEntity());
        return this.httpRes.getStatusLine().getStatusCode() == expected_respose_code;
    }
}

