/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.rest.test.RESTTest;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GETTest
extends RESTTest {
    @Before
    public void setUp() {
        super.setUp();
        this.httpReq = new HttpGet();
    }

    @Test
    public void Get200ListResources() throws Exception {
        this.httpRes = this.executeCall(this.httpReq, "/resources/ContentFiles");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    @Test
    public void Get200ListResourcesWithTypeParameter() throws Exception {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("type", "olapMondrianCon"));
        this.httpRes = this.executeCall(this.httpReq, "/resources/analysis/connections", qparams);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    @Test
    public void Get200ListResourcesWithFileTypeParameter() throws Exception {
        this.putSampleImageFileResource("/resource/ContentFiles/JUNIT_IMAGE_FILE");
        this.putSampleFile("/properities_URI.ContentFiles.JUNIT_PROPERTIES.xml", "/JUNIT_PROPERTIES.properties", "/resource/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH");
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("type", "prop"));
        this.httpRes = this.executeCall(this.httpReq, "/ContentFiles", qparams);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
        this.deleteResource("/resource/ContentFiles/JUNIT_IMAGE_FILE");
        this.deleteResource("/resource/ContentFiles/JUNIT_REPORT_UNIT_SALES_BY_MONTH");
    }

    @Test
    public void Get404NonExistingResource() throws Exception {
        this.httpRes = this.executeCall(this.httpReq, "/resource/ContentFiles/A/Random/URL");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(404));
    }

    @Test
    public void Get404NonExistingResources() throws Exception {
        this.httpRes = this.executeCall(this.httpReq, "/resources/ContentFiles/A/Random/URL");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(404));
    }

    @Test
    public void Get200Job() throws Exception {
        this.httpRes = this.executeCall(this.httpReq, "/job/1");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    @Test
    public void Get200JobSummery() throws Exception {
        this.httpRes = this.executeCall(this.httpReq, "/jobsummeries/reports/samples/AllAccounts");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }
}

